/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Rational;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.annotation.AnyThread;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.ExperimentalUseCaseGroup;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.CameraController;
import androidx.camera.view.PreviewStreamStateObserver;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewViewImplementation;
import androidx.camera.view.PreviewViewMeteringPointFactory;
import androidx.camera.view.R;
import androidx.camera.view.SurfaceViewImplementation;
import androidx.camera.view.TextureViewImplementation;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.concurrent.atomic.AtomicReference;

public final class PreviewView
extends FrameLayout {
    private static final String TAG = "PreviewView";
    @ColorRes
    static final int DEFAULT_BACKGROUND_COLOR = 17170444;
    private static final ImplementationMode DEFAULT_IMPL_MODE = ImplementationMode.PERFORMANCE;
    @NonNull
    ImplementationMode mImplementationMode = DEFAULT_IMPL_MODE;
    @VisibleForTesting
    @Nullable
    PreviewViewImplementation mImplementation;
    @NonNull
    final PreviewTransformation mPreviewTransform = new PreviewTransformation();
    @NonNull
    final MutableLiveData<StreamState> mPreviewStreamStateLiveData = new MutableLiveData((Object)StreamState.IDLE);
    @Nullable
    final AtomicReference<PreviewStreamStateObserver> mActiveStreamStateObserver = new AtomicReference();
    CameraController mCameraController;
    @NonNull
    PreviewViewMeteringPointFactory mPreviewViewMeteringPointFactory = new PreviewViewMeteringPointFactory(this.mPreviewTransform);
    @NonNull
    private final ScaleGestureDetector mScaleGestureDetector;
    @Nullable
    private MotionEvent mTouchUpEvent;
    private final View.OnLayoutChangeListener mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
        boolean isSizeChanged;
        boolean bl = isSizeChanged = right - left != oldRight - oldLeft || bottom - top != oldBottom - oldTop;
        if (isSizeChanged) {
            this.redrawPreview();
            this.attachToControllerIfReady(true);
        }
    };
    final Preview.SurfaceProvider mSurfaceProvider = new Preview.SurfaceProvider(){

        @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
        @AnyThread
        public void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest) {
            if (!Threads.isMainThread()) {
                ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()).execute(() -> PreviewView.this.mSurfaceProvider.onSurfaceRequested(surfaceRequest));
                return;
            }
            Logger.d((String)PreviewView.TAG, (String)"Surface requested by Preview.");
            CameraInternal camera = surfaceRequest.getCamera();
            surfaceRequest.setTransformationInfoListener(ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()), transformationInfo -> {
                Logger.d((String)PreviewView.TAG, (String)("Preview transformation info updated. " + transformationInfo));
                boolean isFrontCamera = camera.getCameraInfoInternal().getLensFacing() == 0;
                PreviewView.this.mPreviewTransform.setTransformationInfo(transformationInfo, surfaceRequest.getResolution(), isFrontCamera);
                PreviewView.this.redrawPreview();
            });
            PreviewView.this.mImplementation = PreviewView.this.shouldUseTextureView(surfaceRequest, PreviewView.this.mImplementationMode) ? new TextureViewImplementation(PreviewView.this, PreviewView.this.mPreviewTransform) : new SurfaceViewImplementation(PreviewView.this, PreviewView.this.mPreviewTransform);
            PreviewStreamStateObserver streamStateObserver = new PreviewStreamStateObserver((CameraInfoInternal)camera.getCameraInfo(), PreviewView.this.mPreviewStreamStateLiveData, PreviewView.this.mImplementation);
            PreviewView.this.mActiveStreamStateObserver.set(streamStateObserver);
            camera.getCameraState().addObserver(ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()), (Observable.Observer)streamStateObserver);
            PreviewView.this.mImplementation.onSurfaceRequested(surfaceRequest, () -> {
                if (PreviewView.this.mActiveStreamStateObserver.compareAndSet(streamStateObserver, null)) {
                    streamStateObserver.updatePreviewStreamState(StreamState.IDLE);
                }
                streamStateObserver.clear();
                camera.getCameraState().removeObserver((Observable.Observer)streamStateObserver);
            });
        }
    };

    @UiThread
    public PreviewView(@NonNull Context context) {
        this(context, null);
    }

    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Threads.checkMainThread();
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PreviewView, defStyleAttr, defStyleRes);
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveAttributeDataForStyleable(context, R.styleable.PreviewView, attrs, attributes, defStyleAttr, defStyleRes);
        }
        try {
            int scaleTypeId = attributes.getInteger(R.styleable.PreviewView_scaleType, this.mPreviewTransform.getScaleType().getId());
            this.setScaleType(ScaleType.fromId(scaleTypeId));
            int implementationModeId = attributes.getInteger(R.styleable.PreviewView_implementationMode, DEFAULT_IMPL_MODE.getId());
            this.setImplementationMode(ImplementationMode.fromId(implementationModeId));
        }
        finally {
            attributes.recycle();
        }
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new PinchToZoomOnScaleGestureListener());
        if (this.getBackground() == null) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170444));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onAttachedToWindow();
        }
        this.attachToControllerIfReady(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onDetachedFromWindow();
        }
        if (this.mCameraController != null) {
            this.mCameraController.clearPreviewSurface();
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean notALongPress;
        if (this.mCameraController == null) {
            return super.onTouchEvent(event);
        }
        boolean isSingleTouch = event.getPointerCount() == 1;
        boolean isUpEvent = event.getAction() == 1;
        boolean bl = notALongPress = event.getEventTime() - event.getDownTime() < (long)ViewConfiguration.getLongPressTimeout();
        if (isSingleTouch && isUpEvent && notALongPress) {
            this.mTouchUpEvent = event;
            this.performClick();
            return true;
        }
        return this.mScaleGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean performClick() {
        if (this.mCameraController != null) {
            float x = this.mTouchUpEvent != null ? this.mTouchUpEvent.getX() : (float)this.getWidth() / 2.0f;
            float y = this.mTouchUpEvent != null ? this.mTouchUpEvent.getY() : (float)this.getHeight() / 2.0f;
            this.mCameraController.onTapToFocus(this.mPreviewViewMeteringPointFactory, x, y);
        }
        this.mTouchUpEvent = null;
        return super.performClick();
    }

    @UiThread
    public void setImplementationMode(@NonNull ImplementationMode implementationMode) {
        Threads.checkMainThread();
        this.mImplementationMode = implementationMode;
    }

    @UiThread
    @NonNull
    public ImplementationMode getImplementationMode() {
        Threads.checkMainThread();
        return this.mImplementationMode;
    }

    @UiThread
    @NonNull
    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    public Preview.SurfaceProvider getSurfaceProvider() {
        Threads.checkMainThread();
        return this.mSurfaceProvider;
    }

    @UiThread
    public void setScaleType(@NonNull ScaleType scaleType) {
        Threads.checkMainThread();
        this.mPreviewTransform.setScaleType(scaleType);
        this.redrawPreview();
    }

    @UiThread
    @NonNull
    public ScaleType getScaleType() {
        Threads.checkMainThread();
        return this.mPreviewTransform.getScaleType();
    }

    @UiThread
    @NonNull
    public MeteringPointFactory getMeteringPointFactory() {
        Threads.checkMainThread();
        return this.mPreviewViewMeteringPointFactory;
    }

    @NonNull
    public LiveData<StreamState> getPreviewStreamState() {
        return this.mPreviewStreamStateLiveData;
    }

    @UiThread
    @Nullable
    public Bitmap getBitmap() {
        Threads.checkMainThread();
        return this.mImplementation == null ? null : this.mImplementation.getBitmap();
    }

    @UiThread
    @Nullable
    @ExperimentalUseCaseGroup
    public ViewPort getViewPort() {
        Threads.checkMainThread();
        if (this.getDisplay() == null) {
            return null;
        }
        return this.getViewPort(this.getDisplay().getRotation());
    }

    @UiThread
    @SuppressLint(value={"WrongConstant"})
    @Nullable
    @ExperimentalUseCaseGroup
    public ViewPort getViewPort(int targetRotation) {
        Threads.checkMainThread();
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return null;
        }
        return new ViewPort.Builder(new Rational(this.getWidth(), this.getHeight()), targetRotation).setScaleType(this.getViewPortScaleType()).setLayoutDirection(this.getLayoutDirection()).build();
    }

    private int getViewPortScaleType() {
        switch (this.getScaleType()) {
            case FILL_END: {
                return 2;
            }
            case FILL_CENTER: {
                return 1;
            }
            case FILL_START: {
                return 0;
            }
            case FIT_END: 
            case FIT_CENTER: 
            case FIT_START: {
                return 3;
            }
        }
        throw new IllegalStateException("Unexpected scale type: " + (Object)((Object)this.getScaleType()));
    }

    void redrawPreview() {
        if (this.mImplementation != null) {
            this.mImplementation.redrawPreview();
        }
        this.mPreviewViewMeteringPointFactory.recalculate(new Size(this.getWidth(), this.getHeight()), this.getLayoutDirection());
    }

    boolean shouldUseTextureView(@NonNull SurfaceRequest surfaceRequest, @NonNull ImplementationMode implementationMode) {
        boolean isLegacyDevice = surfaceRequest.getCamera().getCameraInfo().getImplementationType().equals("androidx.camera.camera2.legacy");
        if (surfaceRequest.isRGBA8888Required() || Build.VERSION.SDK_INT <= 24 || isLegacyDevice) {
            return true;
        }
        switch (implementationMode) {
            case COMPATIBLE: {
                return true;
            }
            case PERFORMANCE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid implementation mode: " + (Object)((Object)implementationMode));
    }

    @UiThread
    public void setController(@Nullable CameraController cameraController) {
        Threads.checkMainThread();
        if (this.mCameraController != null && this.mCameraController != cameraController) {
            this.mCameraController.clearPreviewSurface();
        }
        this.mCameraController = cameraController;
        this.attachToControllerIfReady(false);
    }

    @Nullable
    @UiThread
    public CameraController getController() {
        Threads.checkMainThread();
        return this.mCameraController;
    }

    @UseExperimental(markerClass=ExperimentalUseCaseGroup.class)
    private void attachToControllerIfReady(boolean shouldFailSilently) {
        Display display = this.getDisplay();
        ViewPort viewPort = this.getViewPort();
        if (this.mCameraController != null && viewPort != null && this.isAttachedToWindow() && display != null) {
            try {
                this.mCameraController.attachPreviewSurface(this.getSurfaceProvider(), viewPort, display);
            }
            catch (IllegalStateException ex) {
                if (shouldFailSilently) {
                    Logger.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    class PinchToZoomOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        PinchToZoomOnScaleGestureListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (PreviewView.this.mCameraController != null) {
                PreviewView.this.mCameraController.onPinchToZoom(detector.getScaleFactor());
            }
            return true;
        }
    }

    public static enum StreamState {
        IDLE,
        STREAMING;

    }

    public static enum ScaleType {
        FILL_START(0),
        FILL_CENTER(1),
        FILL_END(2),
        FIT_START(3),
        FIT_CENTER(4),
        FIT_END(5);

        private final int mId;

        private ScaleType(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }

        static ScaleType fromId(int id) {
            for (ScaleType scaleType : ScaleType.values()) {
                if (scaleType.mId != id) continue;
                return scaleType;
            }
            throw new IllegalArgumentException("Unknown scale type id " + id);
        }
    }

    public static enum ImplementationMode {
        PERFORMANCE(0),
        COMPATIBLE(1);

        private final int mId;

        private ImplementationMode(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }

        static ImplementationMode fromId(int id) {
            for (ImplementationMode implementationMode : ImplementationMode.values()) {
                if (implementationMode.mId != id) continue;
                return implementationMode;
            }
            throw new IllegalArgumentException("Unknown implementation mode id " + id);
        }
    }
}

