/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.view.Display;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.preview.transform.SurfaceRotation;

final class RotationTransform {
    static final int ROTATION_AUTOMATIC = -1;

    private RotationTransform() {
    }

    static float getRotationDegrees(@NonNull View view, int deviceRotation) {
        if (deviceRotation != -1) {
            return SurfaceRotation.rotationDegreesFromSurfaceRotation(deviceRotation);
        }
        return RotationTransform.getRotationDegrees(view);
    }

    static float getRotationDegrees(@NonNull View view) {
        Display display = view.getDisplay();
        if (display == null) {
            return 0.0f;
        }
        int rotation = display.getRotation();
        return SurfaceRotation.rotationDegreesFromSurfaceRotation(rotation);
    }
}

