/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.video;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.VideoCapture;
import androidx.camera.view.video.AutoValue_OutputFileOptions;
import androidx.camera.view.video.ExperimentalVideo;
import androidx.camera.view.video.Metadata;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.io.File;

@RequiresApi(value=21)
@ExperimentalVideo
@AutoValue
public abstract class OutputFileOptions {
    private static final Metadata EMPTY_METADATA = Metadata.builder().build();

    OutputFileOptions() {
    }

    @NonNull
    public static Builder builder(@NonNull File file) {
        return new AutoValue_OutputFileOptions.Builder().setMetadata(EMPTY_METADATA).setFile(file);
    }

    @NonNull
    public static Builder builder(@NonNull ParcelFileDescriptor fileDescriptor) {
        Preconditions.checkArgument((Build.VERSION.SDK_INT >= 26 ? 1 : 0) != 0, (Object)"Using a ParcelFileDescriptor to record a video is only supported for Android 8.0 or above.");
        return new AutoValue_OutputFileOptions.Builder().setMetadata(EMPTY_METADATA).setFileDescriptor(fileDescriptor);
    }

    @NonNull
    public static Builder builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
        return new AutoValue_OutputFileOptions.Builder().setMetadata(EMPTY_METADATA).setContentResolver(contentResolver).setSaveCollection(saveCollection).setContentValues(contentValues);
    }

    @Nullable
    abstract File getFile();

    @Nullable
    abstract ParcelFileDescriptor getFileDescriptor();

    @Nullable
    abstract ContentResolver getContentResolver();

    @Nullable
    abstract Uri getSaveCollection();

    @Nullable
    abstract ContentValues getContentValues();

    @NonNull
    public abstract Metadata getMetadata();

    private boolean isSavingToMediaStore() {
        return this.getSaveCollection() != null && this.getContentResolver() != null && this.getContentValues() != null;
    }

    private boolean isSavingToFile() {
        return this.getFile() != null;
    }

    private boolean isSavingToFileDescriptor() {
        return this.getFileDescriptor() != null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public VideoCapture.OutputFileOptions toVideoCaptureOutputFileOptions() {
        VideoCapture.OutputFileOptions.Builder internalOutputFileOptionsBuilder;
        if (this.isSavingToFile()) {
            internalOutputFileOptionsBuilder = new VideoCapture.OutputFileOptions.Builder((File)Preconditions.checkNotNull((Object)this.getFile()));
        } else if (this.isSavingToFileDescriptor()) {
            internalOutputFileOptionsBuilder = new VideoCapture.OutputFileOptions.Builder(((ParcelFileDescriptor)Preconditions.checkNotNull((Object)this.getFileDescriptor())).getFileDescriptor());
        } else {
            Preconditions.checkState((boolean)this.isSavingToMediaStore());
            internalOutputFileOptionsBuilder = new VideoCapture.OutputFileOptions.Builder((ContentResolver)Preconditions.checkNotNull((Object)this.getContentResolver()), (Uri)Preconditions.checkNotNull((Object)this.getSaveCollection()), (ContentValues)Preconditions.checkNotNull((Object)this.getContentValues()));
        }
        VideoCapture.Metadata internalMetadata = new VideoCapture.Metadata();
        internalMetadata.location = this.getMetadata().getLocation();
        internalOutputFileOptionsBuilder.setMetadata(internalMetadata);
        return internalOutputFileOptionsBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        abstract Builder setFile(@Nullable File var1);

        abstract Builder setFileDescriptor(@Nullable ParcelFileDescriptor var1);

        abstract Builder setContentResolver(@Nullable ContentResolver var1);

        abstract Builder setSaveCollection(@Nullable Uri var1);

        abstract Builder setContentValues(@Nullable ContentValues var1);

        @NonNull
        public abstract Builder setMetadata(@NonNull Metadata var1);

        @NonNull
        public abstract OutputFileOptions build();
    }
}

