/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewView;
import androidx.camera.view.PreviewViewImplementation;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@RequiresApi(value=21)
final class SurfaceViewImplementation
extends PreviewViewImplementation {
    private static final String TAG = "SurfaceViewImpl";
    private static final int SCREENSHOT_TIMEOUT_MILLIS = 100;
    SurfaceView mSurfaceView;
    final SurfaceRequestCallback mSurfaceRequestCallback = new SurfaceRequestCallback();

    SurfaceViewImplementation(@NonNull FrameLayout parent, @NonNull PreviewTransformation previewTransform) {
        super(parent, previewTransform);
    }

    @Override
    void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest, @Nullable PreviewViewImplementation.OnSurfaceNotInUseListener onSurfaceNotInUseListener) {
        if (!SurfaceViewImplementation.shouldReusePreview(this.mSurfaceView, this.mResolution, surfaceRequest)) {
            this.mResolution = surfaceRequest.getResolution();
            this.initializePreview();
        }
        if (onSurfaceNotInUseListener != null) {
            surfaceRequest.addRequestCancellationListener(ContextCompat.getMainExecutor((Context)this.mSurfaceView.getContext()), onSurfaceNotInUseListener::onSurfaceNotInUse);
        }
        this.mSurfaceView.post(() -> this.mSurfaceRequestCallback.setSurfaceRequest(surfaceRequest, onSurfaceNotInUseListener));
    }

    @Override
    void initializePreview() {
        Preconditions.checkNotNull((Object)this.mParent);
        Preconditions.checkNotNull((Object)this.mResolution);
        this.mSurfaceView = new SurfaceView(this.mParent.getContext());
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mResolution.getWidth(), this.mResolution.getHeight()));
        this.mParent.removeAllViews();
        this.mParent.addView((View)this.mSurfaceView);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this.mSurfaceRequestCallback);
    }

    @Override
    @Nullable
    View getPreview() {
        return this.mSurfaceView;
    }

    @Override
    void onAttachedToWindow() {
    }

    @Override
    void onDetachedFromWindow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(value=24)
    @Nullable
    Bitmap getPreviewBitmap() {
        if (this.mSurfaceView == null || this.mSurfaceView.getHolder().getSurface() == null || !this.mSurfaceView.getHolder().getSurface().isValid()) {
            return null;
        }
        Semaphore screenshotLock = new Semaphore(0);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mSurfaceView.getWidth(), (int)this.mSurfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        HandlerThread backgroundThread = new HandlerThread("pixelCopyRequest Thread");
        backgroundThread.start();
        Handler backgroundHandler = new Handler(backgroundThread.getLooper());
        Api24Impl.pixelCopyRequest(this.mSurfaceView, bitmap, copyResult -> {
            if (copyResult == 0) {
                Logger.d((String)TAG, (String)"PreviewView.SurfaceViewImplementation.getBitmap() succeeded");
            } else {
                Logger.e((String)TAG, (String)("PreviewView.SurfaceViewImplementation.getBitmap() failed with error " + copyResult));
            }
            screenshotLock.release();
        }, backgroundHandler);
        try {
            boolean success = screenshotLock.tryAcquire(1, 100L, TimeUnit.MILLISECONDS);
            if (!success) {
                Logger.e((String)TAG, (String)"Timed out while trying to acquire screenshot.");
            }
        }
        catch (InterruptedException e) {
            Logger.e((String)TAG, (String)"Interrupted while trying to acquire screenshot.", (Throwable)e);
        }
        finally {
            backgroundThread.quitSafely();
        }
        return bitmap;
    }

    @Override
    @NonNull
    ListenableFuture<Void> waitForNextFrame() {
        return Futures.immediateFuture(null);
    }

    @Override
    void setFrameUpdateListener(@NonNull Executor executor, @NonNull PreviewView.OnFrameUpdateListener listener) {
        throw new IllegalArgumentException("SurfaceView doesn't support frame update listener");
    }

    private static boolean shouldReusePreview(@Nullable SurfaceView surfaceView, @Nullable Size resolution, @NonNull SurfaceRequest surfaceRequest) {
        boolean isSameResolution = Objects.equals(resolution, surfaceRequest.getResolution());
        return surfaceView != null && isSameResolution;
    }

    @RequiresApi(value=21)
    class SurfaceRequestCallback
    implements SurfaceHolder.Callback {
        @Nullable
        private Size mTargetSize;
        @Nullable
        private SurfaceRequest mSurfaceRequest;
        @Nullable
        private SurfaceRequest mSurfaceRequestToBeInvalidated;
        @Nullable
        private PreviewViewImplementation.OnSurfaceNotInUseListener mOnSurfaceNotInUseListener;
        @Nullable
        private Size mCurrentSurfaceSize;
        private boolean mWasSurfaceProvided = false;
        private boolean mNeedToInvalidate = false;

        SurfaceRequestCallback() {
        }

        @UiThread
        void setSurfaceRequest(@NonNull SurfaceRequest surfaceRequest, @Nullable PreviewViewImplementation.OnSurfaceNotInUseListener onSurfaceNotInUseListener) {
            this.cancelPreviousRequest();
            if (this.mNeedToInvalidate) {
                this.mNeedToInvalidate = false;
                surfaceRequest.invalidate();
            } else {
                Size targetSize;
                this.mSurfaceRequest = surfaceRequest;
                this.mOnSurfaceNotInUseListener = onSurfaceNotInUseListener;
                this.mTargetSize = targetSize = surfaceRequest.getResolution();
                this.mWasSurfaceProvided = false;
                if (!this.tryToComplete()) {
                    Logger.d((String)SurfaceViewImplementation.TAG, (String)"Wait for new Surface creation.");
                    SurfaceViewImplementation.this.mSurfaceView.getHolder().setFixedSize(targetSize.getWidth(), targetSize.getHeight());
                }
            }
        }

        @UiThread
        private boolean tryToComplete() {
            Surface surface = SurfaceViewImplementation.this.mSurfaceView.getHolder().getSurface();
            if (this.canProvideSurface()) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface set on Preview.");
                PreviewViewImplementation.OnSurfaceNotInUseListener listener = this.mOnSurfaceNotInUseListener;
                Objects.requireNonNull(this.mSurfaceRequest).provideSurface(surface, ContextCompat.getMainExecutor((Context)SurfaceViewImplementation.this.mSurfaceView.getContext()), result -> {
                    Logger.d((String)SurfaceViewImplementation.TAG, (String)"Safe to release surface.");
                    if (listener != null) {
                        listener.onSurfaceNotInUse();
                    }
                });
                this.mWasSurfaceProvided = true;
                SurfaceViewImplementation.this.onSurfaceProvided();
                return true;
            }
            return false;
        }

        private boolean canProvideSurface() {
            return !this.mWasSurfaceProvided && this.mSurfaceRequest != null && Objects.equals(this.mTargetSize, this.mCurrentSurfaceSize);
        }

        @UiThread
        private void cancelPreviousRequest() {
            if (this.mSurfaceRequest != null) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)("Request canceled: " + this.mSurfaceRequest));
                this.mSurfaceRequest.willNotProvideSurface();
            }
        }

        @UiThread
        private void closeSurface() {
            if (this.mSurfaceRequest != null) {
                Logger.d((String)SurfaceViewImplementation.TAG, (String)("Surface closed " + this.mSurfaceRequest));
                this.mSurfaceRequest.getDeferrableSurface().close();
            }
        }

        public void surfaceCreated(@NonNull SurfaceHolder surfaceHolder) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface created.");
            if (this.mNeedToInvalidate && this.mSurfaceRequestToBeInvalidated != null) {
                this.mSurfaceRequestToBeInvalidated.invalidate();
                this.mSurfaceRequestToBeInvalidated = null;
                this.mNeedToInvalidate = false;
            }
        }

        public void surfaceChanged(@NonNull SurfaceHolder surfaceHolder, int format, int width, int height) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)("Surface changed. Size: " + width + "x" + height));
            this.mCurrentSurfaceSize = new Size(width, height);
            this.tryToComplete();
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder surfaceHolder) {
            Logger.d((String)SurfaceViewImplementation.TAG, (String)"Surface destroyed.");
            if (this.mWasSurfaceProvided) {
                this.closeSurface();
            } else {
                this.cancelPreviousRequest();
            }
            this.mNeedToInvalidate = true;
            if (this.mSurfaceRequest != null) {
                this.mSurfaceRequestToBeInvalidated = this.mSurfaceRequest;
            }
            this.mWasSurfaceProvided = false;
            this.mSurfaceRequest = null;
            this.mOnSurfaceNotInUseListener = null;
            this.mCurrentSurfaceSize = null;
            this.mTargetSize = null;
        }
    }

    @RequiresApi(value=24)
    private static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void pixelCopyRequest(@NonNull SurfaceView source, @NonNull Bitmap dest, @NonNull PixelCopy.OnPixelCopyFinishedListener listener, @NonNull Handler handler) {
            PixelCopy.request((SurfaceView)source, (Bitmap)dest, (PixelCopy.OnPixelCopyFinishedListener)listener, (Handler)handler);
        }
    }
}

