/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.ExperimentalAnimationSpecApi;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\f2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J(\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\f2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "([FLjava/util/List;)V", "isExtrapolate", "", "slopeTemp", "tangents", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "timePoints", "values", "copyData", "diff", "", "h", "x", "y1", "y2", "t1", "t2", "getPos", "", "t", "v", "Landroidx/compose/animation/core/AnimationVector;", "j", "", "getSlope", "interpolate", "makeFloatArray", "a", "b", "animation-core_release"})
@ExperimentalAnimationSpecApi
@StabilityInferred(parameters=0)
public final class MonoSpline {
    @NotNull
    private final float[] timePoints;
    @NotNull
    private final ArrayList<float[]> values;
    @NotNull
    private final ArrayList<float[]> tangents;
    private final boolean isExtrapolate;
    @NotNull
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(@NotNull float[] time, @NotNull List<float[]> y) {
        this.isExtrapolate = true;
        int n = time.length;
        int dim = y.get(0).length;
        this.slopeTemp = new float[dim];
        ArrayList<float[]> slope = this.makeFloatArray(n - 1, dim);
        ArrayList<float[]> tangent = this.makeFloatArray(n, dim);
        for (int j = 0; j < dim; ++j) {
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                float dt = time[i + 1] - time[i];
                slope.get((int)i)[j] = (y.get(i + 1)[j] - y.get(i)[j]) / dt;
                tangent.get((int)i)[j] = i == 0 ? slope.get(i)[j] : (slope.get(i - 1)[j] + slope.get(i)[j]) * 0.5f;
            }
            tangent.get((int)(n - 1))[j] = slope.get(n - 2)[j];
        }
        int n3 = n - 1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < dim; ++j) {
                float b;
                if (slope.get(i)[j] == 0.0f) {
                    tangent.get((int)i)[j] = 0.0f;
                    tangent.get((int)(i + 1))[j] = 0.0f;
                    continue;
                }
                float a = tangent.get(i)[j] / slope.get(i)[j];
                float h = (float)Math.hypot(a, b = tangent.get(i + 1)[j] / slope.get(i)[j]);
                if (!((double)h > 9.0)) continue;
                float t = 3.0f / h;
                tangent.get((int)i)[j] = t * a * slope.get(i)[j];
                tangent.get((int)(i + 1))[j] = t * b * slope.get(i)[j];
            }
        }
        this.timePoints = time;
        this.values = this.copyData(y);
        this.tangents = tangent;
    }

    private final ArrayList<float[]> makeFloatArray(int a, int b) {
        ArrayList<float[]> ret = new ArrayList<float[]>();
        for (int i = 0; i < a; ++i) {
            ret.add(new float[b]);
        }
        return ret;
    }

    private final ArrayList<float[]> copyData(List<float[]> y) {
        ArrayList<float[]> ret = new ArrayList<float[]>();
        ret.addAll((Collection)y);
        return ret;
    }

    public final void getPos(float t, @NotNull float[] v) {
        int n = this.timePoints.length;
        int dim = this.values.get(0).length;
        if (this.isExtrapolate) {
            if (t <= this.timePoints[0]) {
                this.getSlope(this.timePoints[0], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.values.get(0)[j] + (t - this.timePoints[0]) * this.slopeTemp[j];
                }
                return;
            }
            if (t >= this.timePoints[n - 1]) {
                this.getSlope(this.timePoints[n - 1], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.values.get(n - 1)[j] + (t - this.timePoints[n - 1]) * this.slopeTemp[j];
                }
                return;
            }
        } else {
            if (t <= this.timePoints[0]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.values.get(0)[j];
                }
                return;
            }
            if (t >= this.timePoints[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.values.get(n - 1)[j];
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.timePoints[i]) {
                for (int j = 0; j < dim; ++j) {
                    v[j] = this.values.get(i)[j];
                }
            }
            if (!(t < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values.get(i)[j];
                float y2 = this.values.get(i + 1)[j];
                float t1 = this.tangents.get(i)[j];
                float t2 = this.tangents.get(i + 1)[j];
                v[j] = this.interpolate(h, x, y1, y2, t1, t2);
            }
            return;
        }
    }

    public final float getPos(float t, int j) {
        int n = this.timePoints.length;
        if (this.isExtrapolate) {
            if (t <= this.timePoints[0]) {
                return this.values.get(0)[j] + (t - this.timePoints[0]) * this.getSlope(this.timePoints[0], j);
            }
            if (t >= this.timePoints[n - 1]) {
                return this.values.get(n - 1)[j] + (t - this.timePoints[n - 1]) * this.getSlope(this.timePoints[n - 1], j);
            }
        } else {
            if (t <= this.timePoints[0]) {
                return this.values.get(0)[j];
            }
            if (t >= this.timePoints[n - 1]) {
                return this.values.get(n - 1)[j];
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.timePoints[i]) {
                return this.values.get(i)[j];
            }
            if (!(t < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            float y1 = this.values.get(i)[j];
            float y2 = this.values.get(i + 1)[j];
            float t1 = this.tangents.get(i)[j];
            float t2 = this.tangents.get(i + 1)[j];
            return this.interpolate(h, x, y1, y2, t1, t2);
        }
        return 0.0f;
    }

    public final void getPos(float t, @NotNull AnimationVector v) {
        int n = this.timePoints.length;
        int dim = this.values.get(0).length;
        if (this.isExtrapolate) {
            if (t <= this.timePoints[0]) {
                this.getSlope(this.timePoints[0], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core_release(j, this.values.get(0)[j] + (t - this.timePoints[0]) * this.slopeTemp[j]);
                }
                return;
            }
            if (t >= this.timePoints[n - 1]) {
                this.getSlope(this.timePoints[n - 1], this.slopeTemp);
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core_release(j, this.values.get(n - 1)[j] + (t - this.timePoints[n - 1]) * this.slopeTemp[j]);
                }
                return;
            }
        } else {
            if (t <= this.timePoints[0]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core_release(j, this.values.get(0)[j]);
                }
                return;
            }
            if (t >= this.timePoints[n - 1]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core_release(j, this.values.get(n - 1)[j]);
                }
                return;
            }
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (t == this.timePoints[i]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core_release(j, this.values.get(i)[j]);
                }
            }
            if (!(t < this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values.get(i)[j];
                float y2 = this.values.get(i + 1)[j];
                float t1 = this.tangents.get(i)[j];
                float t2 = this.tangents.get(i + 1)[j];
                v.set$animation_core_release(j, this.interpolate(h, x, y1, y2, t1, t2));
            }
            return;
        }
    }

    public final void getSlope(float time, @NotNull float[] v) {
        float t = time;
        int n = this.timePoints.length;
        int dim = this.values.get(0).length;
        if (t <= this.timePoints[0]) {
            t = this.timePoints[0];
        } else if (t >= this.timePoints[n - 1]) {
            t = this.timePoints[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values.get(i)[j];
                float y2 = this.values.get(i + 1)[j];
                float t1 = this.tangents.get(i)[j];
                float t2 = this.tangents.get(i + 1)[j];
                v[j] = this.diff(h, x, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    public final void getSlope(float time, @NotNull AnimationVector v) {
        float t = time;
        int n = this.timePoints.length;
        int dim = this.values.get(0).length;
        if (t <= this.timePoints[0]) {
            t = this.timePoints[0];
        } else if (t >= this.timePoints[n - 1]) {
            t = this.timePoints[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values.get(i)[j];
                float y2 = this.values.get(i + 1)[j];
                float t1 = this.tangents.get(i)[j];
                float t2 = this.tangents.get(i + 1)[j];
                v.set$animation_core_release(j, this.diff(h, x, y1, y2, t1, t2) / h);
            }
            break;
        }
    }

    private final float getSlope(float time, int j) {
        float t = time;
        int n = this.timePoints.length;
        if (t < this.timePoints[0]) {
            t = this.timePoints[0];
        } else if (t >= this.timePoints[n - 1]) {
            t = this.timePoints[n - 1];
        }
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (!(t <= this.timePoints[i + 1])) continue;
            float h = this.timePoints[i + 1] - this.timePoints[i];
            float x = (t - this.timePoints[i]) / h;
            float y1 = this.values.get(i)[j];
            float y2 = this.values.get(i + 1)[j];
            float t1 = this.tangents.get(i)[j];
            float t2 = this.tangents.get(i + 1)[j];
            return this.diff(h, x, y1, y2, t1, t2) / h;
        }
        return 0.0f;
    }

    private final float interpolate(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        float x3 = x2 * x;
        return (float)-2 * x3 * y2 + (float)3 * x2 * y2 + (float)2 * x3 * y1 - (float)3 * x2 * y1 + y1 + h * t2 * x3 + h * t1 * x3 - h * t2 * x2 - (float)2 * h * t1 * x2 + h * t1 * x;
    }

    private final float diff(float h, float x, float y1, float y2, float t1, float t2) {
        float x2 = x * x;
        return (float)-6 * x2 * y2 + (float)6 * x * y2 + (float)6 * x2 * y1 - (float)6 * x * y1 + (float)3 * h * t2 * x2 + (float)3 * h * t1 * x2 - (float)2 * h * t2 * x - (float)4 * h * t1 * x + h * t1;
    }
}

