/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core.lint;

import androidx.compose.animation.core.lint.TransitionDetectorKt;
import androidx.compose.lint.KotlinUtilsKt;
import androidx.compose.lint.UnreferencedParameter;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UParameter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/animation/core/lint/TransitionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "animation-core-lint"})
public final class TransitionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnusedTransitionTargetStateParameter = Issue.Companion.create("UnusedTransitionTargetStateParameter", "Transition.animate* calls should use the provided targetState when defining values", "Transition.animate* functions provide a target state parameter in the lambda that will be used to calculate the value for a given state. This target state parameter in the lambda may or may not be the same as the actual state, as the animation system occasionally needs to look up target values for other states to do proper seeking/tooling preview. Relying on other state than the provided `targetState` could also result in unnecessary recompositions. Therefore, it is generally considered an error if this `targetState` parameter is not used.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(TransitionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                v0 = node.resolve();
                if (v0 == null) {
                    return;
                }
                method = v0;
                var5_3 /* !! */  = node.getReceiverType();
                v1 = var5_3 /* !! */  instanceof PsiClassReferenceType != false ? (PsiClassReferenceType)var5_3 /* !! */  : null;
                if (v1 == null) {
                    return;
                }
                receiverType = v1;
                if (!receiverType.rawType().equalsToText(TransitionDetectorKt.access$getTransition$p().getJavaFqn())) {
                    return;
                }
                v2 = node.getMethodName();
                if (!(v2 != null ? StringsKt.startsWith$default((String)v2, (String)"animate", (boolean)false, (int)2, null) : false)) {
                    return;
                }
                var5_3 /* !! */  = node.getValueArguments();
                $i$f$filterIsInstance = false;
                var7_7 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    argument = (ULambdaExpression)element$iv$iv;
                    $i$a$-filter-TransitionDetector$createUastHandler$1$visitCallExpression$matchingLambdaArguments$1 = false;
                    parameters = argument.getValueParameters();
                    if (parameters.size() != 1) {
                        v3 = false;
                    } else {
                        parameter = (UParameter)CollectionsKt.first((List)parameters);
                        type = parameter.getType();
                        boxedType = type instanceof PsiPrimitiveType != false ? (PsiType)((PsiPrimitiveType)type).getBoxedType((PsiElement)method) : type;
                        v3 = Intrinsics.areEqual((Object)boxedType, (Object)receiverType.getParameters()[0]);
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                matchingLambdaArguments = (List)destination$iv$iv;
                $this$filter$iv = matchingLambdaArguments;
                var6_6 = this.$context;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    lambda = (ULambdaExpression)element$iv;
                    $i$a$-forEach-TransitionDetector$createUastHandler$1$visitCallExpression$1 = false;
                    $this$forEach$iv = KotlinUtilsKt.findUnreferencedParameters(lambda);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        unreferencedParameter = (UnreferencedParameter)element$iv;
                        $i$a$-forEach-TransitionDetector$createUastHandler$1$visitCallExpression$1$1 = false;
                        var18_23 = unreferencedParameter.getParameter();
                        if (var18_23 == null) ** GOTO lbl-1000
                        it = var18_23;
                        $i$a$-let-TransitionDetector$createUastHandler$1$visitCallExpression$1$1$location$1 = false;
                        var21_26 = var6_6.getLocation((PsiElement)it);
                        if (var21_26 != null) {
                            v4 = var21_26;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = var6_6.getLocation((UElement)lambda);
                        }
                        location = v4;
                        name = unreferencedParameter.getName();
                        JavaContext.report$default((JavaContext)var6_6, (Issue)TransitionDetector.Companion.getUnusedTransitionTargetStateParameter(), (UElement)((UElement)node), (Location)location, (String)("Target state parameter `" + name + "` is not used"), null, (int)16, null);
                    }
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/core/lint/TransitionDetector$Companion;", "", "()V", "UnusedTransitionTargetStateParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedTransitionTargetStateParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "animation-core-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnusedTransitionTargetStateParameter() {
            return UnusedTransitionTargetStateParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

