/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntListKt;
import androidx.collection.IntObjectMapKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.ExperimentalAnimationSpecApi;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframesSpec;
import androidx.compose.runtime.Immutable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\b\b\u0001\u0010\u0019*\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00190\u001cH\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Landroidx/compose/animation/core/ArcAnimationSpec;", "T", "Landroidx/compose/animation/core/DurationBasedAnimationSpec;", "mode", "Landroidx/compose/animation/core/ArcMode;", "durationMillis", "", "delayMillis", "easing", "Landroidx/compose/animation/core/Easing;", "(Landroidx/compose/animation/core/ArcMode;IILandroidx/compose/animation/core/Easing;)V", "getDelayMillis", "()I", "getDurationMillis", "getEasing", "()Landroidx/compose/animation/core/Easing;", "getMode", "()Landroidx/compose/animation/core/ArcMode;", "equals", "", "other", "", "hashCode", "vectorize", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "animation-core_release"})
@ExperimentalAnimationSpecApi
@Immutable
public final class ArcAnimationSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final ArcMode mode;
    private final int durationMillis;
    private final int delayMillis;
    @NotNull
    private final Easing easing;
    public static final int $stable;

    public ArcAnimationSpec(@NotNull ArcMode mode, int durationMillis, int delayMillis, @NotNull Easing easing) {
        this.mode = mode;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
        this.easing = easing;
    }

    public /* synthetic */ ArcAnimationSpec(ArcMode arcMode, int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            arcMode = ArcMode.Companion.ArcBelow.INSTANCE;
        }
        if ((n3 & 2) != 0) {
            n = 300;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(arcMode, n, n2, easing);
    }

    @NotNull
    public final ArcMode getMode() {
        return this.mode;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final int getDelayMillis() {
        return this.delayMillis;
    }

    @NotNull
    public final Easing getEasing() {
        return this.easing;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedDurationBasedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        return new VectorizedKeyframesSpec(IntListKt.intListOf((int)0, (int)this.durationMillis), IntObjectMapKt.emptyIntObjectMap(), this.durationMillis, this.delayMillis, this.easing, this.mode);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArcAnimationSpec)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mode, (Object)((ArcAnimationSpec)other).mode)) {
            return false;
        }
        if (this.durationMillis != ((ArcAnimationSpec)other).durationMillis) {
            return false;
        }
        if (this.delayMillis != ((ArcAnimationSpec)other).delayMillis) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.easing, (Object)((ArcAnimationSpec)other).easing);
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + this.durationMillis;
        result = 31 * result + this.delayMillis;
        result = 31 * result + this.easing.hashCode();
        return result;
    }

    public ArcAnimationSpec() {
        this(null, 0, 0, null, 15, null);
    }
}

