/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTree;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/compose/animation/core/PathEasing;", "Landroidx/compose/animation/core/Easing;", "path", "Landroidx/compose/ui/graphics/Path;", "(Landroidx/compose/ui/graphics/Path;)V", "intervals", "Landroidx/compose/ui/graphics/IntervalTree;", "Landroidx/compose/ui/graphics/PathSegment;", "transform", "", "fraction", "animation-core_release"})
@Immutable
@SourceDebugExtension(value={"SMAP\nPathEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathEasing.kt\nandroidx/compose/animation/core/PathEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,117:1\n33#2,7:118\n33#2,7:128\n66#2,8:135\n54#2,7:143\n48#3:125\n54#3:127\n22#4:126\n71#5,16:150\n*S KotlinDebug\n*F\n+ 1 PathEasing.kt\nandroidx/compose/animation/core/PathEasing\n*L\n85#1:118,7\n97#1:128,7\n105#1:135,8\n110#1:143,7\n92#1:125\n92#1:127\n92#1:126\n114#1:150,16\n*E\n"})
public final class PathEasing
implements Easing {
    @NotNull
    private final Path path;
    private IntervalTree<PathSegment> intervals;
    public static final int $stable;

    public PathEasing(@NotNull Path path) {
        this.path = path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float transform(float fraction) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        void value$iv22;
        IntervalTree<PathSegment> intervalTree;
        if (fraction <= 0.0f) {
            return 0.0f;
        }
        if (fraction >= 1.0f) {
            return 1.0f;
        }
        if (this.intervals == null) {
            IntervalTree intervalTree2;
            float[] roots = new float[5];
            IntervalTree $this$transform_u24lambda_u241 = intervalTree2 = new IntervalTree();
            boolean bl = false;
            PathIterator iterator = this.path.iterator(PathIterator.ConicEvaluation.AsQuadratics, 2.0E-4f);
            while (iterator.hasNext()) {
                PathSegment segment = iterator.next();
                boolean value$iv = segment.getType() != PathSegment.Type.Close;
                boolean $i$f$requirePrecondition = false;
                if (!value$iv) {
                    boolean bl2 = false;
                    PreconditionsKt.throwIllegalArgumentException("The path cannot contain a close() command.");
                }
                if (segment.getType() == PathSegment.Type.Move || segment.getType() == PathSegment.Type.Done) continue;
                long bounds = BezierKt.computeHorizontalBounds$default((PathSegment)segment, (float[])roots, (int)0, (int)4, null);
                boolean bl3 = false;
                int bits$iv$iv = (int)(bounds >> 32);
                boolean $i$f$floatFromBits = false;
                float f = Float.intBitsToFloat(bits$iv$iv);
                boolean bl4 = false;
                bits$iv$iv = (int)(bounds & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                $this$transform_u24lambda_u241.addInterval(f, Float.intBitsToFloat(bits$iv$iv), (Object)segment);
            }
            IntervalTree segmentIntervals = intervalTree2;
            boolean value$iv = segmentIntervals.contains(0.0f) && segmentIntervals.contains(1.0f);
            boolean $i$f$requirePrecondition = false;
            if (!value$iv) {
                boolean bl5 = false;
                PreconditionsKt.throwIllegalArgumentException("The easing path must start at 0.0f and end at 1.0f.");
            }
            this.intervals = segmentIntervals;
        }
        if ((intervalTree = this.intervals) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"intervals");
            intervalTree = null;
        }
        Interval result = IntervalTree.findFirstOverlap$default(intervalTree, (float)fraction, (float)0.0f, (int)2, null);
        Object value$iv = result.getData();
        boolean $i$f$checkPreconditionNotNull = false;
        if (value$iv == null) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateExceptionForNullCheck("The easing path is invalid. Make sure it is continuous on the x axis.");
            throw new KotlinNothingValueException();
        }
        PathSegment segment = (PathSegment)value$iv;
        float t = BezierKt.findFirstRoot((PathSegment)segment, (float)fraction);
        $i$f$checkPreconditionNotNull = !Float.isNaN(t);
        boolean $i$f$checkPrecondition22 = false;
        if (value$iv22 == false) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("The easing path is invalid. Make sure it does not contain NaN/Infinity values.");
        }
        float value$iv22 = BezierKt.evaluateY((PathSegment)segment, (float)t);
        float $i$f$checkPrecondition22 = 0.0f;
        float maximumValue$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        return $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
    }
}

