/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.IntListExtensionKt;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B9\b\u0016\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bBC\b\u0000\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000e\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u0006H\u0002J \u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H\u0002J-\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J-\u00108\u001a\u00028\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J%\u00109\u001a\u00020:2\u0006\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010;R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010#\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u001e\u0010$\u001a\u00020\u0006*\u00020\u00128BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006<"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "(Ljava/util/Map;II)V", "timestamps", "Landroidx/collection/IntList;", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/animation/core/VectorizedKeyframeSpecElementInfo;", "defaultEasing", "initialArcMode", "Landroidx/compose/animation/core/ArcMode;", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;IILandroidx/compose/animation/core/Easing;Landroidx/compose/animation/core/ArcMode;)V", "arcSpline", "Landroidx/compose/animation/core/ArcSpline;", "getDelayMillis", "()I", "getDurationMillis", "lastInitialValue", "Landroidx/compose/animation/core/AnimationVector;", "lastTargetValue", "modes", "", "posArray", "", "slopeArray", "times", "valueVector", "velocityVector", "value", "getValue$annotations", "(Landroidx/compose/animation/core/ArcMode;)V", "getValue", "(Landroidx/compose/animation/core/ArcMode;)I", "findEntryForTimeMillis", "timeMillis", "getEasedTime", "", "getEasedTimeFromIndex", "index", "asFraction", "", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "animation-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,1092:1\n215#2,2:1093\n215#2,2:1095\n70#3:1097\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n*L\n254#1:1093,2\n268#1:1095,2\n501#1:1097\n*E\n"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    @NotNull
    private final Easing defaultEasing;
    @NotNull
    private final ArcMode initialArcMode;
    private int[] modes;
    private float[] times;
    private V valueVector;
    private V velocityVector;
    private V lastInitialValue;
    private V lastTargetValue;
    private float[] posArray;
    private float[] slopeArray;
    private ArcSpline arcSpline;
    public static final int $stable = 8;

    public VectorizedKeyframesSpec(@NotNull IntList timestamps, @NotNull IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes, int durationMillis, int delayMillis, @NotNull Easing defaultEasing, @NotNull ArcMode initialArcMode) {
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
        this.defaultEasing = defaultEasing;
        this.initialArcMode = initialArcMode;
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Easing>> keyframes, int durationMillis, int delayMillis) {
        Map.Entry<Integer, Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<V, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>> entry;
        Map.Entry<Integer, Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<V, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>, Easing>> element$iv;
        VectorizedKeyframesSpec<V> vectorizedKeyframesSpec = this;
        boolean bl = false;
        MutableIntList times = new MutableIntList(keyframes.size() + 2);
        Map<Integer, Pair<Pair<V, Easing>, Easing>> $this$forEach$iv = keyframes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Pair<V, Easing>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl2 = false;
            int t = ((Number)entry.getKey()).intValue();
            times.add(t);
        }
        if (!keyframes.containsKey(0)) {
            times.add(0, 0);
        }
        if (!keyframes.containsKey(durationMillis)) {
            times.add(durationMillis);
        }
        times.sort();
        IntList intList = (IntList)times;
        boolean bl3 = false;
        MutableIntObjectMap timeToInfoMap = new MutableIntObjectMap(0, 1, null);
        $this$forEach$iv = keyframes;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl4 = false;
            int time = ((Number)entry.getKey()).intValue();
            Pair<? extends Pair<? extends V, ? extends Easing>, Easing> valueEasing = entry.getValue();
            timeToInfoMap.set(time, new VectorizedKeyframeSpecElementInfo<AnimationVector>((AnimationVector)valueEasing.getFirst(), (Easing)valueEasing.getSecond(), ArcMode.Companion.ArcLinear.INSTANCE));
        }
        MutableIntObjectMap mutableIntObjectMap = timeToInfoMap;
        vectorizedKeyframesSpec(intList, (IntObjectMap)mutableIntObjectMap, durationMillis, delayMillis, EasingKt.getLinearEasing(), ArcMode.Companion.ArcLinear.INSTANCE);
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map, n, n2);
    }

    private final void init(V initialValue, V targetValue, V initialVelocity) {
        block28: {
            int n;
            Object object;
            block27: {
                boolean requiresArcSpline;
                boolean bl = requiresArcSpline = this.arcSpline != null;
                if (this.valueVector == null) {
                    this.valueVector = AnimationVectorsKt.newInstance(initialValue);
                    this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
                    int n2 = 0;
                    int n3 = this.timestamps.getSize();
                    Object[] objectArray = new float[n3];
                    object = this;
                    while (n2 < n3) {
                        n = n2++;
                        objectArray[n] = (float)this.timestamps.get(n) / (float)1000L;
                    }
                    ((VectorizedKeyframesSpec)object).times = objectArray;
                    n3 = this.timestamps.getSize();
                    objectArray = new int[n3];
                    object = this;
                    for (n2 = 0; n2 < n3; ++n2) {
                        Object mode;
                        n = n2;
                        Object object2 = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(this.timestamps.get(n));
                        if (object2 == null || (object2 = ((VectorizedKeyframeSpecElementInfo)object2).getArcMode()) == null) {
                            object2 = this.initialArcMode;
                        }
                        if (!Intrinsics.areEqual((Object)(mode = object2), (Object)ArcMode.Companion.ArcLinear.INSTANCE)) {
                            requiresArcSpline = true;
                        }
                        objectArray[n] = this.getValue((ArcMode)mode);
                    }
                    ((VectorizedKeyframesSpec)object).modes = (int[])objectArray;
                }
                if (!requiresArcSpline) {
                    return;
                }
                if (this.arcSpline == null) break block27;
                V v = this.lastInitialValue;
                if (v == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastInitialValue");
                    v = null;
                }
                if (!Intrinsics.areEqual(v, initialValue)) break block27;
                V v2 = this.lastTargetValue;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastTargetValue");
                    v2 = null;
                }
                if (Intrinsics.areEqual(v2, targetValue)) break block28;
            }
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue;
            int dimensionCount = ((AnimationVector)initialValue).getSize$animation_core_release() % 2 + ((AnimationVector)initialValue).getSize$animation_core_release();
            this.posArray = new float[dimensionCount];
            this.slopeArray = new float[dimensionCount];
            n = this.timestamps.getSize();
            float[][] fArrayArray = new float[n][];
            for (int i = 0; i < n; ++i) {
                int n4;
                Object v;
                float[] fArray;
                int n5;
                Object object3;
                int n6;
                float[] fArray2;
                int n7;
                int n8 = i;
                int timestamp = this.timestamps.get(n8);
                if (timestamp == 0) {
                    if (!this.keyframes.contains(timestamp)) {
                        n7 = 0;
                        fArray2 = new float[dimensionCount];
                        n6 = n8;
                        object = fArrayArray;
                        while (n7 < dimensionCount) {
                            int n9 = n7++;
                            fArray2[n9] = ((AnimationVector)initialValue).get$animation_core_release(n9);
                        }
                        object3 = object;
                        n5 = n6;
                        fArray = fArray2;
                    } else {
                        n7 = 0;
                        fArray2 = new float[dimensionCount];
                        Object object4 = this.keyframes.get(timestamp);
                        Intrinsics.checkNotNull((Object)object4);
                        v = ((VectorizedKeyframeSpecElementInfo)object4).getVectorValue();
                        object = fArrayArray;
                        while (n7 < dimensionCount) {
                            n4 = n7++;
                            fArray2[n4] = ((AnimationVector)v).get$animation_core_release(n4);
                        }
                        object3 = object;
                        n5 = n6;
                        fArray = fArray2;
                    }
                } else if (timestamp == this.getDurationMillis()) {
                    if (!this.keyframes.contains(timestamp)) {
                        n7 = 0;
                        fArray2 = new float[dimensionCount];
                        object = fArrayArray;
                        while (n7 < dimensionCount) {
                            int n10 = n7++;
                            fArray2[n10] = ((AnimationVector)targetValue).get$animation_core_release(n10);
                        }
                        object3 = object;
                        n5 = n6;
                        fArray = fArray2;
                    } else {
                        n7 = 0;
                        fArray2 = new float[dimensionCount];
                        Object object5 = this.keyframes.get(timestamp);
                        Intrinsics.checkNotNull((Object)object5);
                        v = ((VectorizedKeyframeSpecElementInfo)object5).getVectorValue();
                        object = fArrayArray;
                        while (n7 < dimensionCount) {
                            n4 = n7++;
                            fArray2[n4] = ((AnimationVector)v).get$animation_core_release(n4);
                        }
                        object3 = object;
                        n5 = n6;
                        fArray = fArray2;
                    }
                } else {
                    n7 = 0;
                    fArray2 = new float[dimensionCount];
                    Object object6 = this.keyframes.get(timestamp);
                    Intrinsics.checkNotNull((Object)object6);
                    v = ((VectorizedKeyframeSpecElementInfo)object6).getVectorValue();
                    object = fArrayArray;
                    while (n7 < dimensionCount) {
                        n4 = n7++;
                        fArray2[n4] = ((AnimationVector)v).get$animation_core_release(n4);
                    }
                    object3 = object;
                    n5 = n6;
                    fArray = fArray2;
                }
                object3[n5] = fArray;
            }
            float[][] values = fArrayArray;
            int[] nArray = this.modes;
            if (this.modes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modes");
                nArray = null;
            }
            float[] fArray = this.times;
            if (this.times == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"times");
                fArray = null;
            }
            this.arcSpline = new ArcSpline(nArray, fArray, values);
        }
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        V v2;
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (this.keyframes.contains(clampedPlayTime)) {
            Object object = this.keyframes.get(clampedPlayTime);
            Intrinsics.checkNotNull((Object)object);
            return ((VectorizedKeyframeSpecElementInfo)object).getVectorValue();
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue, initialVelocity);
        if (this.arcSpline != null) {
            float easedTime = this.getEasedTime(clampedPlayTime);
            ArcSpline arcSpline = this.arcSpline;
            if (arcSpline == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arcSpline");
                arcSpline = null;
            }
            float[] fArray = this.posArray;
            if (this.posArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"posArray");
                fArray = null;
            }
            arcSpline.getPos(easedTime, fArray);
            int i = 0;
            float[] fArray2 = this.posArray;
            if (this.posArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"posArray");
                fArray2 = null;
            }
            int n = fArray2.length;
            while (i < n) {
                V v3 = this.valueVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                    v3 = null;
                }
                float[] fArray3 = this.posArray;
                if (this.posArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"posArray");
                    fArray3 = null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, fArray3[i]);
                ++i;
            }
            V v4 = this.valueVector;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v4 = null;
            }
            return v4;
        }
        int index = this.findEntryForTimeMillis(clampedPlayTime);
        float easedTime = this.getEasedTimeFromIndex(index, clampedPlayTime, true);
        int timestampStart = this.timestamps.get(index);
        if (this.keyframes.contains(timestampStart)) {
            Object object = this.keyframes.get(timestampStart);
            Intrinsics.checkNotNull((Object)object);
            v2 = ((VectorizedKeyframeSpecElementInfo)object).getVectorValue();
        } else {
            v2 = initialValue;
        }
        V startValue = v2;
        int timestampEnd = this.timestamps.get(index + 1);
        if (this.keyframes.contains(timestampEnd)) {
            Object object = this.keyframes.get(timestampEnd);
            Intrinsics.checkNotNull((Object)object);
            v = ((VectorizedKeyframeSpecElementInfo)object).getVectorValue();
        } else {
            v = targetValue;
        }
        V endValue = v;
        int i = 0;
        V v5 = this.valueVector;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v5 = null;
        }
        int n = ((AnimationVector)v5).getSize$animation_core_release();
        while (i < n) {
            V v6 = this.valueVector;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                v6 = null;
            }
            ((AnimationVector)v6).set$animation_core_release(i, VectorConvertersKt.lerp(((AnimationVector)startValue).get$animation_core_release(i), ((AnimationVector)endValue).get$animation_core_release(i), easedTime));
            ++i;
        }
        V v7 = this.valueVector;
        if (v7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v7 = null;
        }
        return v7;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue, initialVelocity);
        if (this.arcSpline != null) {
            float easedTime = this.getEasedTime((int)clampedPlayTime);
            ArcSpline arcSpline = this.arcSpline;
            if (arcSpline == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arcSpline");
                arcSpline = null;
            }
            float[] fArray = this.slopeArray;
            if (this.slopeArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slopeArray");
                fArray = null;
            }
            arcSpline.getSlope(easedTime, fArray);
            int i = 0;
            float[] fArray2 = this.slopeArray;
            if (this.slopeArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slopeArray");
                fArray2 = null;
            }
            int n = fArray2.length;
            while (i < n) {
                V v = this.velocityVector;
                if (v == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                    v = null;
                }
                float[] fArray3 = this.slopeArray;
                if (this.slopeArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"slopeArray");
                    fArray3 = null;
                }
                ((AnimationVector)v).set$animation_core_release(i, fArray3[i]);
                ++i;
            }
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v = null;
            }
            return v;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue, initialVelocity);
        int n = ((AnimationVector)startNum).getSize$animation_core_release();
        for (int i = 0; i < n; ++i) {
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                v = null;
            }
            ((AnimationVector)v).set$animation_core_release(i, (((AnimationVector)startNum).get$animation_core_release(i) - ((AnimationVector)endNum).get$animation_core_release(i)) * 1000.0f);
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        return v;
    }

    private final float getEasedTime(int timeMillis) {
        int index = this.findEntryForTimeMillis(timeMillis);
        return this.getEasedTimeFromIndex(index, timeMillis, false);
    }

    private final float getEasedTimeFromIndex(int index, int timeMillis, boolean asFraction) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index);
        int timeMax = this.timestamps.get(index + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        Object object = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timeMin);
        if (object == null || (object = ((VectorizedKeyframeSpecElementInfo)object).getEasing()) == null) {
            object = this.defaultEasing;
        }
        Object easing = object;
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        if (asFraction) {
            return easedFraction;
        }
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index = IntListExtensionKt.binarySearch$default(this.timestamps, timeMillis, 0, 0, 6, null);
        return index < -1 ? -(index + 2) : index;
    }

    private final int getValue(ArcMode $this$value) {
        ArcMode arcMode = $this$value;
        return Intrinsics.areEqual((Object)arcMode, (Object)ArcMode.Companion.ArcAbove.INSTANCE) ? 5 : (Intrinsics.areEqual((Object)arcMode, (Object)ArcMode.Companion.ArcBelow.INSTANCE) ? 4 : (Intrinsics.areEqual((Object)arcMode, (Object)ArcMode.Companion.ArcLinear.INSTANCE) ? 0 : 0));
    }

    private static /* synthetic */ void getValue$annotations(ArcMode arcMode) {
    }
}

