/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core.lint;

import androidx.compose.animation.core.lint.ArcAnimationSpecTypeDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/animation/core/lint/ArcAnimationSpecTypeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "animation-core-lint"})
public final class ArcAnimationSpecTypeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ArcAnimationSpecTypeIssue = Issue.Companion.create("ArcAnimationSpecTypeIssue", "ArcAnimationSpec is designed for 2D values. Particularly, for positional values such as Offset.", "ArcAnimationSpec is designed for 2D values. Particularly, for positional values such as Offset.\nTrying to use it for values of different dimensions (Float, Size, Color, etc.) will result in unpredictable animation behavior.", Category.CORRECTNESS, 5, Severity.INFORMATIONAL, new Implementation(ArcAnimationSpecTypeDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UReferenceExpression uReferenceExpression = node.getClassReference();
                if (Intrinsics.areEqual((Object)(uReferenceExpression != null ? uReferenceExpression.getResolvedName() : null), (Object)"ArcAnimationSpec")) {
                    this.detectTypeParameterInArcAnimation(node);
                }
            }

            private final void detectTypeParameterInArcAnimation(UCallExpression node) {
                String fqClassName;
                PsiType psiType = (PsiType)CollectionsKt.firstOrNull((List)node.getTypeArguments());
                if (psiType == null) {
                    return;
                }
                PsiType typeArg = psiType;
                String string = typeArg.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeArg.canonicalText");
                String qualifiedTypeName = string;
                if (ArcAnimationSpecTypeDetectorKt.access$getPreferredArcAnimationTypes().contains(qualifiedTypeName)) {
                    return;
                }
                UReferenceExpression uReferenceExpression = node.getClassReference();
                UDeclaration uDeclaration = uReferenceExpression != null ? UastLintUtils.Companion.tryResolveUDeclaration((UElement)uReferenceExpression) : null;
                UClass uClass = uDeclaration instanceof UClass ? (UClass)uDeclaration : null;
                String string2 = fqClassName = uClass != null ? uClass.getQualifiedName() : null;
                if (!Intrinsics.areEqual((Object)fqClassName, (Object)"androidx.compose.animation.core.ArcAnimationSpec")) {
                    return;
                }
                JavaContext.report$default((JavaContext)this.$context, (Issue)ArcAnimationSpecTypeDetector.Companion.getArcAnimationSpecTypeIssue(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Arc animation is intended for 2D values such as Offset, IntOffset or DpOffset.\nOtherwise, the animation might not be what you expect.", null, (int)16, null);
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/core/lint/ArcAnimationSpecTypeDetector$Companion;", "", "()V", "ArcAnimationSpecTypeIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getArcAnimationSpecTypeIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "animation-core-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getArcAnimationSpecTypeIssue() {
            return ArcAnimationSpecTypeIssue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

