/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.BezierKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/CubicBezierEasing;", "Landroidx/compose/animation/core/Easing;", "a", "", "b", "c", "d", "(FFFF)V", "max", "min", "equals", "", "other", "", "hashCode", "", "throwNoSolution", "", "fraction", "toString", "", "transform", "animation-core_release"})
@Immutable
@SourceDebugExtension(value={"SMAP\nEasing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n+ 2 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n+ 5 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,172:1\n33#2,7:173\n48#3:180\n54#3:182\n22#4:181\n22#4:183\n71#5,16:184\n*S KotlinDebug\n*F\n+ 1 Easing.kt\nandroidx/compose/animation/core/CubicBezierEasing\n*L\n115#1:173,7\n120#1:180\n121#1:182\n120#1:181\n121#1:183\n149#1:184,16\n*E\n"})
public final class CubicBezierEasing
implements Easing {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float min;
    private final float max;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public CubicBezierEasing(float a, float b, float c, float d) {
        void value$iv;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        boolean bl = !Float.isNaN(this.a) && !Float.isNaN(this.b) && !Float.isNaN(this.c) && !Float.isNaN(this.d);
        boolean $i$f$requirePrecondition = false;
        if (value$iv == false) {
            boolean bl2 = false;
            PreconditionsKt.throwIllegalArgumentException("Parameters to CubicBezierEasing cannot be NaN. Actual parameters are: " + this.a + ", " + this.b + ", " + this.c + ", " + this.d + '.');
        }
        float[] roots = new float[5];
        long extrema = BezierKt.computeCubicVerticalBounds((float)0.0f, (float)this.b, (float)this.d, (float)1.0f, (float[])roots, (int)0);
        boolean bl3 = false;
        int bits$iv$iv = (int)(extrema >> 32);
        boolean $i$f$floatFromBits = false;
        this.min = Float.intBitsToFloat(bits$iv$iv);
        boolean bl4 = false;
        bits$iv$iv = (int)(extrema & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        this.max = Float.intBitsToFloat(bits$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float transform(float fraction) {
        float f;
        if (fraction > 0.0f && fraction < 1.0f) {
            void $this$fastCoerceAtMost$iv$iv;
            void minimumValue$iv;
            void $this$fastCoerceIn$iv;
            float t = BezierKt.findFirstCubicRoot((float)(0.0f - fraction), (float)(this.a - fraction), (float)(this.c - fraction), (float)(1.0f - fraction));
            if (Float.isNaN(t)) {
                this.throwNoSolution(fraction);
            }
            float f2 = BezierKt.evaluateCubic((float)this.b, (float)this.d, (float)t);
            float f3 = this.min;
            float maximumValue$iv = this.max;
            boolean $i$f$fastCoerceIn = false;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            f = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        } else {
            f = fraction;
        }
        return f;
    }

    private final void throwNoSolution(float fraction) {
        throw new IllegalArgumentException("The cubic curve with parameters (" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ") has no solution at " + fraction);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CubicBezierEasing && this.a == ((CubicBezierEasing)other).a && this.b == ((CubicBezierEasing)other).b && this.c == ((CubicBezierEasing)other).c && this.d == ((CubicBezierEasing)other).d;
    }

    public int hashCode() {
        return ((Float.hashCode(this.a) * 31 + Float.hashCode(this.b)) * 31 + Float.hashCode(this.c)) * 31 + Float.hashCode(this.d);
    }

    @NotNull
    public String toString() {
        return "CubicBezierEasing(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ')';
    }
}

