/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ComplexDouble;
import androidx.compose.animation.core.ComplexDoubleKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b\u001a(\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a8\u0010\u0011\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a0\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a(\u0010\u0015\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a9\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019H\u0082\b\u001a\r\u0010\u001b\u001a\u00020\u001c*\u00020\u0003H\u0082\b\u00a8\u0006\u001d"}, d2={"estimateAnimationDurationMillis", "", "stiffness", "", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "springConstant", "dampingCoefficient", "mass", "", "estimateCriticallyDamped", "firstRoot", "Landroidx/compose/animation/core/ComplexDouble;", "p0", "v0", "estimateDurationInternal", "secondRoot", "initialPosition", "estimateOverDamped", "estimateUnderDamped", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "isNotFinite", "", "animation-core"})
@SourceDebugExtension(value={"SMAP\nSpringEstimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n+ 2 ComplexDouble.kt\nandroidx/compose/animation/core/ComplexDoubleKt\n+ 3 ComplexDouble.kt\nandroidx/compose/animation/core/ComplexDouble\n*L\n1#1,329:1\n328#1:362\n328#1:363\n324#1:364\n328#1:365\n328#1:366\n324#1:367\n103#2:330\n107#2:336\n103#2:340\n103#2:346\n107#2:352\n103#2:356\n35#3,2:331\n54#3,3:333\n66#3,3:337\n35#3,2:341\n54#3,3:343\n35#3,2:347\n54#3,3:349\n66#3,3:353\n35#3,2:357\n54#3,3:359\n*S KotlinDebug\n*F\n+ 1 SpringEstimation.kt\nandroidx/compose/animation/core/SpringEstimationKt\n*L\n149#1:362\n150#1:363\n188#1:364\n221#1:365\n222#1:366\n266#1:367\n59#1:330\n60#1:336\n60#1:340\n90#1:346\n91#1:352\n91#1:356\n59#1:331,2\n59#1:333,3\n60#1:337,3\n60#1:341,2\n60#1:343,3\n90#1:347,2\n90#1:349,3\n91#1:353,3\n91#1:357,2\n91#1:359,3\n*E\n"})
public final class SpringEstimationKt {
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        return SpringEstimationKt.estimateAnimationDurationMillis((double)stiffness, (double)dampingRatio, (double)initialVelocity, (double)initialDisplacement, (double)delta);
    }

    /*
     * WARNING - void declaration
     */
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        void this_$iv;
        void $this$plus$iv$iv;
        void other$iv$iv;
        void $this$minus$iv;
        void this_$iv2;
        void $this$plus$iv22;
        double dampingCoefficient = 2.0 * dampingRatio * Math.sqrt(stiffness);
        double partialRoot = dampingCoefficient * dampingCoefficient - 4.0 * stiffness;
        double d = -dampingCoefficient;
        ComplexDouble other$iv = ComplexDoubleKt.complexSqrt(partialRoot);
        boolean $i$f$plus = false;
        ComplexDouble this_$iv$iv = other$iv;
        boolean $i$f$plus22 = false;
        ComplexDouble.access$set_real$p(this_$iv$iv, ComplexDouble.access$get_real$p(this_$iv$iv) + $this$plus$iv22);
        ComplexDouble $this$plus$iv22 = this_$iv$iv;
        double other$iv2 = 0.5;
        boolean $i$f$times = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv2, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv2) * other$iv2);
        ComplexDouble.access$set_imaginary$p((ComplexDouble)this_$iv2, ComplexDouble.access$get_imaginary$p((ComplexDouble)this_$iv2) * other$iv2);
        void firstRoot = this_$iv2;
        other$iv2 = -dampingCoefficient;
        ComplexDouble other$iv3 = ComplexDoubleKt.complexSqrt(partialRoot);
        boolean $i$f$minus = false;
        void $i$f$plus22 = $this$minus$iv;
        ComplexDouble this_$iv$iv2 = other$iv3;
        boolean $i$f$unaryMinus = false;
        ComplexDouble.access$set_real$p(this_$iv$iv2, ComplexDouble.access$get_real$p(this_$iv$iv2) * (double)-1);
        ComplexDouble.access$set_imaginary$p(this_$iv$iv2, ComplexDouble.access$get_imaginary$p(this_$iv$iv2) * (double)-1);
        boolean $i$f$plus3 = false;
        void this_$iv$iv$iv = other$iv$iv;
        boolean $i$f$plus4 = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv$iv$iv, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv$iv$iv) + $this$plus$iv$iv);
        $this$minus$iv = this_$iv$iv$iv;
        double other$iv22 = 0.5;
        boolean $i$f$times2 = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv) * other$iv22);
        ComplexDouble.access$set_imaginary$p((ComplexDouble)this_$iv, ComplexDouble.access$get_imaginary$p((ComplexDouble)this_$iv) * other$iv22);
        void secondRoot = this_$iv;
        return SpringEstimationKt.estimateDurationInternal((ComplexDouble)firstRoot, (ComplexDouble)secondRoot, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    /*
     * WARNING - void declaration
     */
    public static final long estimateAnimationDurationMillis(double springConstant, double dampingCoefficient, double mass, double initialVelocity, double initialDisplacement, double delta) {
        void this_$iv;
        void $this$plus$iv$iv;
        void other$iv$iv;
        void $this$minus$iv;
        void this_$iv2;
        void $this$plus$iv22;
        double criticalDamping = 2.0 * Math.sqrt(springConstant * mass);
        double dampingRatio = dampingCoefficient / criticalDamping;
        double partialRoot = dampingCoefficient * dampingCoefficient - 4.0 * mass * springConstant;
        double divisor = 1.0 / (2.0 * mass);
        double d = -dampingCoefficient;
        ComplexDouble other$iv = ComplexDoubleKt.complexSqrt(partialRoot);
        boolean $i$f$plus = false;
        ComplexDouble this_$iv$iv = other$iv;
        boolean $i$f$plus22 = false;
        ComplexDouble.access$set_real$p(this_$iv$iv, ComplexDouble.access$get_real$p(this_$iv$iv) + $this$plus$iv22);
        ComplexDouble $this$plus$iv22 = this_$iv$iv;
        boolean $i$f$times22 = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv2, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv2) * divisor);
        ComplexDouble.access$set_imaginary$p((ComplexDouble)this_$iv2, ComplexDouble.access$get_imaginary$p((ComplexDouble)this_$iv2) * divisor);
        void firstRoot = this_$iv2;
        double $i$f$times22 = -dampingCoefficient;
        ComplexDouble other$iv2 = ComplexDoubleKt.complexSqrt(partialRoot);
        boolean $i$f$minus = false;
        void $i$f$plus22 = $this$minus$iv;
        ComplexDouble this_$iv$iv2 = other$iv2;
        boolean $i$f$unaryMinus = false;
        ComplexDouble.access$set_real$p(this_$iv$iv2, ComplexDouble.access$get_real$p(this_$iv$iv2) * (double)-1);
        ComplexDouble.access$set_imaginary$p(this_$iv$iv2, ComplexDouble.access$get_imaginary$p(this_$iv$iv2) * (double)-1);
        boolean $i$f$plus3 = false;
        void this_$iv$iv$iv = other$iv$iv;
        boolean $i$f$plus4 = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv$iv$iv, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv$iv$iv) + $this$plus$iv$iv);
        $this$minus$iv = this_$iv$iv$iv;
        boolean $i$f$times = false;
        ComplexDouble.access$set_real$p((ComplexDouble)this_$iv, ComplexDouble.access$get_real$p((ComplexDouble)this_$iv) * divisor);
        ComplexDouble.access$set_imaginary$p((ComplexDouble)this_$iv, ComplexDouble.access$get_imaginary$p((ComplexDouble)this_$iv) * divisor);
        void secondRoot = this_$iv;
        return SpringEstimationKt.estimateDurationInternal((ComplexDouble)firstRoot, (ComplexDouble)secondRoot, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    private static final double estimateUnderDamped(ComplexDouble firstRoot, double p0, double v0, double delta) {
        double r = firstRoot.getReal();
        double c1 = p0;
        double c2 = (v0 - r * c1) / firstRoot.getImaginary();
        double c = Math.sqrt(c1 * c1 + c2 * c2);
        return Math.log(delta / c) / r;
    }

    private static final double estimateCriticallyDamped(ComplexDouble firstRoot, double p0, double v0, double delta) {
        double d;
        double d2;
        double guess;
        double r = firstRoot.getReal();
        double c1 = p0;
        double c2 = v0 - r * c1;
        double t1 = Math.log(Math.abs(delta / c1)) / r;
        boolean bl = false;
        double t = guess = Math.log(Math.abs(delta / c2));
        for (int i = 0; i < 6; ++i) {
            t = guess - Math.log(Math.abs(t / r));
        }
        double t2 = t / r;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double d3 = $this$isNotFinite$iv;
        boolean bl2 = !(!Double.isInfinite(d3) && !Double.isNaN(d3));
        if (bl2) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            d3 = $this$isNotFinite$iv;
            d2 = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        double xInflection = c1 * Math.exp(r * tInflection) + c2 * tInflection * Math.exp(r * tInflection);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -xInflection < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t3;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d4 = tCurr;
            double d5 = tCurr;
            boolean bl3 = false;
            double d6 = (c1 + c2 * t3) * Math.exp(r * t3) + signedDelta;
            t3 = tCurr;
            boolean bl4 = false;
            double d7 = (c2 * (r * t3 + 1.0) + c1 * r) * Math.exp(r * t3);
            tCurr = d5 - d6 / d7;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final double estimateOverDamped(ComplexDouble firstRoot, ComplexDouble secondRoot, double p0, double v0, double delta) {
        double signedDelta;
        double d;
        double d2;
        double r1 = firstRoot.getReal();
        double r2 = secondRoot.getReal();
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double t1 = Math.log(Math.abs(delta / c1)) / r1;
        double t2 = Math.log(Math.abs(delta / c2)) / r2;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double d3 = $this$isNotFinite$iv;
        boolean bl = !(!Double.isInfinite(d3) && !Double.isNaN(d3));
        if (bl) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            d3 = $this$isNotFinite$iv;
            d2 = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = Math.log(c1 * r1 / (-c2 * r2)) / (r2 - r1);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection(c1, r1, tInflection, c2, r2) < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
            d = signedDelta = delta;
        }
        if (Math.abs(c1 * r1 * Math.exp(r1 * tCurr) + c2 * r2 * Math.exp(r2 * tCurr)) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = Double.MAX_VALUE;
        for (int iterations = 0; tDelta > 0.001 && iterations < 100; ++iterations) {
            double t;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            double d4 = tCurr;
            double d5 = tCurr;
            boolean bl2 = false;
            double d6 = c1 * Math.exp(r1 * t) + c2 * Math.exp(r2 * t) + signedDelta;
            t = tCurr;
            boolean bl3 = false;
            double d7 = c1 * r1 * Math.exp(r1 * t) + c2 * r2 * Math.exp(r2 * t);
            tCurr = d5 - d6 / d7;
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(ComplexDouble firstRoot, ComplexDouble secondRoot, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(firstRoot, secondRoot, p0, v0, delta) : (dampingRatio < 1.0 ? SpringEstimationKt.estimateUnderDamped(firstRoot, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(firstRoot, p0, v0, delta))) * 1000.0);
    }

    private static final double iterateNewtonsMethod(double x, Function1<? super Double, Double> fn, Function1<? super Double, Double> fnPrime) {
        boolean $i$f$iterateNewtonsMethod = false;
        return x - ((Number)fn.invoke((Object)x)).doubleValue() / ((Number)fnPrime.invoke((Object)x)).doubleValue();
    }

    private static final boolean isNotFinite(double $this$isNotFinite) {
        boolean $i$f$isNotFinite = false;
        double d = $this$isNotFinite;
        return !(!Double.isInfinite(d) && !Double.isNaN(d));
    }

    private static final double estimateOverDamped$xInflection(double c1, double r1, double tInflection, double c2, double r2) {
        return c1 * Math.exp(r1 * tInflection) + c2 * Math.exp(r2 * tInflection);
    }
}

