/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ExperimentalAnimationSpecApi;
import androidx.compose.animation.core.MonoSpline;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0015\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006!"}, d2={"Landroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "timestamps", "Landroidx/collection/IntList;", "keyframes", "Landroidx/collection/IntObjectMap;", "durationMillis", "", "delayMillis", "(Landroidx/collection/IntList;Landroidx/collection/IntObjectMap;II)V", "getDelayMillis", "()I", "getDurationMillis", "lastInitialValue", "Landroidx/compose/animation/core/AnimationVector;", "lastTargetValue", "monoSpline", "Landroidx/compose/animation/core/MonoSpline;", "valueVector", "velocityVector", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)V", "animation-core"})
@ExperimentalAnimationSpecApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVectorizedMonoSplineKeyframesSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n+ 2 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,127:1\n266#2,6:128\n*S KotlinDebug\n*F\n+ 1 VectorizedMonoSplineKeyframesSpec.kt\nandroidx/compose/animation/core/VectorizedMonoSplineKeyframesSpec\n*L\n68#1:128,6\n*E\n"})
public final class VectorizedMonoSplineKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<V> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private V valueVector;
    private V velocityVector;
    private V lastInitialValue;
    private V lastTargetValue;
    private MonoSpline monoSpline;
    public static final int $stable = 8;

    public VectorizedMonoSplineKeyframesSpec(@NotNull IntList timestamps, @NotNull IntObjectMap<V> keyframes, int durationMillis, int delayMillis) {
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ VectorizedMonoSplineKeyframesSpec(IntList intList, IntObjectMap intObjectMap, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(intList, intObjectMap, n, n2);
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    /*
     * WARNING - void declaration
     */
    private final void init(V initialValue, V targetValue, V initialVelocity) {
        block11: {
            block10: {
                if (this.valueVector == null) {
                    this.valueVector = AnimationVectorsKt.newInstance(initialValue);
                    this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
                }
                if (this.monoSpline == null) break block10;
                V v = this.lastInitialValue;
                if (v == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastInitialValue");
                    v = null;
                }
                if (!Intrinsics.areEqual(v, initialValue)) break block10;
                V v2 = this.lastTargetValue;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastTargetValue");
                    v2 = null;
                }
                if (Intrinsics.areEqual(v2, targetValue)) break block11;
            }
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue;
            int arraySize = this.keyframes.getSize() + 2;
            float[] times = new float[arraySize];
            ArrayList<float[]> arrayList = new ArrayList<float[]>(arraySize);
            int n = 0;
            while (n < arraySize) {
                int n2;
                int n3 = n2 = n++;
                ArrayList<float[]> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(new float[((AnimationVector)initialValue).getSize$animation_core()]);
            }
            List values = arrayList;
            times[0] = 0.0f;
            times[arraySize - 1] = (float)this.getDurationMillis() / (float)1000L;
            float[] vectorStart = (float[])values.get(0);
            float[] vectorEnd = (float[])values.get(arraySize - 1);
            int it = ((AnimationVector)initialValue).getSize$animation_core();
            for (int i = 0; i < it; ++i) {
                vectorStart[i] = ((AnimationVector)initialValue).get$animation_core(i);
                vectorEnd[i] = ((AnimationVector)targetValue).get$animation_core(i);
            }
            IntList this_$iv = this.timestamps;
            boolean $i$f$forEachIndexed = false;
            int[] content$iv = this_$iv.content;
            int n4 = this_$iv._size;
            for (int i$iv = 0; i$iv < n4; ++i$iv) {
                void frameMillis;
                int n5 = content$iv[i$iv];
                int index = i$iv;
                boolean bl = false;
                Object object = this.keyframes.get((int)frameMillis);
                Intrinsics.checkNotNull((Object)object);
                AnimationVector valueVector = (AnimationVector)object;
                times[index + 1] = (float)frameMillis / (float)1000L;
                float[] vector = (float[])values.get(index + 1);
                int n6 = vector.length;
                for (int i = 0; i < n6; ++i) {
                    vector[i] = valueVector.get$animation_core(i);
                }
            }
            this.monoSpline = new MonoSpline(times, values);
        }
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            Object object = this.keyframes.get(clampedPlayTime);
            Intrinsics.checkNotNull((Object)object);
            return (V)((AnimationVector)object);
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue, initialVelocity);
        MonoSpline monoSpline = this.monoSpline;
        if (monoSpline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monoSpline");
            monoSpline = null;
        }
        float f = (float)clampedPlayTime / (float)1000L;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v = null;
        }
        monoSpline.getPos(f, (AnimationVector)v);
        V v2 = this.valueVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            v2 = null;
        }
        return v2;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue, initialVelocity);
        MonoSpline monoSpline = this.monoSpline;
        if (monoSpline == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monoSpline");
            monoSpline = null;
        }
        float f = (float)clampedPlayTime / (float)1000L;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v = null;
        }
        monoSpline.getSlope(f, (AnimationVector)v);
        V v2 = this.velocityVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            v2 = null;
        }
        return v2;
    }
}

