/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0016\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/animation/CubicBezierEasing;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "a", "b", "c", "d", "(FFFF)V", "evaluateCubic", "m", "invoke", "(F)Ljava/lang/Float;", "animation-core_release"})
public final class CubicBezierEasing
implements Function1<Float, Float> {
    private final float a;
    private final float b;
    private final float c;
    private final float d;

    private final float evaluateCubic(float a, float b, float m) {
        return (float)3 * a * (1.0f - m) * (1.0f - m) * m + (float)3 * b * (1.0f - m) * m * m + m * m * m;
    }

    @NotNull
    public Float invoke(float fraction) {
        if (fraction > 0.0f && fraction < 1.0f) {
            float start = 0.0f;
            float end = 1.0f;
            while (true) {
                float midpoint = (start + end) / (float)2;
                float estimate = this.evaluateCubic(this.a, this.c, midpoint);
                float f = fraction - estimate;
                boolean bl = false;
                if (Math.abs(f) < 0.001f) {
                    return Float.valueOf(this.evaluateCubic(this.b, this.d, midpoint));
                }
                if (estimate < fraction) {
                    start = midpoint;
                    continue;
                }
                end = midpoint;
            }
        }
        return Float.valueOf(fraction);
    }

    public CubicBezierEasing(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }
}

