/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationVector;
import androidx.animation.FloatAnimationSpec;
import androidx.animation.Motion;
import androidx.animation.SpringEstimationKt;
import androidx.animation.SpringSimulation;
import androidx.animation.TwoWayConverter;
import androidx.animation.VectorizedFloatAnimationSpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/animation/FloatSpringSpec;", "Landroidx/animation/FloatAnimationSpec;", "dampingRatio", "", "stiffness", "visibilityThreshold", "(FFF)V", "getDampingRatio", "()F", "spring", "Landroidx/animation/SpringSimulation;", "getStiffness", "getDurationMillis", "", "start", "end", "startVelocity", "getEndVelocity", "getValue", "playTime", "getVelocity", "animation-core_release"})
public final class FloatSpringSpec
implements FloatAnimationSpec {
    private final SpringSimulation spring;
    private final float dampingRatio;
    private final float stiffness;
    private final float visibilityThreshold;

    @Override
    public float getValue(long playTime, float start, float end, float startVelocity) {
        this.spring.setFinalPosition(end);
        float value = Motion.getValue-impl(this.spring.updateValues-i9NqlhI$animation_core_release(start, startVelocity, playTime));
        return value;
    }

    @Override
    public float getVelocity(long playTime, float start, float end, float startVelocity) {
        this.spring.setFinalPosition(end);
        float velocity = Motion.getVelocity-impl(this.spring.updateValues-i9NqlhI$animation_core_release(start, startVelocity, playTime));
        return velocity;
    }

    @Override
    public float getEndVelocity(float start, float end, float startVelocity) {
        return 0.0f;
    }

    @Override
    public long getDurationMillis(float start, float end, float startVelocity) {
        float f = 1.0f;
        float f2 = startVelocity / this.visibilityThreshold;
        float f3 = (start - end) / this.visibilityThreshold;
        return SpringEstimationKt.estimateAnimationDurationMillis(this.spring.getStiffness(), this.spring.getDampingRatio(), f2, f3, f);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final float getStiffness() {
        return this.stiffness;
    }

    /*
     * WARNING - void declaration
     */
    public FloatSpringSpec(float dampingRatio, float stiffness, float visibilityThreshold) {
        void it;
        this.dampingRatio = dampingRatio;
        this.stiffness = stiffness;
        this.visibilityThreshold = visibilityThreshold;
        SpringSimulation springSimulation = new SpringSimulation(1.0f);
        boolean bl = false;
        boolean bl2 = false;
        SpringSimulation springSimulation2 = springSimulation;
        FloatSpringSpec floatSpringSpec = this;
        boolean bl3 = false;
        it.setDampingRatio(this.dampingRatio);
        it.setStiffness(this.stiffness);
        Unit unit = Unit.INSTANCE;
        floatSpringSpec.spring = springSimulation;
    }

    public /* synthetic */ FloatSpringSpec(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1500.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.01f;
        }
        this(f, f2, f3);
    }

    public FloatSpringSpec() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedFloatAnimationSpec<V> vectorize(@NotNull TwoWayConverter<Float, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return FloatAnimationSpec.DefaultImpls.vectorize(this, converter);
    }
}

