/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationVector;
import androidx.animation.DurationBasedAnimationSpec;
import androidx.animation.EasingKt;
import androidx.animation.TwoWayConverter;
import androidx.animation.VectorizedKeyframesSpec;
import androidx.annotation.IntRange;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u000e\u000fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0001\u0010\n*\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\n0\rH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Landroidx/animation/KeyframesSpec;", "T", "Landroidx/animation/DurationBasedAnimationSpec;", "config", "Landroidx/animation/KeyframesSpec$KeyframesSpecConfig;", "(Landroidx/animation/KeyframesSpec$KeyframesSpecConfig;)V", "getConfig", "()Landroidx/animation/KeyframesSpec$KeyframesSpecConfig;", "vectorize", "Landroidx/animation/VectorizedKeyframesSpec;", "V", "Landroidx/animation/AnimationVector;", "converter", "Landroidx/animation/TwoWayConverter;", "KeyframeEntity", "KeyframesSpecConfig", "animation-core_release"})
public final class KeyframesSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final KeyframesSpecConfig<T> config;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedKeyframesSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Map<Integer, KeyframeEntity<T>> $this$mapValues$iv = this.config.getKeyframes$animation_core_release();
        boolean $i$f$mapValues = false;
        Map<Integer, KeyframeEntity<T>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map3;
            boolean bl2 = false;
            Pair<V, Function1<Float, Float>> pair = ((KeyframeEntity)it.getValue()).toPair$animation_core_release(converter.getConvertToVector());
            map.put(k2, pair);
        }
        map = destination$iv$iv;
        int n = this.config.getDelayMillis();
        int n2 = this.config.getDurationMillis();
        Map map4 = map;
        return new VectorizedKeyframesSpec(map4, n2, n);
    }

    @NotNull
    public final KeyframesSpecConfig<T> getConfig() {
        return this.config;
    }

    public KeyframesSpec(@NotNull KeyframesSpecConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u000f*\u00028\u00012\b\b\u0001\u0010\u0013\u001a\u00020\u0005H\u0086\u0004\u00a2\u0006\u0002\u0010\u0014J:\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00028\u00010\u000f2%\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001dH\u0086\u0004R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Landroidx/animation/KeyframesSpec$KeyframesSpecConfig;", "T", "", "()V", "delayMillis", "", "getDelayMillis", "()I", "setDelayMillis", "(I)V", "durationMillis", "getDurationMillis", "setDurationMillis", "keyframes", "", "Landroidx/animation/KeyframesSpec$KeyframeEntity;", "getKeyframes$animation_core_release", "()Ljava/util/Map;", "at", "timeStamp", "(Ljava/lang/Object;I)Landroidx/animation/KeyframesSpec$KeyframeEntity;", "with", "", "easing", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "animation-core_release"})
    public static final class KeyframesSpecConfig<T> {
        @IntRange(from=0L)
        private int durationMillis = 300;
        @IntRange(from=0L)
        private int delayMillis;
        @NotNull
        private final Map<Integer, KeyframeEntity<T>> keyframes;

        public final int getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(int n) {
            this.durationMillis = n;
        }

        public final int getDelayMillis() {
            return this.delayMillis;
        }

        public final void setDelayMillis(int n) {
            this.delayMillis = n;
        }

        @NotNull
        public final Map<Integer, KeyframeEntity<T>> getKeyframes$animation_core_release() {
            return this.keyframes;
        }

        @NotNull
        public final KeyframeEntity<T> at(T $this$at, @IntRange(from=0L) int timeStamp) {
            KeyframeEntity keyframeEntity = new KeyframeEntity($this$at, null, 2, null);
            boolean bl = false;
            boolean bl2 = false;
            KeyframeEntity it = keyframeEntity;
            boolean bl3 = false;
            this.keyframes.put(timeStamp, it);
            return keyframeEntity;
        }

        public final void with(@NotNull KeyframeEntity<T> $this$with, @NotNull Function1<? super Float, Float> easing) {
            Intrinsics.checkNotNullParameter($this$with, (String)"$this$with");
            Intrinsics.checkNotNullParameter(easing, (String)"easing");
            $this$with.setEasing$animation_core_release(easing);
        }

        public KeyframesSpecConfig() {
            boolean bl = false;
            this.keyframes = new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B8\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012'\b\u0002\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJV\u0010\u0013\u001a-\u0012\u0004\u0012\u0002H\u0015\u0012#\u0012!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\n0\u0014\"\b\b\u0002\u0010\u0015*\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00150\u0005H\u0000\u00a2\u0006\u0002\b\u0018R9\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\u00028\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Landroidx/animation/KeyframesSpec$KeyframeEntity;", "T", "", "value", "easing", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "getEasing$animation_core_release", "()Lkotlin/jvm/functions/Function1;", "setEasing$animation_core_release", "(Lkotlin/jvm/functions/Function1;)V", "getValue$animation_core_release", "()Ljava/lang/Object;", "Ljava/lang/Object;", "toPair", "Lkotlin/Pair;", "V", "Landroidx/animation/AnimationVector;", "convertToVector", "toPair$animation_core_release", "animation-core_release"})
    public static final class KeyframeEntity<T> {
        private final T value;
        @NotNull
        private Function1<? super Float, Float> easing;

        @NotNull
        public final <V extends AnimationVector> Pair<V, Function1<Float, Float>> toPair$animation_core_release(@NotNull Function1<? super T, ? extends V> convertToVector) {
            Intrinsics.checkNotNullParameter(convertToVector, (String)"convertToVector");
            return TuplesKt.to((Object)convertToVector.invoke(this.value), this.easing);
        }

        public final T getValue$animation_core_release() {
            return this.value;
        }

        @NotNull
        public final Function1<Float, Float> getEasing$animation_core_release() {
            return this.easing;
        }

        public final void setEasing$animation_core_release(@NotNull Function1<? super Float, Float> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.easing = function1;
        }

        public KeyframeEntity(T value, @NotNull Function1<? super Float, Float> easing) {
            Intrinsics.checkNotNullParameter(easing, (String)"easing");
            this.value = value;
            this.easing = easing;
        }

        public /* synthetic */ KeyframeEntity(Object object, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function1 = EasingKt.getLinearEasing();
            }
            this(object, function1);
        }
    }
}

