/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationSpec;
import androidx.animation.AnimationVector;
import androidx.animation.DurationBasedAnimationSpec;
import androidx.animation.RepeatMode;
import androidx.animation.TwoWayConverter;
import androidx.animation.VectorizedAnimationSpec;
import androidx.animation.VectorizedRepeatableSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0001\u0010\u0012*\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Landroidx/animation/RepeatableSpec;", "T", "Landroidx/animation/AnimationSpec;", "iterations", "", "animation", "Landroidx/animation/DurationBasedAnimationSpec;", "repeatMode", "Landroidx/animation/RepeatMode;", "(ILandroidx/animation/DurationBasedAnimationSpec;Landroidx/animation/RepeatMode;)V", "getAnimation", "()Landroidx/animation/DurationBasedAnimationSpec;", "getIterations", "()I", "getRepeatMode", "()Landroidx/animation/RepeatMode;", "vectorize", "Landroidx/animation/VectorizedAnimationSpec;", "V", "Landroidx/animation/AnimationVector;", "converter", "Landroidx/animation/TwoWayConverter;", "animation-core_release"})
public final class RepeatableSpec<T>
implements AnimationSpec<T> {
    private final int iterations;
    @NotNull
    private final DurationBasedAnimationSpec<T> animation;
    @NotNull
    private final RepeatMode repeatMode;

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new VectorizedRepeatableSpec<V>(this.iterations, this.animation.vectorize(converter), this.repeatMode);
    }

    public final int getIterations() {
        return this.iterations;
    }

    @NotNull
    public final DurationBasedAnimationSpec<T> getAnimation() {
        return this.animation;
    }

    @NotNull
    public final RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    public RepeatableSpec(int iterations, @NotNull DurationBasedAnimationSpec<T> animation, @NotNull RepeatMode repeatMode) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.iterations = iterations;
        this.animation = animation;
        this.repeatMode = repeatMode;
    }

    public /* synthetic */ RepeatableSpec(int n, DurationBasedAnimationSpec durationBasedAnimationSpec, RepeatMode repeatMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            repeatMode = RepeatMode.Restart;
        }
        this(n, durationBasedAnimationSpec, repeatMode);
    }
}

