/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.InternalAnimationApi;
import androidx.animation.PropKey;
import androidx.animation.SeekableAnimation;
import androidx.animation.StateImpl;
import androidx.animation.TransitionAnimationKt;
import androidx.animation.TransitionDefinition;
import androidx.animation.TransitionSpec;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@InternalAnimationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011R2\u0010\b\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001b"}, d2={"Landroidx/animation/SeekableAnimation;", "T", "", "def", "Landroidx/animation/TransitionDefinition;", "fromState", "toState", "(Landroidx/animation/TransitionDefinition;Ljava/lang/Object;Ljava/lang/Object;)V", "currentAnimWrappers", "", "Landroidx/animation/PropKey;", "Landroidx/animation/AnimationVector;", "Landroidx/animation/Animation;", "currentValues", "getDef", "()Landroidx/animation/TransitionDefinition;", "duration", "", "getDuration", "()J", "getFromState", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getToState", "getAnimValuesAt", "", "playTime", "animation-core_release"})
public final class SeekableAnimation<T> {
    private final Map<PropKey<Object, AnimationVector>, Object> currentValues;
    private final Map<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> currentAnimWrappers;
    private final long duration;
    @NotNull
    private final TransitionDefinition<T> def;
    private final T fromState;
    private final T toState;

    public final long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<PropKey<Object, AnimationVector>, Object> getAnimValuesAt(long playTime) {
        if (playTime <= 0L) {
            StateImpl<T> stateImpl = this.def.getStates$animation_core_release().get(this.fromState);
            Intrinsics.checkNotNull(stateImpl);
            this.currentValues.putAll(stateImpl.getProps$animation_core_release());
        } else if (playTime >= this.duration) {
            StateImpl<T> stateImpl = this.def.getStates$animation_core_release().get(this.toState);
            Intrinsics.checkNotNull(stateImpl);
            this.currentValues.putAll(stateImpl.getProps$animation_core_release());
        } else {
            Object object = this.currentAnimWrappers;
            boolean bl = false;
            Iterator<Map.Entry<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void prop;
                Map.Entry<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> entry;
                Map.Entry<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Animation<Object, AnimationVector> animation = entry2.getValue();
                this.currentValues.put((PropKey<Object, AnimationVector>)prop, animation.getValue(playTime));
            }
        }
        return this.currentValues;
    }

    @NotNull
    public final TransitionDefinition<T> getDef() {
        return this.def;
    }

    public final T getFromState() {
        return this.fromState;
    }

    public final T getToState() {
        return this.toState;
    }

    public SeekableAnimation(@NotNull TransitionDefinition<T> def, T fromState, T toState) {
        Intrinsics.checkNotNullParameter(def, (String)"def");
        this.def = def;
        this.fromState = fromState;
        this.toState = toState;
        boolean bl = false;
        this.currentValues = new LinkedHashMap();
        bl = false;
        this.currentAnimWrappers = new LinkedHashMap();
        StateImpl<Object> stateImpl = this.def.getStates$animation_core_release().get(this.toState);
        Intrinsics.checkNotNull(stateImpl);
        StateImpl<Object> to = stateImpl;
        StateImpl<Object> stateImpl2 = this.def.getStates$animation_core_release().get(this.fromState);
        Intrinsics.checkNotNull(stateImpl2);
        StateImpl<Object> from = stateImpl2;
        this.currentValues.putAll(from.getProps$animation_core_release());
        TransitionSpec<Object> transSpec = this.def.getSpec$animation_core_release(this.fromState, this.toState);
        Map<PropKey<Object, AnimationVector>, Object> map = to.getProps$animation_core_release();
        boolean bl2 = false;
        Iterator<Map.Entry<PropKey<Object, AnimationVector>, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry;
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry2 = entry = iterator.next();
            boolean bl3 = false;
            PropKey<Object, AnimationVector> prop = entry2.getKey();
            this.currentAnimWrappers.put(prop, TransitionAnimationKt.createAnimationWrapper(prop, transSpec.getAnimationForProp$animation_core_release(prop), from.get(prop), null, to.get(prop)));
        }
        Comparable comparable = SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)MapsKt.asSequence(this.currentAnimWrappers), (Function1)duration.1.INSTANCE));
        Intrinsics.checkNotNull((Object)comparable);
        this.duration = ((Number)((Object)comparable)).longValue();
    }
}

