/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.TwoWayConverter;
import androidx.animation.VectorizedAnimationSpec;
import androidx.annotation.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000f\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004BA\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fB?\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\r\u001a\u00028\u0001\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00028\u00012\u0006\u0010\u001d\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0018\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001b\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\r\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006!"}, d2={"Landroidx/animation/TargetBasedAnimation;", "T", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/Animation;", "animationSpec", "Landroidx/animation/VectorizedAnimationSpec;", "startValue", "endValue", "startVelocity", "converter", "Landroidx/animation/TwoWayConverter;", "(Landroidx/animation/VectorizedAnimationSpec;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Landroidx/animation/TwoWayConverter;)V", "startVelocityVector", "(Landroidx/animation/VectorizedAnimationSpec;Ljava/lang/Object;Ljava/lang/Object;Landroidx/animation/AnimationVector;Landroidx/animation/TwoWayConverter;)V", "getConverter", "()Landroidx/animation/TwoWayConverter;", "durationMillis", "", "getDurationMillis", "()J", "getEndValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "endValueVector", "Landroidx/animation/AnimationVector;", "endVelocity", "startValueVector", "getValue", "playTime", "(J)Ljava/lang/Object;", "getVelocityVector", "(J)Landroidx/animation/AnimationVector;", "animation-core_release"})
@VisibleForTesting(otherwise=3)
public final class TargetBasedAnimation<T, V extends AnimationVector>
implements Animation<T, V> {
    private final V startValueVector;
    private final V endValueVector;
    private final long durationMillis;
    private final V endVelocity;
    private final VectorizedAnimationSpec<V> animationSpec;
    private final T endValue;
    private final V startVelocityVector;
    @NotNull
    private final TwoWayConverter<T, V> converter;

    @Override
    public T getValue(long playTime) {
        return (T)(playTime < this.getDurationMillis() ? this.getConverter().getConvertFromVector().invoke(this.animationSpec.getValue(playTime, this.startValueVector, this.endValueVector, this.startVelocityVector)) : this.endValue);
    }

    @Override
    public long getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    @NotNull
    public V getVelocityVector(long playTime) {
        return playTime < this.getDurationMillis() ? this.animationSpec.getVelocity(playTime, this.startValueVector, this.endValueVector, this.startVelocityVector) : this.endVelocity;
    }

    public final T getEndValue() {
        return this.endValue;
    }

    @Override
    @NotNull
    public TwoWayConverter<T, V> getConverter() {
        return this.converter;
    }

    public TargetBasedAnimation(@NotNull VectorizedAnimationSpec<V> animationSpec, T startValue, T endValue, @NotNull V startVelocityVector, @NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(startVelocityVector, (String)"startVelocityVector");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.animationSpec = animationSpec;
        this.endValue = endValue;
        this.startVelocityVector = startVelocityVector;
        this.converter = converter;
        this.startValueVector = (AnimationVector)this.getConverter().getConvertToVector().invoke(startValue);
        this.endValueVector = (AnimationVector)this.getConverter().getConvertToVector().invoke(this.endValue);
        this.durationMillis = this.animationSpec.getDurationMillis(this.startValueVector, this.endValueVector, this.startVelocityVector);
        this.endVelocity = this.animationSpec.getEndVelocity(this.startValueVector, this.endValueVector, this.startVelocityVector);
    }

    public TargetBasedAnimation(@NotNull VectorizedAnimationSpec<V> animationSpec, T startValue, T endValue, T startVelocity, @NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this(animationSpec, (AnimationVector)startValue, (AnimationVector)endValue, (AnimationVector)converter.getConvertToVector().invoke(startVelocity), (TwoWayConverter<AnimationVector, V>)converter);
    }

    @Override
    public boolean isFinished(long playTime) {
        return Animation.DefaultImpls.isFinished(this, playTime);
    }
}

