/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationClockObservable;
import androidx.compose.animation.core.AnimationClockObserver;
import androidx.compose.animation.core.AnimationState;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.InternalAnimationApi;
import androidx.compose.animation.core.InterruptionHandling;
import androidx.compose.animation.core.PropKey;
import androidx.compose.animation.core.StateImpl;
import androidx.compose.animation.core.TransitionAnimationKt;
import androidx.compose.animation.core.TransitionDefinition;
import androidx.compose.animation.core.TransitionSpec;
import androidx.compose.animation.core.TransitionState;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001KB3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020\fH\u0002J\b\u0010?\u001a\u00020.H\u0002J2\u0010@\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u0010A*\u00020\u00172\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002HA0\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020\fH\u0002J\u0016\u0010E\u001a\u00020.2\f\u0010F\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002J\u0015\u0010G\u001a\u00020.2\u0006\u0010<\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u00020.H\u0002J\u0013\u0010<\u001a\u00020.2\u0006\u0010J\u001a\u00028\u0000\u00a2\u0006\u0002\u0010HR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00180\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010'\u001a\u00020 2\u0006\u0010&\u001a\u00020 8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010\u0010\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010+R(\u0010,\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020.\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\"\u00103\u001a\n\u0012\u0004\u0012\u00020.\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0016\u00109\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010;\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Landroidx/compose/animation/core/TransitionAnimation;", "T", "Landroidx/compose/animation/core/TransitionState;", "def", "Landroidx/compose/animation/core/TransitionDefinition;", "clock", "Landroidx/compose/animation/core/AnimationClockObservable;", "initState", "label", "", "(Landroidx/compose/animation/core/TransitionDefinition;Landroidx/compose/animation/core/AnimationClockObservable;Ljava/lang/Object;Ljava/lang/String;)V", "UNSET", "", "animationClockObserver", "Landroidx/compose/animation/core/AnimationClockObserver;", "getAnimationClockObserver$annotations", "()V", "getAnimationClockObserver", "()Landroidx/compose/animation/core/AnimationClockObserver;", "currentAnimWrappers", "", "Landroidx/compose/animation/core/PropKey;", "", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/Animation;", "currentState", "Landroidx/compose/animation/core/AnimationState;", "getDef$animation_core_release", "()Landroidx/compose/animation/core/TransitionDefinition;", "fromState", "Landroidx/compose/animation/core/StateImpl;", "<set-?>", "", "isRunning", "()Z", "getLabel", "()Ljava/lang/String;", "lastFrameTime", "value", "monotonic", "getMonotonic$annotations", "getMonotonic", "setMonotonic", "(Z)V", "onStateChangeFinished", "Lkotlin/Function1;", "", "getOnStateChangeFinished", "()Lkotlin/jvm/functions/Function1;", "setOnStateChangeFinished", "(Lkotlin/jvm/functions/Function1;)V", "onUpdate", "Lkotlin/Function0;", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "setOnUpdate", "(Lkotlin/jvm/functions/Function0;)V", "pendingState", "startTime", "startVelocityMap", "toState", "doAnimationFrame", "frameTimeMillis", "endAnimation", "get", "V", "propKey", "(Landroidx/compose/animation/core/PropKey;)Ljava/lang/Object;", "getPlayTime", "setState", "newState", "snapToState", "(Ljava/lang/Object;)V", "startAnimation", "name", "TransitionAnimationClockObserver", "animation-core_release"})
public final class TransitionAnimation<T>
implements TransitionState {
    @Nullable
    private Function0<Unit> onUpdate;
    @Nullable
    private Function1<? super T, Unit> onStateChangeFinished;
    private boolean isRunning;
    private final long UNSET;
    private StateImpl<T> fromState;
    private StateImpl<T> toState;
    private final AnimationState<T> currentState;
    private long startTime;
    private long lastFrameTime;
    private StateImpl<T> pendingState;
    private Map<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> currentAnimWrappers;
    private Map<PropKey<Object, AnimationVector>, Object> startVelocityMap;
    @NotNull
    private final AnimationClockObserver animationClockObserver;
    private boolean monotonic;
    @NotNull
    private final TransitionDefinition<T> def;
    private final AnimationClockObservable clock;
    @Nullable
    private final String label;

    @Nullable
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    public final void setOnUpdate(@Nullable Function0<Unit> function0) {
        this.onUpdate = function0;
    }

    @Nullable
    public final Function1<T, Unit> getOnStateChangeFinished() {
        return this.onStateChangeFinished;
    }

    public final void setOnStateChangeFinished(@Nullable Function1<? super T, Unit> function1) {
        this.onStateChangeFinished = function1;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @InternalAnimationApi
    public static /* synthetic */ void getAnimationClockObserver$annotations() {
    }

    @NotNull
    public final AnimationClockObserver getAnimationClockObserver() {
        return this.animationClockObserver;
    }

    private final void setState(StateImpl<T> newState) {
        TransitionSpec<T> currentSpec;
        if (this.isRunning && (currentSpec = this.def.getSpec$animation_core_release(this.fromState.getName(), this.toState.getName())).getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
            this.pendingState = newState;
            return;
        }
        TransitionSpec<Object> transitionSpec = this.def.getSpec$animation_core_release(this.toState.getName(), newState.getName());
        long playTime = this.getPlayTime();
        Map<PropKey<Object, AnimationVector>, Object> map = newState.getProps$animation_core_release();
        boolean bl = false;
        Iterator<Map.Entry<PropKey<Object, AnimationVector>, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry;
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            PropKey<Object, AnimationVector> prop = entry2.getKey();
            Animation<Object, AnimationVector> animation = this.currentAnimWrappers.get(prop);
            AnimationVector currentVelocity = animation != null ? animation.getVelocityVector(playTime) : null;
            this.currentAnimWrappers.put(prop, TransitionAnimationKt.createAnimationWrapper(prop, transitionSpec.getAnimationForProp$animation_core_release(prop), this.currentState.get(prop), currentVelocity, newState.get(prop)));
        }
        this.fromState = new AnimationState<T>(this.currentState, this.toState.getName());
        this.toState = newState;
        this.startAnimation();
    }

    private final long getPlayTime() {
        if (this.startTime == this.UNSET) {
            return 0L;
        }
        return this.lastFrameTime - this.startTime;
    }

    public final void toState(T name) {
        StateImpl<T> nextState = this.def.getStates$animation_core_release().get(name);
        if (nextState != null) {
            if (this.pendingState != null && Intrinsics.areEqual(this.toState.getName(), name)) {
                this.pendingState = null;
            } else {
                StateImpl<T> stateImpl = this.pendingState;
                if (stateImpl == null) {
                    stateImpl = this.toState;
                }
                if (!Intrinsics.areEqual(stateImpl.getName(), name)) {
                    this.setState(nextState);
                }
            }
        }
    }

    @InternalAnimationApi
    public static /* synthetic */ void getMonotonic$annotations() {
    }

    public final boolean getMonotonic() {
        return this.monotonic;
    }

    public final void setMonotonic(boolean value) {
        if (this.monotonic == value) {
            return;
        }
        this.monotonic = value;
        if (value && this.isRunning) {
            this.doAnimationFrame(this.lastFrameTime);
        }
    }

    @InternalAnimationApi
    public final void snapToState(T toState) {
        block3: {
            boolean stateChanged = Intrinsics.areEqual(toState, this.fromState.getName());
            StateImpl<Object> stateImpl = this.def.getStates$animation_core_release().get(toState);
            Intrinsics.checkNotNull(stateImpl);
            StateImpl<Object> newState = stateImpl;
            for (PropKey<Object, AnimationVector> prop : newState.getProps$animation_core_release().keySet()) {
                this.currentState.set(prop, newState.get(prop));
            }
            this.startVelocityMap.clear();
            if (this.isRunning) {
                this.endAnimation();
                this.currentAnimWrappers.clear();
                this.fromState = newState;
                this.toState = newState;
                this.pendingState = null;
            }
            if (!stateChanged) break block3;
            Function1<? super T, Unit> function1 = this.onStateChangeFinished;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke(toState);
            }
        }
    }

    @Override
    public <T, V extends AnimationVector> T get(@NotNull PropKey<T, V> propKey) {
        Intrinsics.checkNotNullParameter(propKey, (String)"propKey");
        return this.currentState.get(propKey);
    }

    private final void startAnimation() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.clock.subscribe(this.animationClockObserver);
        } else {
            this.startTime = this.lastFrameTime;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doAnimationFrame(long frameTimeMillis) {
        block11: {
            boolean bl;
            Map.Entry<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> entry;
            this.lastFrameTime = frameTimeMillis;
            if (this.startTime == this.UNSET) {
                this.startTime = frameTimeMillis;
            }
            long playTime = this.getPlayTime();
            boolean finished = true;
            Object object = this.currentAnimWrappers;
            boolean bl2 = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void prop;
                Map.Entry<PropKey<Object, AnimationVector>, Animation<Object, AnimationVector>> entry2;
                entry = entry2 = iterator.next();
                bl = false;
                object = entry.getKey();
                entry = entry2;
                bl = false;
                Animation<Object, AnimationVector> animation = entry.getValue();
                if (!animation.isFinished(playTime)) {
                    this.currentState.set(prop, animation.getValue(playTime));
                    finished = false;
                    continue;
                }
                this.currentState.set(prop, this.toState.get(prop));
            }
            Function0<Unit> function0 = this.onUpdate;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            if (!finished || !this.monotonic) break block11;
            for (PropKey propKey : this.toState.getProps$animation_core_release().keySet()) {
                this.currentState.set(propKey, this.toState.get(propKey));
            }
            this.startVelocityMap.clear();
            this.endAnimation();
            T t = this.toState.getName();
            TransitionSpec<T> spec = this.def.getSpec$animation_core_release(this.fromState.getName(), this.toState.getName());
            Map<T, StateImpl<T>> map = this.def.getStates$animation_core_release();
            entry = spec.getNextState();
            bl = false;
            StateImpl<T> nextState = map.get(entry);
            this.fromState = this.toState;
            if (nextState != null && spec.getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
                this.setState(nextState);
            } else if (this.pendingState != null) {
                StateImpl<T> stateImpl = this.pendingState;
                Intrinsics.checkNotNull(stateImpl);
                this.setState(stateImpl);
                this.pendingState = null;
            } else if (nextState != null) {
                this.setState(nextState);
            }
            Function1<? super T, Unit> function1 = this.onStateChangeFinished;
            if (function1 != null) {
                Unit cfr_ignored_1 = (Unit)function1.invoke(t);
            }
        }
    }

    private final void endAnimation() {
        this.clock.unsubscribe(this.animationClockObserver);
        this.startTime = this.UNSET;
        this.lastFrameTime = this.UNSET;
        this.isRunning = false;
    }

    @NotNull
    public final TransitionDefinition<T> getDef$animation_core_release() {
        return this.def;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    public TransitionAnimation(@NotNull TransitionDefinition<T> def, @NotNull AnimationClockObservable clock, @Nullable T initState, @Nullable String label) {
        Intrinsics.checkNotNullParameter(def, (String)"def");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.def = def;
        this.clock = clock;
        this.label = label;
        this.startTime = this.UNSET = -1L;
        this.lastFrameTime = this.UNSET;
        boolean bl = false;
        this.currentAnimWrappers = new LinkedHashMap();
        bl = false;
        this.startVelocityMap = new LinkedHashMap();
        this.animationClockObserver = new TransitionAnimationClockObserver();
        StateImpl<T> defaultState = null;
        if (initState == null) {
            defaultState = this.def.getDefaultState$animation_core_release();
        } else {
            StateImpl<T> stateImpl = this.def.getStates$animation_core_release().get(initState);
            Intrinsics.checkNotNull(stateImpl);
            defaultState = stateImpl;
        }
        this.currentState = new AnimationState<T>(defaultState, defaultState.getName());
        this.fromState = defaultState;
        this.toState = defaultState;
        this.monotonic = true;
    }

    public /* synthetic */ TransitionAnimation(TransitionDefinition transitionDefinition, AnimationClockObservable animationClockObservable, Object object, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        this(transitionDefinition, animationClockObservable, object, string);
    }

    @InternalAnimationApi
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/compose/animation/core/TransitionAnimation$TransitionAnimationClockObserver;", "Landroidx/compose/animation/core/AnimationClockObserver;", "(Landroidx/compose/animation/core/TransitionAnimation;)V", "animation", "Landroidx/compose/animation/core/TransitionAnimation;", "getAnimation", "()Landroidx/compose/animation/core/TransitionAnimation;", "onAnimationFrame", "", "frameTimeMillis", "", "animation-core_release"})
    public final class TransitionAnimationClockObserver
    implements AnimationClockObserver {
        @NotNull
        private final TransitionAnimation<T> animation;

        @NotNull
        public final TransitionAnimation<T> getAnimation() {
            return this.animation;
        }

        @Override
        public void onAnimationFrame(long frameTimeMillis) {
            TransitionAnimation.this.doAnimationFrame(frameTimeMillis);
        }

        public TransitionAnimationClockObserver() {
            this.animation = TransitionAnimation.this;
        }
    }
}

