/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/animation/core/VectorizedRepeatableSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "iterations", "", "animation", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "repeatMode", "Landroidx/compose/animation/core/RepeatMode;", "(ILandroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;Landroidx/compose/animation/core/RepeatMode;)V", "duration", "getDuration$animation_core_release", "()I", "getDurationMillis", "", "start", "end", "startVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValue", "playTime", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocity", "repetitionPlayTime", "repetitionStartVelocity", "animation-core_release"})
public final class VectorizedRepeatableSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    private final int duration;
    private final int iterations;
    private final VectorizedDurationBasedAnimationSpec<V> animation;
    private final RepeatMode repeatMode;

    public final int getDuration$animation_core_release() {
        return this.duration;
    }

    private final long repetitionPlayTime(long playTime) {
        long l = playTime / (long)this.duration;
        long l2 = (long)this.iterations - 1L;
        boolean bl = false;
        long repeatsCount = Math.min(l, l2);
        if (this.repeatMode == RepeatMode.Restart || repeatsCount % (long)2 == 0L) {
            return playTime - repeatsCount * (long)this.duration;
        }
        return (repeatsCount + 1L) * (long)this.duration - playTime;
    }

    private final V repetitionStartVelocity(long playTime, V start, V startVelocity, V end) {
        return playTime > (long)this.duration ? this.getVelocity(this.duration, start, startVelocity, end) : startVelocity;
    }

    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return this.animation.getValue(this.repetitionPlayTime(playTime), start, end, this.repetitionStartVelocity(playTime, start, startVelocity, end));
    }

    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return this.animation.getVelocity(this.repetitionPlayTime(playTime), start, end, this.repetitionStartVelocity(playTime, start, startVelocity, end));
    }

    @Override
    public long getDurationMillis(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return (long)this.iterations * (long)this.duration;
    }

    public VectorizedRepeatableSpec(int iterations, @NotNull VectorizedDurationBasedAnimationSpec<V> animation, @NotNull RepeatMode repeatMode) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.iterations = iterations;
        this.animation = animation;
        this.repeatMode = repeatMode;
        if (this.iterations < 1) {
            throw (Throwable)new IllegalArgumentException("Iterations count can't be less than 1");
        }
        this.duration = this.animation.getDelayMillis() + this.animation.getDurationMillis();
    }

    public /* synthetic */ VectorizedRepeatableSpec(int n, VectorizedDurationBasedAnimationSpec vectorizedDurationBasedAnimationSpec, RepeatMode repeatMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            repeatMode = RepeatMode.Restart;
        }
        this(n, vectorizedDurationBasedAnimationSpec, repeatMode);
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return VectorizedAnimationSpec.DefaultImpls.getEndVelocity(this, start, end, startVelocity);
    }
}

