/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.PropKeyKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BV\u0012=\u0010\u0004\u001a9\u0012\u0004\u0012\u00020\u0006\u0012/\u0012-\u0012\u0004\u0012\u00028\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\r0\u00070\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"R\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012RE\u0010\u0004\u001a9\u0012\u0004\u0012\u00020\u0006\u0012/\u0012-\u0012\u0004\u0012\u00028\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\r0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006#"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "(Ljava/util/Map;II)V", "getDelayMillis", "()I", "getDurationMillis", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "getValue", "playTime", "", "start", "end", "startVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocity", "init", "", "value", "(Landroidx/compose/animation/core/AnimationVector;)V", "animation-core_release"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    private V valueVector;
    private V velocityVector;
    private final Map<Integer, Pair<V, Function1<Float, Float>>> keyframes;
    private final int durationMillis;
    private final int delayMillis;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.access$clampPlayTime(this, playTime);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            return (V)((AnimationVector)((Pair)MapsKt.getValue(this.keyframes, (Object)clampedPlayTime)).getFirst());
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return end;
        }
        if (clampedPlayTime <= 0) {
            return start;
        }
        int startTime = 0;
        Object startVal = start;
        Object endVal = end;
        int endTime = this.getDurationMillis();
        Function1 easing = EasingKt.getLinearEasing();
        Map<Integer, Pair<V, Function1<Float, Float>>> map = this.keyframes;
        boolean bl = false;
        Iterator<Map.Entry<Integer, Pair<V, Function1<Float, Float>>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void timestamp;
            Map.Entry<Integer, Pair<Pair<Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>> entry;
            Map.Entry<Integer, Pair<Pair<Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl2 = false;
            Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>> value = entry2.getValue();
            if (clampedPlayTime > timestamp && timestamp >= startTime) {
                startTime = timestamp;
                startVal = (AnimationVector)value.getFirst();
                easing = (Function1)value.getSecond();
                continue;
            }
            if (clampedPlayTime >= timestamp || timestamp > endTime) continue;
            endTime = timestamp;
            endVal = (AnimationVector)value.getFirst();
        }
        float fraction = ((Number)easing.invoke((Object)Float.valueOf((float)(clampedPlayTime - startTime) / (float)(endTime - startTime)))).floatValue();
        this.init(start);
        int n = 0;
        int n2 = ((AnimationVector)startVal).getSize$animation_core_release();
        while (n < n2) {
            void i;
            V v = this.valueVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            }
            ((AnimationVector)v).set$animation_core_release((int)i, PropKeyKt.lerp(((AnimationVector)startVal).get$animation_core_release((int)i), ((AnimationVector)endVal).get$animation_core_release((int)i), fraction));
            ++i;
        }
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    private final void init(V value) {
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(value);
            this.velocityVector = AnimationVectorsKt.newInstance(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        long clampedPlayTime = VectorizedAnimationSpecKt.access$clampPlayTime(this, playTime);
        if (clampedPlayTime <= 0L) {
            return startVelocity;
        }
        V startNum = this.getValue(clampedPlayTime - 1L, start, end, startVelocity);
        V endNum = this.getValue(clampedPlayTime, start, end, startVelocity);
        this.init(start);
        int n = 0;
        int n2 = ((AnimationVector)startNum).getSize$animation_core_release();
        while (n < n2) {
            void i;
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            }
            ((AnimationVector)v).set$animation_core_release((int)i, (((AnimationVector)startNum).get$animation_core_release((int)i) - ((AnimationVector)endNum).get$animation_core_release((int)i)) * 1000.0f);
            ++i;
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v;
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Function1<? super Float, Float>>> keyframes, int durationMillis, int delayMillis) {
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map, n, n2);
    }

    @Override
    public long getDurationMillis(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getDurationMillis(this, start, end, startVelocity);
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getEndVelocity(this, start, end, startVelocity);
    }

    public static final /* synthetic */ AnimationVector access$getValueVector$p(VectorizedKeyframesSpec $this) {
        Object v = $this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setValueVector$p(VectorizedKeyframesSpec $this, AnimationVector animationVector) {
        $this.valueVector = animationVector;
    }
}

