/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0013"}, d2={"Landroidx/compose/animation/core/VectorizedSnapSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "delayMillis", "", "(I)V", "getDelayMillis", "()I", "durationMillis", "getDurationMillis", "getValue", "playTime", "", "start", "end", "startVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocity", "animation-core_release"})
public final class VectorizedSnapSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    private final int delayMillis;

    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (playTime < (long)this.getDelayMillis()) {
            return start;
        }
        return end;
    }

    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return startVelocity;
    }

    @Override
    public int getDurationMillis() {
        return 0;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    public VectorizedSnapSpec(int delayMillis) {
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ VectorizedSnapSpec(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public VectorizedSnapSpec() {
        this(0, 1, null);
    }

    @Override
    public long getDurationMillis(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getDurationMillis(this, start, end, startVelocity);
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getEndVelocity(this, start, end, startVelocity);
    }
}

