/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.PropKeyKt;
import androidx.compose.animation.core.TwoWayConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/animation/core/DecayAnimation;", "Landroidx/compose/animation/core/Animation;", "", "Landroidx/compose/animation/core/AnimationVector1D;", "anim", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "startValue", "startVelocity", "(Landroidx/compose/animation/core/FloatDecayAnimationSpec;FF)V", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "getConverter", "()Landroidx/compose/animation/core/TwoWayConverter;", "durationMillis", "", "getDurationMillis", "()J", "target", "velocityVector", "getValue", "playTime", "(J)Ljava/lang/Float;", "getVelocityVector", "animation-core_release"})
public final class DecayAnimation
implements Animation<Float, AnimationVector1D> {
    private final float target;
    private final AnimationVector1D velocityVector;
    private final long durationMillis;
    private final FloatDecayAnimationSpec anim;
    private final float startValue;
    private final float startVelocity;

    @Override
    @NotNull
    public TwoWayConverter<Float, AnimationVector1D> getConverter() {
        return PropKeyKt.getVectorConverter(FloatCompanionObject.INSTANCE);
    }

    @Override
    @NotNull
    public Float getValue(long playTime) {
        if (!this.isFinished(playTime)) {
            return Float.valueOf(this.anim.getValue(playTime, this.startValue, this.startVelocity));
        }
        return Float.valueOf(this.target);
    }

    @Override
    @NotNull
    public AnimationVector1D getVelocityVector(long playTime) {
        if (!this.isFinished(playTime)) {
            this.velocityVector.setValue$animation_core_release(this.anim.getVelocity(playTime, this.startValue, this.startVelocity));
        } else {
            float f = this.startVelocity;
            boolean bl = false;
            this.velocityVector.setValue$animation_core_release(this.anim.getAbsVelocityThreshold() * Math.signum(f));
        }
        return this.velocityVector;
    }

    @Override
    public long getDurationMillis() {
        return this.durationMillis;
    }

    public DecayAnimation(@NotNull FloatDecayAnimationSpec anim, float startValue, float startVelocity) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this.anim = anim;
        this.startValue = startValue;
        this.startVelocity = startVelocity;
        this.target = this.anim.getTarget(this.startValue, this.startVelocity);
        this.velocityVector = new AnimationVector1D(0.0f);
        this.durationMillis = this.anim.getDurationMillis(this.startValue, this.startVelocity);
    }

    public /* synthetic */ DecayAnimation(FloatDecayAnimationSpec floatDecayAnimationSpec, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f2 = 0.0f;
        }
        this(floatDecayAnimationSpec, f, f2);
    }

    @Override
    public boolean isFinished(long playTime) {
        return Animation.DefaultImpls.isFinished(this, playTime);
    }
}

