/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import androidx.compose.animation.core.AnimationClockObserver;
import androidx.compose.animation.core.BaseAnimationClock;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/compose/animation/core/DefaultAnimationClock;", "Landroidx/compose/animation/core/BaseAnimationClock;", "()V", "frameCallback", "Landroid/view/Choreographer$FrameCallback;", "mainChoreographer", "Landroid/view/Choreographer;", "subscribedToChoreographer", "", "dispatchTime", "", "frameTimeMillis", "", "dispatchTime$animation_core_release", "subscribe", "observer", "Landroidx/compose/animation/core/AnimationClockObserver;", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class DefaultAnimationClock
extends BaseAnimationClock {
    @NotNull
    private final Choreographer mainChoreographer;
    private volatile boolean subscribedToChoreographer;
    @NotNull
    private final Choreographer.FrameCallback frameCallback;
    public static final int $stable = 8;

    public DefaultAnimationClock() {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            Choreographer choreographer = Choreographer.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"getInstance()");
            this.mainChoreographer = choreographer;
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            Ref.ObjectRef choreographer = new Ref.ObjectRef();
            new Handler(Looper.getMainLooper()).postAtFrontOfQueue(new Runnable((Ref.ObjectRef<Choreographer>)choreographer, latch){
                final /* synthetic */ Ref.ObjectRef<Choreographer> $choreographer;
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.$choreographer = $choreographer;
                    this.$latch = $latch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    try {
                        this.$choreographer.element = Choreographer.getInstance();
                    }
                    finally {
                        this.$latch.countDown();
                    }
                }
            });
            latch.await();
            Intrinsics.checkNotNull((Object)choreographer.element);
            this.mainChoreographer = (Choreographer)choreographer.element;
        }
        this.frameCallback = new Choreographer.FrameCallback(this){
            final /* synthetic */ DefaultAnimationClock this$0;
            {
                this.this$0 = $receiver;
            }

            public final void doFrame(long it) {
                this.this$0.dispatchTime$animation_core_release(it / (long)1000000);
            }
        };
    }

    @Override
    public void subscribe(@NotNull AnimationClockObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        if (!this.subscribedToChoreographer) {
            this.mainChoreographer.postFrameCallback(this.frameCallback);
            this.subscribedToChoreographer = true;
        }
        super.subscribe(observer);
    }

    @Override
    public void dispatchTime$animation_core_release(long frameTimeMillis) {
        boolean bl;
        super.dispatchTime$animation_core_release(frameTimeMillis);
        if (this.hasObservers$animation_core_release()) {
            this.mainChoreographer.postFrameCallback(this.frameCallback);
            bl = true;
        } else {
            bl = false;
        }
        this.subscribedToChoreographer = bl;
    }
}

