/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core.lint;

import androidx.compose.animation.core.lint.TransitionDetectorKt;
import androidx.compose.lint.KotlinUtilsKt;
import androidx.compose.lint.UnreferencedParameter;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UParameter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/animation/core/lint/TransitionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "animation-core-lint"})
public final class TransitionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    private static final Issue UnusedTransitionTargetStateParameter;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;

            /*
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                PsiType boxedType;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                PsiType psiType = node.getReceiverType();
                if (!(psiType instanceof PsiClassReferenceType)) {
                    psiType = null;
                }
                PsiClassReferenceType psiClassReferenceType = (PsiClassReferenceType)psiType;
                if (psiClassReferenceType == null) {
                    return;
                }
                PsiClassReferenceType receiverType = psiClassReferenceType;
                if (!receiverType.rawType().equalsToText(TransitionDetectorKt.access$getTransition$p().getJavaFqn())) {
                    return;
                }
                String string = node.getMethodName();
                if (string == null || !StringsKt.startsWith$default((String)string, (String)"animate", (boolean)false, (int)2, null)) {
                    return;
                }
                Iterable iterable = node.getValueArguments();
                boolean $i$f$filterIsInstance = false;
                Iterator<T> iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ULambdaExpression)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    ULambdaExpression argument = (ULambdaExpression)element$iv$iv;
                    boolean bl2 = false;
                    List parameters = argument.getValueParameters();
                    if (parameters.size() != 1) {
                        bl = false;
                    } else {
                        UParameter parameter = (UParameter)CollectionsKt.first((List)parameters);
                        PsiType type = parameter.getType();
                        boxedType = type instanceof PsiPrimitiveType ? (PsiType)((PsiPrimitiveType)type).getBoxedType((PsiElement)method) : type;
                        bl = Intrinsics.areEqual((Object)boxedType, (Object)receiverType.getParameters()[0]);
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List matchingLambdaArguments = (List)destination$iv$iv;
                Iterable $this$forEach$iv = matchingLambdaArguments;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ULambdaExpression lambda = (ULambdaExpression)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = KotlinUtilsKt.findUnreferencedParameters(lambda);
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        KtParameter ktParameter;
                        UnreferencedParameter unreferencedParameter;
                        block15: {
                            block14: {
                                unreferencedParameter = (UnreferencedParameter)element$iv2;
                                boolean bl3 = false;
                                ktParameter = unreferencedParameter.getParameter();
                                if (ktParameter == null) break block14;
                                boxedType = ktParameter;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                PsiType it = boxedType;
                                boolean bl6 = false;
                                ktParameter = this.$context.getLocation((PsiElement)it);
                                if (ktParameter != null) break block15;
                            }
                            ktParameter = this.$context.getLocation((UElement)lambda);
                        }
                        KtParameter location = ktParameter;
                        String name = unreferencedParameter.getName();
                        JavaContext.report$default((JavaContext)this.$context, (Issue)TransitionDetector.Companion.getUnusedTransitionTargetStateParameter(), (UElement)((UElement)node), (Location)location, (String)("Target state parameter `" + name + "` is not used"), null, (int)16, null);
                    }
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        };
    }

    static {
        Companion = new Companion(null);
        UnusedTransitionTargetStateParameter = Issue.Companion.create("UnusedTransitionTargetStateParameter", "Transition.animate* calls should use the provided targetState when defining values", "Transition.animate* functions provide a target state parameter in the lambda that will be used to calculate the value for a given state. This target state parameter in the lambda may or may not be the same as the actual state, as the animation system occasionally needs to look up target values for other states to do proper seeking/tooling preview. Relying on other state than the provided `targetState` could also result in unnecessary recompositions. Therefore, it is generally considered an error if this `targetState` parameter is not used.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(TransitionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/core/lint/TransitionDetector$Companion;", "", "()V", "UnusedTransitionTargetStateParameter", "Lcom/android/tools/lint/detector/api/Issue;", "getUnusedTransitionTargetStateParameter", "()Lcom/android/tools/lint/detector/api/Issue;", "animation-core-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getUnusedTransitionTargetStateParameter() {
            return UnusedTransitionTargetStateParameter;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

