/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u000b\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\r\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001a"}, d2={"Landroidx/compose/animation/core/VectorizedFloatAnimationSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedFiniteAnimationSpec;", "anim", "Landroidx/compose/animation/core/FloatAnimationSpec;", "(Landroidx/compose/animation/core/FloatAnimationSpec;)V", "anims", "Landroidx/compose/animation/core/Animations;", "(Landroidx/compose/animation/core/Animations;)V", "endVelocityVector", "Landroidx/compose/animation/core/AnimationVector;", "valueVector", "velocityVector", "getDurationNanos", "", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getEndVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getValueFromNanos", "playTimeNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class VectorizedFloatAnimationSpec<V extends AnimationVector>
implements VectorizedFiniteAnimationSpec<V> {
    @NotNull
    private final Animations anims;
    private V valueVector;
    private V velocityVector;
    private V endVelocityVector;
    public static final int $stable = 8;

    public VectorizedFloatAnimationSpec(@NotNull Animations anims) {
        Intrinsics.checkNotNullParameter((Object)anims, (String)"anims");
        this.anims = anims;
    }

    public VectorizedFloatAnimationSpec(final @NotNull FloatAnimationSpec anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this(new Animations(){

            @Override
            @NotNull
            public FloatAnimationSpec get(int index) {
                return anim;
            }
        });
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int n = 0;
        V v2 = this.valueVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.valueVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.anims.get(i).getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)targetValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.valueVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            throw null;
        }
        return v;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int n = 0;
        V v2 = this.velocityVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.velocityVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.anims.get(i).getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)targetValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.velocityVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        return v;
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.endVelocityVector == null) {
            this.endVelocityVector = AnimationVectorsKt.newInstance(initialVelocity);
        }
        int n = 0;
        V v2 = this.endVelocityVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.endVelocityVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.anims.get(i).getEndVelocity(((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)targetValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.endVelocityVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            throw null;
        }
        return v;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((AnimationVector)initialValue).getSize$animation_core_release());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            long l = maxDuration;
            long l2 = this.anims.get(it).getDurationNanos(((AnimationVector)initialValue).get$animation_core_release(it), ((AnimationVector)targetValue).get$animation_core_release(it), ((AnimationVector)initialVelocity).get$animation_core_release(it));
            boolean bl2 = false;
            maxDuration = Math.max(l, l2);
        }
        return maxDuration;
    }

    @Override
    public boolean isInfinite() {
        return VectorizedFiniteAnimationSpec.DefaultImpls.isInfinite(this);
    }
}

