/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B7\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ-\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\n\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001e"}, d2={"Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "keyframes", "", "", "Lkotlin/Pair;", "Landroidx/compose/animation/core/Easing;", "durationMillis", "delayMillis", "(Ljava/util/Map;II)V", "getDelayMillis", "()I", "getDurationMillis", "valueVector", "Landroidx/compose/animation/core/AnimationVector;", "velocityVector", "getValueFromNanos", "playTimeNanos", "", "initialValue", "targetValue", "initialVelocity", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "init", "", "value", "(Landroidx/compose/animation/core/AnimationVector;)V", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final Map<Integer, Pair<V, Easing>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    private V valueVector;
    private V velocityVector;
    public static final int $stable = 8;

    public VectorizedKeyframesSpec(@NotNull Map<Integer, ? extends Pair<? extends V, ? extends Easing>> keyframes, int durationMillis, int delayMillis) {
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
    }

    public /* synthetic */ VectorizedKeyframesSpec(Map map, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(map, n, n2);
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        Object object;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            return (V)((AnimationVector)((Pair)MapsKt.getValue(this.keyframes, (Object)clampedPlayTime)).getFirst());
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        int startTime = 0;
        Object startVal = initialValue;
        Object endVal = targetValue;
        int endTime = this.getDurationMillis();
        Easing easing = EasingKt.getLinearEasing();
        Object object2 = this.keyframes;
        int n = 0;
        Iterator<Map.Entry<Integer, Pair<V, Easing>>> iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object3 = object2 = iterator.next();
            boolean bl = false;
            int timestamp = ((Number)object3.getKey()).intValue();
            object = object2;
            boolean bl2 = false;
            Pair value = (Pair)object.getValue();
            if (clampedPlayTime > timestamp && timestamp >= startTime) {
                startTime = timestamp;
                startVal = (AnimationVector)value.getFirst();
                easing = (Easing)value.getSecond();
                continue;
            }
            if (clampedPlayTime >= timestamp || timestamp > endTime) continue;
            endTime = timestamp;
            endVal = (AnimationVector)value.getFirst();
        }
        float fraction = easing.transform((float)(clampedPlayTime - startTime) / (float)(endTime - startTime));
        this.init(initialValue);
        int n2 = 0;
        n = ((AnimationVector)startVal).getSize$animation_core_release();
        if (n2 < n) {
            do {
                int i = n2++;
                object = this.valueVector;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                    throw null;
                }
                ((AnimationVector)object).set$animation_core_release(i, VectorConvertersKt.lerp(((AnimationVector)startVal).get$animation_core_release(i), ((AnimationVector)endVal).get$animation_core_release(i), fraction));
            } while (n2 < n);
        }
        if ((v = this.valueVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            throw null;
        }
        return v;
    }

    private final void init(V value) {
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(value);
            this.velocityVector = AnimationVectorsKt.newInstance(value);
        }
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.access$clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime <= 0L) {
            return initialVelocity;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue, initialVelocity);
        this.init(initialValue);
        int n = 0;
        int n2 = ((AnimationVector)startNum).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v2 = this.velocityVector;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                    throw null;
                }
                ((AnimationVector)v2).set$animation_core_release(i, (((AnimationVector)startNum).get$animation_core_release(i) - ((AnimationVector)endNum).get$animation_core_release(i)) * 1000.0f);
            } while (n < n2);
        }
        if ((v = this.velocityVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        return v;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getDurationNanos(this, initialValue, targetValue, initialVelocity);
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.getEndVelocity(this, initialValue, targetValue, initialVelocity);
    }

    @Override
    public boolean isInfinite() {
        return VectorizedDurationBasedAnimationSpec.DefaultImpls.isInfinite(this);
    }
}

