/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.lint;

import androidx.compose.lint.KotlinMetadataUtilsKt;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.ClassUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\bH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"KotlinMetadataFqn", "", "findKmFunctionForPsiMethod", "Lkotlinx/metadata/KmFunction;", "Lkotlinx/metadata/KmDeclarationContainer;", "method", "Lcom/intellij/psi/PsiMethod;", "getKmDeclarationContainer", "Lcom/intellij/psi/impl/compiled/ClsMemberImpl;", "toHeader", "Lkotlinx/metadata/jvm/KotlinClassHeader;", "Lcom/intellij/psi/PsiAnnotation;", "toKmFunction", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "common"})
public final class KotlinMetadataUtilsKt {
    private static final String KotlinMetadataFqn = "kotlin.Metadata";

    @Nullable
    public static final KmFunction toKmFunction(@NotNull ClsMethodImpl $this$toKmFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$toKmFunction, (String)"$this$toKmFunction");
        KmDeclarationContainer kmDeclarationContainer = KotlinMetadataUtilsKt.getKmDeclarationContainer((ClsMemberImpl)$this$toKmFunction);
        return kmDeclarationContainer != null ? KotlinMetadataUtilsKt.findKmFunctionForPsiMethod(kmDeclarationContainer, (PsiMethod)$this$toKmFunction) : null;
    }

    private static final KmDeclarationContainer getKmDeclarationContainer(ClsMemberImpl<?> $this$getKmDeclarationContainer) {
        KmDeclarationContainer kmDeclarationContainer;
        KotlinClassMetadata metadata;
        PsiAnnotation[] psiAnnotationArray;
        block19: {
            block18: {
                PsiAnnotation[] psiAnnotationArray2;
                block17: {
                    psiAnnotationArray = $this$getKmDeclarationContainer.getContainingClass();
                    if (psiAnnotationArray == null || (psiAnnotationArray = psiAnnotationArray.getAnnotations()) == null) break block18;
                    PsiAnnotation[] psiAnnotationArray3 = psiAnnotationArray;
                    boolean bl = false;
                    PsiAnnotation[] psiAnnotationArray4 = psiAnnotationArray3;
                    boolean bl2 = false;
                    PsiAnnotation[] psiAnnotationArray5 = psiAnnotationArray4;
                    int n = psiAnnotationArray5.length;
                    for (int i = 0; i < n; ++i) {
                        PsiAnnotation[] psiAnnotationArray6;
                        PsiAnnotation[] it = psiAnnotationArray6 = psiAnnotationArray5[i];
                        boolean bl3 = false;
                        PsiAnnotation[] psiAnnotationArray7 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray7, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiAnnotationArray7.getQualifiedName(), (Object)KotlinMetadataFqn)) continue;
                        psiAnnotationArray2 = psiAnnotationArray6;
                        break block17;
                    }
                    psiAnnotationArray2 = psiAnnotationArray = null;
                }
                if (psiAnnotationArray2 != null) break block19;
            }
            return null;
        }
        PsiAnnotation[] classKotlinMetadataAnnotation = psiAnnotationArray;
        KotlinClassMetadata kotlinClassMetadata = KotlinClassMetadata.Companion.read(KotlinMetadataUtilsKt.toHeader((PsiAnnotation)classKotlinMetadataAnnotation));
        if (kotlinClassMetadata == null) {
            return null;
        }
        KotlinClassMetadata kotlinClassMetadata2 = metadata = kotlinClassMetadata;
        if (kotlinClassMetadata2 instanceof KotlinClassMetadata.Class) {
            kmDeclarationContainer = ((KotlinClassMetadata.Class)metadata).toKmClass();
        } else if (kotlinClassMetadata2 instanceof KotlinClassMetadata.FileFacade) {
            kmDeclarationContainer = ((KotlinClassMetadata.FileFacade)metadata).toKmPackage();
        } else if (kotlinClassMetadata2 instanceof KotlinClassMetadata.SyntheticClass) {
            kmDeclarationContainer = null;
        } else if (kotlinClassMetadata2 instanceof KotlinClassMetadata.MultiFileClassFacade) {
            kmDeclarationContainer = null;
        } else if (kotlinClassMetadata2 instanceof KotlinClassMetadata.MultiFileClassPart) {
            kmDeclarationContainer = ((KotlinClassMetadata.MultiFileClassPart)metadata).toKmPackage();
        } else if (kotlinClassMetadata2 instanceof KotlinClassMetadata.Unknown) {
            kmDeclarationContainer = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kmDeclarationContainer;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinClassHeader toHeader(PsiAnnotation $this$toHeader) {
        void $this$associateTo$iv$iv;
        List list = $this$toHeader.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"attributes");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            JvmAnnotationAttribute it = (JvmAnnotationAttribute)element$iv$iv;
            boolean bl = false;
            JvmAnnotationAttribute jvmAnnotationAttribute = it;
            Intrinsics.checkNotNullExpressionValue((Object)jvmAnnotationAttribute, (String)"it");
            it = TuplesKt.to((Object)jvmAnnotationAttribute.getAttributeName(), (Object)it.getAttributeValue());
            bl = false;
            map2.put(it.getFirst(), it.getSecond());
        }
        Map attributes = destination$iv$iv;
        toHeader.1 $fun$parseString$1 = toHeader.1.INSTANCE;
        toHeader.2 $fun$parseInt$2 = toHeader.2.INSTANCE;
        toHeader.3 $fun$parseStringArray$3 = toHeader.3.INSTANCE;
        toHeader.4 $fun$parseIntArray$4 = toHeader.4.INSTANCE;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)attributes.get("k");
        Integer kind = jvmAnnotationAttributeValue != null ? Integer.valueOf($fun$parseInt$2.invoke(jvmAnnotationAttributeValue)) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue2 = (JvmAnnotationAttributeValue)attributes.get("mv");
        int[] metadataVersion = jvmAnnotationAttributeValue2 != null ? $fun$parseIntArray$4.invoke(jvmAnnotationAttributeValue2) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue3 = (JvmAnnotationAttributeValue)attributes.get("bv");
        int[] bytecodeVersion = jvmAnnotationAttributeValue3 != null ? $fun$parseIntArray$4.invoke(jvmAnnotationAttributeValue3) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue4 = (JvmAnnotationAttributeValue)attributes.get("d1");
        String[] data1 = jvmAnnotationAttributeValue4 != null ? $fun$parseStringArray$3.invoke(jvmAnnotationAttributeValue4) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue5 = (JvmAnnotationAttributeValue)attributes.get("d2");
        String[] data2 = jvmAnnotationAttributeValue5 != null ? $fun$parseStringArray$3.invoke(jvmAnnotationAttributeValue5) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue6 = (JvmAnnotationAttributeValue)attributes.get("xs");
        String extraString = jvmAnnotationAttributeValue6 != null ? $fun$parseString$1.invoke(jvmAnnotationAttributeValue6) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue7 = (JvmAnnotationAttributeValue)attributes.get("pn");
        String packageName = jvmAnnotationAttributeValue7 != null ? $fun$parseString$1.invoke(jvmAnnotationAttributeValue7) : null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue8 = (JvmAnnotationAttributeValue)attributes.get("xi");
        Integer extraInt = jvmAnnotationAttributeValue8 != null ? Integer.valueOf($fun$parseInt$2.invoke(jvmAnnotationAttributeValue8)) : null;
        return new KotlinClassHeader(kind, metadataVersion, bytecodeVersion, data1, data2, extraString, packageName, extraInt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KmFunction findKmFunctionForPsiMethod(KmDeclarationContainer $this$findKmFunctionForPsiMethod, PsiMethod method) {
        Object t;
        Object v1;
        boolean bl;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
        String expectedName = StringsKt.substringBefore$default((String)string, (String)"-", null, (int)2, null);
        String expectedSignature = ClassUtil.getAsmMethodSignature((PsiMethod)method);
        Iterable iterable = $this$findKmFunctionForPsiMethod.getFunctions();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        boolean bl3 = false;
        Iterator iterator = iterable2.iterator();
        do {
            if (!iterator.hasNext()) {
                v1 = null;
                return v1;
            }
            t = iterator.next();
            KmFunction it = (KmFunction)t;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)expectedName)) {
                JvmMethodSignature jvmMethodSignature = JvmExtensionsKt.getSignature(it);
                if (Intrinsics.areEqual((Object)(jvmMethodSignature != null ? jvmMethodSignature.getDesc() : null), (Object)expectedSignature)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v1 = t;
        return v1;
    }
}

