/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ%\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J-\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J-\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/animation/core/VectorizedInfiniteRepeatableSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "animation", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "repeatMode", "Landroidx/compose/animation/core/RepeatMode;", "(Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;Landroidx/compose/animation/core/RepeatMode;)V", "durationNanos", "", "getDurationNanos$animation_core_release", "()J", "isInfinite", "", "()Z", "getDurationNanos", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromNanos", "playTimeNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "repetitionPlayTimeNanos", "repetitionStartVelocity", "start", "startVelocity", "end", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class VectorizedInfiniteRepeatableSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    @NotNull
    private final VectorizedDurationBasedAnimationSpec<V> animation;
    @NotNull
    private final RepeatMode repeatMode;
    private final long durationNanos;
    public static final int $stable = 8;

    public VectorizedInfiniteRepeatableSpec(@NotNull VectorizedDurationBasedAnimationSpec<V> animation, @NotNull RepeatMode repeatMode) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.animation = animation;
        this.repeatMode = repeatMode;
        this.durationNanos = (long)(this.animation.getDelayMillis() + this.animation.getDurationMillis()) * 1000000L;
    }

    public /* synthetic */ VectorizedInfiniteRepeatableSpec(VectorizedDurationBasedAnimationSpec vectorizedDurationBasedAnimationSpec, RepeatMode repeatMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            repeatMode = RepeatMode.Restart;
        }
        this(vectorizedDurationBasedAnimationSpec, repeatMode);
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    public final long getDurationNanos$animation_core_release() {
        return this.durationNanos;
    }

    private final long repetitionPlayTimeNanos(long playTimeNanos) {
        long repeatsCount = playTimeNanos / this.durationNanos;
        if (this.repeatMode == RepeatMode.Restart || repeatsCount % (long)2 == 0L) {
            return playTimeNanos - repeatsCount * this.durationNanos;
        }
        return (repeatsCount + 1L) * this.durationNanos - playTimeNanos;
    }

    private final V repetitionStartVelocity(long playTimeNanos, V start, V startVelocity, V end) {
        return playTimeNanos > this.durationNanos ? this.getVelocityFromNanos(this.durationNanos, start, startVelocity, end) : startVelocity;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getValueFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), initialValue, targetValue, this.repetitionStartVelocity(playTimeNanos, initialValue, initialVelocity, targetValue));
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.animation.getVelocityFromNanos(this.repetitionPlayTimeNanos(playTimeNanos), initialValue, targetValue, this.repetitionStartVelocity(playTimeNanos, initialValue, initialVelocity, targetValue));
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        return VectorizedAnimationSpec.DefaultImpls.getEndVelocity(this, initialValue, targetValue, initialVelocity);
    }
}

