/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.animation.core.VectorizedDecayAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\n\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J%\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u0010\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/core/VectorizedFloatDecaySpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedDecayAnimationSpec;", "floatDecaySpec", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "(Landroidx/compose/animation/core/FloatDecayAnimationSpec;)V", "absVelocityThreshold", "", "getAbsVelocityThreshold", "()F", "getFloatDecaySpec", "()Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "targetVector", "Landroidx/compose/animation/core/AnimationVector;", "valueVector", "velocityVector", "getDurationNanos", "", "initialValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getTargetValue", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getValueFromNanos", "playTimeNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "animation-core_release"})
final class VectorizedFloatDecaySpec<V extends AnimationVector>
implements VectorizedDecayAnimationSpec<V> {
    @NotNull
    private final FloatDecayAnimationSpec floatDecaySpec;
    private V valueVector;
    private V velocityVector;
    private V targetVector;
    private final float absVelocityThreshold;

    public VectorizedFloatDecaySpec(@NotNull FloatDecayAnimationSpec floatDecaySpec) {
        Intrinsics.checkNotNullParameter((Object)floatDecaySpec, (String)"floatDecaySpec");
        this.floatDecaySpec = floatDecaySpec;
        this.absVelocityThreshold = this.floatDecaySpec.getAbsVelocityThreshold();
    }

    @NotNull
    public final FloatDecayAnimationSpec getFloatDecaySpec() {
        return this.floatDecaySpec;
    }

    @Override
    public float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int n = 0;
        V v2 = this.valueVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.valueVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.floatDecaySpec.getValueFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.valueVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            throw null;
        }
        return v;
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long maxDuration = 0L;
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int n = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        int n2 = ((AnimationVector)v).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                long l = this.floatDecaySpec.getDurationNanos(((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i));
                boolean bl = false;
                maxDuration = Math.max(maxDuration, l);
            } while (n < n2);
        }
        return maxDuration;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int n = 0;
        V v2 = this.velocityVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.velocityVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.floatDecaySpec.getVelocityFromNanos(playTimeNanos, ((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.velocityVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            throw null;
        }
        return v;
    }

    @Override
    @NotNull
    public V getTargetValue(@NotNull V initialValue, @NotNull V initialVelocity) {
        V v;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        if (this.targetVector == null) {
            this.targetVector = AnimationVectorsKt.newInstance(initialValue);
        }
        int n = 0;
        V v2 = this.targetVector;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            throw null;
        }
        int n2 = ((AnimationVector)v2).getSize$animation_core_release();
        if (n < n2) {
            do {
                int i = n++;
                V v3 = this.targetVector;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
                    throw null;
                }
                ((AnimationVector)v3).set$animation_core_release(i, this.floatDecaySpec.getTargetValue(((AnimationVector)initialValue).get$animation_core_release(i), ((AnimationVector)initialVelocity).get$animation_core_release(i)));
            } while (n < n2);
        }
        if ((v = this.targetVector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"targetVector");
            throw null;
        }
        return v;
    }
}

