/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.lint;

import com.intellij.lang.jvm.annotation.JvmAnnotationArrayValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0004*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"KotlinMetadataFqn", "", "findKmFunctionForPsiMethod", "Lkotlinx/metadata/KmFunction;", "Lkotlinx/metadata/KmDeclarationContainer;", "method", "Lcom/intellij/psi/PsiMethod;", "getKmDeclarationContainer", "Lcom/intellij/psi/PsiClass;", "toHeader", "Lkotlinx/metadata/jvm/KotlinClassHeader;", "Lcom/intellij/psi/PsiAnnotation;", "toKmFunction", "common"})
public final class KotlinMetadataUtilsKt {
    @NotNull
    private static final String KotlinMetadataFqn = "kotlin.Metadata";

    @Nullable
    public static final KmFunction toKmFunction(@NotNull PsiMethod $this$toKmFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$toKmFunction, (String)"<this>");
        PsiClass psiClass = $this$toKmFunction.getContainingClass();
        Intrinsics.checkNotNull((Object)psiClass);
        PsiClass psiClass2 = psiClass;
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"containingClass!!");
        KmDeclarationContainer kmDeclarationContainer = KotlinMetadataUtilsKt.getKmDeclarationContainer(psiClass2);
        return kmDeclarationContainer == null ? null : KotlinMetadataUtilsKt.findKmFunctionForPsiMethod(kmDeclarationContainer, $this$toKmFunction);
    }

    private static final KmDeclarationContainer getKmDeclarationContainer(PsiClass $this$getKmDeclarationContainer) {
        KmDeclarationContainer kmDeclarationContainer;
        PsiAnnotation psiAnnotation;
        Object object;
        block15: {
            object = $this$getKmDeclarationContainer.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"annotations");
            object = object;
            boolean bl = false;
            Object[] objectArray = object;
            boolean bl2 = false;
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiAnnotation psiAnnotation2;
                PsiAnnotation it = psiAnnotation2 = objectArray2[i];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)KotlinMetadataFqn)) continue;
                psiAnnotation = psiAnnotation2;
                break block15;
            }
            psiAnnotation = null;
        }
        PsiAnnotation psiAnnotation3 = psiAnnotation;
        if (psiAnnotation3 == null) {
            return null;
        }
        PsiAnnotation classKotlinMetadataAnnotation = psiAnnotation3;
        object = KotlinClassMetadata.Companion.read(KotlinMetadataUtilsKt.toHeader(classKotlinMetadataAnnotation));
        if (object == null) {
            return null;
        }
        Object metadata = object;
        if ((object = metadata) instanceof KotlinClassMetadata.Class) {
            kmDeclarationContainer = ((KotlinClassMetadata.Class)metadata).toKmClass();
        } else if (object instanceof KotlinClassMetadata.FileFacade) {
            kmDeclarationContainer = ((KotlinClassMetadata.FileFacade)metadata).toKmPackage();
        } else if (object instanceof KotlinClassMetadata.SyntheticClass) {
            kmDeclarationContainer = null;
        } else if (object instanceof KotlinClassMetadata.MultiFileClassFacade) {
            kmDeclarationContainer = null;
        } else if (object instanceof KotlinClassMetadata.MultiFileClassPart) {
            kmDeclarationContainer = ((KotlinClassMetadata.MultiFileClassPart)metadata).toKmPackage();
        } else if (object instanceof KotlinClassMetadata.Unknown) {
            kmDeclarationContainer = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kmDeclarationContainer;
    }

    private static final KotlinClassHeader toHeader(PsiAnnotation $this$toHeader) {
        JvmAnnotationAttributeValue $this$associateTo$iv$iv;
        List list = $this$toHeader.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"attributes");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate22 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            JvmAnnotationAttribute it = (JvmAnnotationAttribute)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getAttributeName(), (Object)it.getAttributeValue());
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map attributes = destination$iv$iv;
        JvmAnnotationAttributeValue $i$f$associate22 = (JvmAnnotationAttributeValue)attributes.get("k");
        Integer kind = $i$f$associate22 == null ? null : Integer.valueOf(KotlinMetadataUtilsKt.toHeader$parseInt($i$f$associate22));
        JvmAnnotationAttributeValue capacity$iv22 = (JvmAnnotationAttributeValue)attributes.get("mv");
        int[] metadataVersion = capacity$iv22 == null ? null : KotlinMetadataUtilsKt.toHeader$parseIntArray(capacity$iv22);
        $this$associateTo$iv$iv = (JvmAnnotationAttributeValue)attributes.get("d1");
        String[] data1 = $this$associateTo$iv$iv == null ? null : KotlinMetadataUtilsKt.toHeader$parseStringArray($this$associateTo$iv$iv);
        destination$iv$iv = (JvmAnnotationAttributeValue)attributes.get("d2");
        String[] data2 = destination$iv$iv == null ? null : KotlinMetadataUtilsKt.toHeader$parseStringArray((JvmAnnotationAttributeValue)destination$iv$iv);
        JvmAnnotationAttributeValue $i$f$associateTo22 = (JvmAnnotationAttributeValue)attributes.get("xs");
        String extraString = $i$f$associateTo22 == null ? null : KotlinMetadataUtilsKt.toHeader$parseString($i$f$associateTo22);
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)attributes.get("pn");
        String packageName = jvmAnnotationAttributeValue == null ? null : KotlinMetadataUtilsKt.toHeader$parseString(jvmAnnotationAttributeValue);
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue2 = (JvmAnnotationAttributeValue)attributes.get("xi");
        Integer extraInt = jvmAnnotationAttributeValue2 == null ? null : Integer.valueOf(KotlinMetadataUtilsKt.toHeader$parseInt(jvmAnnotationAttributeValue2));
        return new KotlinClassHeader(kind, metadataVersion, data1, data2, extraString, packageName, extraInt);
    }

    private static final KmFunction findKmFunctionForPsiMethod(KmDeclarationContainer $this$findKmFunctionForPsiMethod, PsiMethod method) {
        Object v0;
        block1: {
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            String expectedName = StringsKt.substringBefore$default((String)string, (String)"-", null, (int)2, null);
            String expectedSignature = ClassUtil.getAsmMethodSignature((PsiMethod)method);
            Iterable iterable = $this$findKmFunctionForPsiMethod.getFunctions();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                JvmMethodSignature jvmMethodSignature;
                KmFunction it = (KmFunction)t;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)expectedName) && Intrinsics.areEqual((Object)((jvmMethodSignature = JvmExtensionsKt.getSignature(it)) == null ? null : jvmMethodSignature.getDesc()), (Object)expectedSignature))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final String toHeader$parseString(JvmAnnotationAttributeValue $this$toHeader_u24parseString) {
        Object object = ((JvmAnnotationConstantValue)$this$toHeader_u24parseString).getConstantValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object;
    }

    private static final int toHeader$parseInt(JvmAnnotationAttributeValue $this$toHeader_u24parseInt) {
        Object object = ((JvmAnnotationConstantValue)$this$toHeader_u24parseInt).getConstantValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] toHeader$parseStringArray(JvmAnnotationAttributeValue $this$toHeader_u24parseStringArray) {
        void $this$mapTo$iv$iv;
        List list = ((JvmAnnotationArrayValue)$this$toHeader_u24parseStringArray).getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this as JvmAnnotationArrayValue).values");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String string = KotlinMetadataUtilsKt.toHeader$parseString((JvmAnnotationAttributeValue)it);
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final int[] toHeader$parseIntArray(JvmAnnotationAttributeValue $this$toHeader_u24parseIntArray) {
        void $this$mapTo$iv$iv;
        List list = ((JvmAnnotationArrayValue)$this$toHeader_u24parseIntArray).getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this as JvmAnnotationArrayValue).values");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmAnnotationAttributeValue jvmAnnotationAttributeValue = (JvmAnnotationAttributeValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Integer n = KotlinMetadataUtilsKt.toHeader$parseInt((JvmAnnotationAttributeValue)it);
            collection.add(n);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
        if (integerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return ArraysKt.toIntArray((Integer[])integerArray);
    }
}

