/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.animation.core.VectorizedFloatAnimationSpec;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/core/FloatTweenSpec;", "Landroidx/compose/animation/core/FloatAnimationSpec;", "duration", "", "delay", "easing", "Landroidx/compose/animation/core/Easing;", "(IILandroidx/compose/animation/core/Easing;)V", "getDelay", "()I", "getDuration", "clampPlayTime", "", "playTime", "getDurationNanos", "initialValue", "", "targetValue", "initialVelocity", "getValueFromNanos", "playTimeNanos", "getVelocityFromNanos", "animation-core_release"})
@StabilityInferred(parameters=0)
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    @NotNull
    private final Easing easing;
    public static final int $stable;

    public FloatTweenSpec(int duration, int delay, @NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = duration;
        this.delay = delay;
        this.easing = easing;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getDelay() {
        return this.delay;
    }

    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = this.clampPlayTime(playTimeMillis);
        float rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTime / (float)this.duration;
        float fraction = this.easing.transform(RangesKt.coerceIn((float)rawFraction, (float)0.0f, (float)1.0f));
        return VectorConvertersKt.lerp(initialValue, targetValue, fraction);
    }

    private final long clampPlayTime(long playTime) {
        return RangesKt.coerceIn((long)(playTime - (long)this.delay), (long)0L, (long)this.duration);
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        return (long)(this.delay + this.duration) * 1000000L;
    }

    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = this.clampPlayTime(playTimeMillis);
        if (clampedPlayTime < 0L) {
            return 0.0f;
        }
        if (clampedPlayTime == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos((clampedPlayTime - 1L) * 1000000L, initialValue, targetValue, initialVelocity);
        float endNum = this.getValueFromNanos(clampedPlayTime * 1000000L, initialValue, targetValue, initialVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    @Override
    public float getEndVelocity(float initialValue, float targetValue, float initialVelocity) {
        return FloatAnimationSpec.DefaultImpls.getEndVelocity(this, initialValue, targetValue, initialVelocity);
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedFloatAnimationSpec<V> vectorize(@NotNull TwoWayConverter<Float, V> converter) {
        return FloatAnimationSpec.DefaultImpls.vectorize(this, converter);
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

