/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.ComplexDouble;
import androidx.compose.animation.core.ComplexDoubleKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b\u001a4\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a<\u0010\u0012\u001a\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0014\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0015\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a9\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019H\u0082\b\u001a\r\u0010\u001b\u001a\u00020\u001c*\u00020\u0003H\u0082\b\u00a8\u0006\u001d"}, d2={"estimateAnimationDurationMillis", "", "stiffness", "", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "springConstant", "dampingCoefficient", "mass", "", "estimateCriticallyDamped", "roots", "Lkotlin/Pair;", "Landroidx/compose/animation/core/ComplexDouble;", "p0", "v0", "estimateDurationInternal", "initialPosition", "estimateOverDamped", "estimateUnderDamped", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "isNotFinite", "", "animation-core_release"})
public final class SpringEstimationKt {
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        return SpringEstimationKt.estimateAnimationDurationMillis((double)stiffness, (double)dampingRatio, (double)initialVelocity, (double)initialDisplacement, (double)delta);
    }

    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        double dampingCoefficient = 2.0 * dampingRatio * Math.sqrt(stiffness);
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(1.0, dampingCoefficient, stiffness);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    public static final long estimateAnimationDurationMillis(double springConstant, double dampingCoefficient, double mass, double initialVelocity, double initialDisplacement, double delta) {
        double criticalDamping = 2.0 * Math.sqrt(springConstant * mass);
        double dampingRatio = dampingCoefficient / criticalDamping;
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(mass, dampingCoefficient, springConstant);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    private static final double estimateUnderDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        double c1 = p0;
        double c2 = (v0 - r * c1) / ((ComplexDouble)roots.getFirst()).getImaginary();
        double c = Math.sqrt(c1 * c1 + c2 * c2);
        return Math.log(delta / c) / r;
    }

    private static final double estimateCriticallyDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double d;
        double d2;
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        double c1 = p0;
        double c2 = v0 - r * c1;
        double t1 = Math.log(Math.abs(delta / c1)) / r;
        double t2 = SpringEstimationKt.estimateCriticallyDamped$t2Iterate(Math.log(Math.abs(delta / c2)), r) / r;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double d3 = $this$isNotFinite$iv;
        boolean bl = !(!Double.isInfinite(d3) && !Double.isNaN(d3));
        if (bl) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            d3 = $this$isNotFinite$iv;
            d2 = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateCriticallyDamped$xInflection(c1, r, tInflection, c2) < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        Function1 fn2 = (Function1)new Function1<Double, Double>(c1, c2, r, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $signedDelta;
            {
                this.$c1 = $c1;
                this.$c2 = $c2;
                this.$r = $r;
                this.$signedDelta = $signedDelta;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                return (this.$c1 + this.$c2 * t) * Math.exp(this.$r * t) + this.$signedDelta;
            }
        };
        Function1 fnPrime2 = (Function1)new Function1<Double, Double>(c2, r, c1){
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $c1;
            {
                this.$c2 = $c2;
                this.$r = $r;
                this.$c1 = $c1;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                return (this.$c2 * (this.$r * t + 1.0) + this.$c1 * this.$r) * Math.exp(this.$r * t);
            }
        };
        double tDelta = Double.MAX_VALUE;
        int iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            int n = iterations;
            iterations = n + 1;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn2.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime2.invoke((Object)tCurr)).doubleValue();
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final double estimateOverDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double d;
        double d2;
        double r1 = ((ComplexDouble)roots.getFirst()).getReal();
        double r2 = ((ComplexDouble)roots.getSecond()).getReal();
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double t1 = Math.log(Math.abs(delta / c1)) / r1;
        double t2 = Math.log(Math.abs(delta / c2)) / r2;
        double $this$isNotFinite$iv = t1;
        boolean $i$f$isNotFinite = false;
        double d3 = $this$isNotFinite$iv;
        boolean bl = !(!Double.isInfinite(d3) && !Double.isNaN(d3));
        if (bl) {
            d2 = t2;
        } else {
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            d3 = $this$isNotFinite$iv;
            d2 = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? t1 : Math.max(t1, t2);
        }
        double tCurr = d2;
        double tInflection = Math.log(c1 * r1 / (-c2 * r2)) / (r2 - r1);
        if (Double.isNaN(tInflection) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -SpringEstimationKt.estimateOverDamped$xInflection-0(c1, r1, tInflection, c2, r2) < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = Math.log(-(c2 * r2 * r2) / (c1 * r1 * r1)) / (r1 - r2);
            d = delta;
        }
        double signedDelta = d;
        Function1 fn2 = (Function1)new Function1<Double, Double>(c1, r1, c2, r2, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;
            final /* synthetic */ double $signedDelta;
            {
                this.$c1 = $c1;
                this.$r1 = $r1;
                this.$c2 = $c2;
                this.$r2 = $r2;
                this.$signedDelta = $signedDelta;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                return this.$c1 * Math.exp(this.$r1 * t) + this.$c2 * Math.exp(this.$r2 * t) + this.$signedDelta;
            }
        };
        Function1 fnPrime2 = (Function1)new Function1<Double, Double>(c1, r1, c2, r2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;
            {
                this.$c1 = $c1;
                this.$r1 = $r1;
                this.$c2 = $c2;
                this.$r2 = $r2;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                return this.$c1 * this.$r1 * Math.exp(this.$r1 * t) + this.$c2 * this.$r2 * Math.exp(this.$r2 * t);
            }
        };
        if (Math.abs(((Number)fn2.invoke((Object)tCurr)).doubleValue()) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = Double.MAX_VALUE;
        int iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            int n = iterations;
            iterations = n + 1;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn2.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime2.invoke((Object)tCurr)).doubleValue();
            tDelta = Math.abs(tLast - tCurr);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(Pair<ComplexDouble, ComplexDouble> roots, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        double p0 = Math.abs(initialPosition);
        return (long)((dampingRatio > 1.0 ? SpringEstimationKt.estimateOverDamped(roots, p0, v0, delta) : (dampingRatio < 1.0 ? SpringEstimationKt.estimateUnderDamped(roots, p0, v0, delta) : SpringEstimationKt.estimateCriticallyDamped(roots, p0, v0, delta))) * 1000.0);
    }

    private static final double iterateNewtonsMethod(double x, Function1<? super Double, Double> fn2, Function1<? super Double, Double> fnPrime2) {
        boolean $i$f$iterateNewtonsMethod = false;
        return x - ((Number)fn2.invoke((Object)x)).doubleValue() / ((Number)fnPrime2.invoke((Object)x)).doubleValue();
    }

    private static final boolean isNotFinite(double $this$isNotFinite) {
        boolean $i$f$isNotFinite = false;
        double d = $this$isNotFinite;
        return !(!Double.isInfinite(d) && !Double.isNaN(d));
    }

    private static final double estimateCriticallyDamped$t2Iterate(double guess, double r) {
        double t = guess;
        int n = 0;
        while (n < 6) {
            int i = n++;
            t = guess - Math.log(Math.abs(t / r));
        }
        return t;
    }

    private static final double estimateCriticallyDamped$xInflection(double c1, double r, double tInflection, double c2) {
        return c1 * Math.exp(r * tInflection) + c2 * tInflection * Math.exp(r * tInflection);
    }

    private static final double estimateOverDamped$xInflection-0(double c1, double r1, double tInflection, double c2, double r2) {
        return c1 * Math.exp(r1 * tInflection) + c2 * Math.exp(r2 * tInflection);
    }
}

