/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core.lint;

import androidx.compose.animation.core.lint.UnrememberedAnimatableDetectorKt;
import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/animation/core/lint/UnrememberedAnimatableDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "animation-core-lint"})
public final class UnrememberedAnimatableDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue UnrememberedAnimatable = Issue.Companion.create("UnrememberedAnimatable", "Creating an Animatable during composition without using `remember`", "Animatable instances created during composition need to be `remember`ed, otherwise they will be recreated during recomposition, and lose their state. Either hoist the Animatable to an object that is not created during composition, or wrap the Animatable in a call to `remember`.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(UnrememberedAnimatableDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    if (!PsiUtilsKt.isInPackageName(method, Names.AnimationCore.INSTANCE.getPackageName())) {
                        return;
                    }
                    PsiClass psiClass = method.getContainingClass();
                    if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getName() : null), (Object)UnrememberedAnimatableDetectorKt.access$getAnimatable$p().getShortName())) {
                        return;
                    }
                } else {
                    if (!Intrinsics.areEqual((Object)node.getMethodName(), (Object)UnrememberedAnimatableDetectorKt.access$getAnimatable$p().getShortName())) {
                        return;
                    }
                    PsiType psiType = method.getReturnType();
                    PsiClassReferenceType psiClassReferenceType = psiType instanceof PsiClassReferenceType ? (PsiClassReferenceType)psiType : null;
                    if (psiClassReferenceType == null) {
                        return;
                    }
                    PsiClassReferenceType returnType = psiClassReferenceType;
                    if (!returnType.rawType().equalsToText(UnrememberedAnimatableDetectorKt.access$getAnimatable$p().getJavaFqn())) {
                        return;
                    }
                }
                if (ComposableUtilsKt.isNotRemembered(node)) {
                    JavaContext.report$default((JavaContext)this.$context, (Issue)UnrememberedAnimatableDetector.Companion.getUnrememberedAnimatable(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)"Creating an Animatable during composition without using `remember`", null, (int)16, null);
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/animation/core/lint/UnrememberedAnimatableDetector$Companion;", "", "()V", "UnrememberedAnimatable", "Lcom/android/tools/lint/detector/api/Issue;", "getUnrememberedAnimatable", "()Lcom/android/tools/lint/detector/api/Issue;", "animation-core-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getUnrememberedAnimatable() {
            return UnrememberedAnimatable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

