/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.graphics.vector.AnimatorKt;
import androidx.compose.animation.graphics.vector.Keyframe;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder1D;
import androidx.compose.ui.graphics.vector.PathNode;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00070\u0002\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rR&\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00070\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Landroidx/compose/animation/graphics/vector/PropertyValuesHolderPath;", "Landroidx/compose/animation/graphics/vector/PropertyValuesHolder1D;", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "propertyName", "", "animatorKeyframes", "Landroidx/compose/animation/graphics/vector/Keyframe;", "(Ljava/lang/String;Ljava/util/List;)V", "getAnimatorKeyframes", "()Ljava/util/List;", "interpolate", "fraction", "", "animation-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\nandroidx/compose/animation/graphics/vector/PropertyValuesHolderPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,649:1\n350#2,7:650\n*S KotlinDebug\n*F\n+ 1 Animator.kt\nandroidx/compose/animation/graphics/vector/PropertyValuesHolderPath\n*L\n416#1:650,7\n*E\n"})
public final class PropertyValuesHolderPath
extends PropertyValuesHolder1D<List<? extends PathNode>> {
    @NotNull
    private final List<Keyframe<List<PathNode>>> animatorKeyframes;

    public PropertyValuesHolderPath(@NotNull String propertyName, @NotNull List<Keyframe<List<PathNode>>> animatorKeyframes) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter(animatorKeyframes, (String)"animatorKeyframes");
        super(propertyName, null);
        this.animatorKeyframes = animatorKeyframes;
    }

    @Override
    @NotNull
    public List<Keyframe<List<PathNode>>> getAnimatorKeyframes() {
        return this.animatorKeyframes;
    }

    @NotNull
    public final List<PathNode> interpolate(float fraction) {
        int n;
        block2: {
            List<Keyframe<List<PathNode>>> $this$indexOfFirst$iv = this.getAnimatorKeyframes();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Keyframe<List<PathNode>>> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Keyframe<List<PathNode>> item$iv;
                Keyframe<List<PathNode>> it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getFraction() >= fraction) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = RangesKt.coerceAtLeast((int)(n - 1), (int)0);
        Easing easing = this.getAnimatorKeyframes().get(index + 1).getInterpolator();
        float innerFraction = easing.transform(RangesKt.coerceIn((float)((fraction - this.getAnimatorKeyframes().get(index).getFraction()) / (this.getAnimatorKeyframes().get(index + 1).getFraction() - this.getAnimatorKeyframes().get(index).getFraction())), (float)0.0f, (float)1.0f));
        return AnimatorKt.access$lerp(this.getAnimatorKeyframes().get(index).getValue(), this.getAnimatorKeyframes().get(index + 1).getValue(), innerFraction);
    }
}

