/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposableCallCheckerKt;
import androidx.compose.compiler.plugins.kotlin.ComposeFqNamesKt;
import androidx.compose.compiler.plugins.kotlin.analysis.ComposeWritableSlices;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptorExtension;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeTypeResolutionInterceptorExtension;", "Lorg/jetbrains/kotlin/extensions/internal/TypeResolutionInterceptorExtension;", "()V", "interceptFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "descriptor", "interceptType", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "resultType", "compose-compiler-hosted"})
public class ComposeTypeResolutionInterceptorExtension
implements TypeResolutionInterceptorExtension {
    @NotNull
    public AnonymousFunctionDescriptor interceptFunctionLiteralDescriptor(@NotNull KtLambdaExpression expression, @NotNull ExpressionTypingContext context, @NotNull AnonymousFunctionDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.expectedType");
        if (ComposeFqNamesKt.hasComposableAnnotation(kotlinType)) {
            context.trace.record(ComposeWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_DESCRIPTOR(), (Object)descriptor, (Object)true);
        }
        return descriptor;
    }

    @NotNull
    public KotlinType interceptType(@NotNull KtElement element, @NotNull ExpressionTypingContext context, @NotNull KotlinType resultType) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)resultType, (String)"resultType");
                if (resultType == TypeUtils.NO_EXPECTED_TYPE) {
                    return resultType;
                }
                if (!(element instanceof KtLambdaExpression)) {
                    return resultType;
                }
                List list = KtPsiUtilKt.getAnnotationEntries((KtExpression)((KtExpression)element));
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
                BindingContext bindingContext = bindingTrace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
                if (ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext)) break block5;
                KotlinType kotlinType = context.expectedType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.expectedType");
                if (!ComposeFqNamesKt.hasComposableAnnotation(kotlinType)) break block6;
            }
            context.trace.record(ComposeWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_LITERAL(), (Object)element, (Object)true);
            return ComposeFqNamesKt.makeComposable(resultType, DescriptorUtilsKt.getModule((DeclarationDescriptor)context.scope.getOwnerDescriptor()));
        }
        return resultType;
    }
}

