/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose;

import androidx.compose.Anchor;
import androidx.compose.Group;
import androidx.compose.IntStack;
import androidx.compose.KeyInfo;
import androidx.compose.NodeGroup;
import androidx.compose.SlotTable;
import androidx.compose.SlotTableKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\b\u00107\u001a\u00020\fH\u0002J\u0006\u00108\u001a\u000209J\n\u0010:\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010;\u001a\u000209J\u0006\u0010<\u001a\u000209J\u0006\u0010=\u001a\u000209J\u0006\u0010>\u001a\u000209J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@J\u0010\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020DJ\u0010\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010E\u001a\u00020\u0005J\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bGJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010E\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u0005J\b\u0010H\u001a\u0004\u0018\u00010\u0001J\u000e\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020\u0005J\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010L\u001a\u00020\u0005J\u0006\u0010M\u001a\u000209J\u000e\u0010N\u001a\u0002092\u0006\u0010O\u001a\u00020\u0001J\u001c\u0010N\u001a\u0002092\u0006\u0010O\u001a\u00020\u00012\n\u0010P\u001a\u00060\u0005j\u0002`QH\u0002J\u000e\u0010R\u001a\u0002092\u0006\u0010O\u001a\u00020\u0001J\b\u0010S\u001a\u00020TH\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0011\u0010\u0016\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001fR\u001e\u0010#\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\bR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\bR\u0011\u0010+\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u0011\u0010-\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\bR\u0018\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000100X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u0014\u00102\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006U"}, d2={"Landroidx/compose/SlotReader;", "", "table", "Landroidx/compose/SlotTable;", "<set-?>", "", "current", "getCurrent", "()I", "currentEnd", "getCurrentEnd", "currentGroup", "Landroidx/compose/Group;", "emptyCount", "group", "getGroup$compose_runtime_release", "()Landroidx/compose/Group;", "groupData", "getGroupData", "()Ljava/lang/Object;", "groupEnd", "getGroupEnd", "groupKey", "getGroupKey", "groupNode", "getGroupNode", "groupSize", "getGroupSize", "inEmpty", "", "getInEmpty", "()Z", "isGroup", "isGroupEnd", "isNode", "nodeIndex", "getNodeIndex", "nodeIndexStack", "Landroidx/compose/IntStack;", "parentGroup", "getParentGroup$compose_runtime_release", "parentLocation", "getParentLocation", "parentNodes", "getParentNodes", "parentSlots", "getParentSlots", "slots", "", "[Ljava/lang/Object;", "startStack", "getStartStack$compose_runtime_release", "()Landroidx/compose/IntStack;", "getTable", "()Landroidx/compose/SlotTable;", "assumeGroup", "beginEmpty", "", "calculateCurrentGroup", "close", "endEmpty", "endGroup", "endNode", "extractKeys", "", "Landroidx/compose/KeyInfo;", "get", "anchor", "Landroidx/compose/Anchor;", "index", "location", "group$compose_runtime_release", "next", "reposition", "value", "skipGroup", "skipNode", "skipToGroupEnd", "startGroup", "key", "kind", "Landroidx/compose/GroupKind;", "startNode", "toString", "", "compose-runtime_release"})
public final class SlotReader {
    private final SlotTable table;
    private int current;
    private int currentEnd;
    private int nodeIndex;
    private final IntStack startStack;
    private final Object[] slots;
    private Group currentGroup;
    private int emptyCount;
    private final IntStack nodeIndexStack;

    public SlotReader(@NotNull SlotTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.currentEnd = this.getTable().getSize();
        this.startStack = new IntStack();
        this.slots = this.getTable().getSlots$compose_runtime_release();
        this.nodeIndexStack = new IntStack();
        boolean bl = this.getTable().getGapStart$compose_runtime_release() == this.getCurrentEnd();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Gap is not at the end of the slot table";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SlotTable getTable() {
        return this.table;
    }

    public final int getCurrent() {
        return this.current;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getNodeIndex() {
        return this.nodeIndex;
    }

    @NotNull
    public final IntStack getStartStack$compose_runtime_release() {
        return this.startStack;
    }

    public final boolean isGroup() {
        return this.getCurrent() < this.getCurrentEnd() && this.calculateCurrentGroup() != null;
    }

    @NotNull
    public final Group getGroup$compose_runtime_release() {
        return this.assumeGroup();
    }

    @NotNull
    public final Group group$compose_runtime_release(int location) {
        return SlotTableKt.access$getAsGroup(this.slots[location]);
    }

    @NotNull
    public final Group getParentGroup$compose_runtime_release() {
        return SlotTableKt.access$getAsGroup(this.slots[this.getParentLocation()]);
    }

    public final boolean isGroup(int index) {
        return this.slots[index] instanceof Group;
    }

    public final boolean isNode() {
        Group group2 = this.calculateCurrentGroup();
        Boolean bl = group2 == null ? (Boolean)null : Boolean.valueOf(group2.isNode());
        return bl == null ? false : bl;
    }

    public final boolean isNode(int location) {
        return SlotTableKt.access$getAsGroup(this.slots[location]).isNode();
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.getCurrent() == this.getCurrentEnd();
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return this.assumeGroup().getSlots();
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$getAsGroup(this.slots[index]).getSlots();
    }

    public final int getGroupEnd() {
        return this.getCurrentEnd();
    }

    public final int groupEnd(int index) {
        return index + SlotTableKt.access$getAsGroup(this.slots[index]).getSlots() + 1;
    }

    @Nullable
    public final Object getGroupData() {
        Group group2;
        return this.getCurrent() < this.getCurrentEnd() ? ((group2 = this.calculateCurrentGroup()) == null ? null : group2.getData()) : null;
    }

    @NotNull
    public final Object getGroupKey() {
        Object object;
        if (this.getCurrent() < this.getCurrentEnd()) {
            Object object2;
            Group group2 = this.calculateCurrentGroup();
            Object object3 = object2 = group2 == null ? null : group2.getKey();
            object = object2 == null ? SlotTableKt.getEMPTY() : object2;
        } else {
            object = SlotTableKt.getEMPTY();
        }
        return object;
    }

    @Nullable
    public final Object getGroupNode() {
        Group group2 = this.assumeGroup();
        NodeGroup nodeGroup = group2 instanceof NodeGroup ? (NodeGroup)group2 : null;
        return nodeGroup == null ? null : nodeGroup.getNode();
    }

    @NotNull
    public final Object groupKey(int index) {
        return SlotTableKt.access$getAsGroup(this.slots[index]).getKey();
    }

    public final int getParentLocation() {
        return this.getStartStack$compose_runtime_release().peekOr(0);
    }

    public final int getParentNodes() {
        return this.getStartStack$compose_runtime_release().isEmpty() ? 0 : SlotTableKt.access$getAsGroup(this.slots[this.getStartStack$compose_runtime_release().peek()]).getNodes();
    }

    public final int getParentSlots() {
        return this.getStartStack$compose_runtime_release().isEmpty() ? 0 : SlotTableKt.access$getAsGroup(this.slots[this.getStartStack$compose_runtime_release().peek()]).getSlots();
    }

    @Nullable
    public final Object get(@NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return anchor.getLoc$compose_runtime_release() >= 0 ? this.slots[anchor.getLoc$compose_runtime_release()] : SlotTableKt.getEMPTY();
    }

    @Nullable
    public final Object get(int index) {
        return this.emptyCount > 0 ? SlotTableKt.getEMPTY() : this.slots[index];
    }

    @Nullable
    public final Object next() {
        Object object;
        if (this.emptyCount > 0) {
            return SlotTableKt.getEMPTY();
        }
        this.currentGroup = null;
        if (this.getCurrent() < this.getCurrentEnd()) {
            SlotReader slotReader = this;
            int n = slotReader.getCurrent();
            slotReader.current = n + 1;
            object = this.slots[n];
        } else {
            object = SlotTableKt.getEMPTY();
        }
        return object;
    }

    public final void beginEmpty() {
        SlotReader slotReader = this;
        int n = slotReader.emptyCount;
        slotReader.emptyCount = n + 1;
    }

    public final void endEmpty() {
        boolean bl = this.emptyCount > 0;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Unbalanced begin/end empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SlotReader slotReader = this;
        n = slotReader.emptyCount;
        slotReader.emptyCount = n + -1;
    }

    public final void close() {
        this.getTable().close$compose_runtime_release(this);
    }

    public final void startGroup(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.startGroup(key, 0);
    }

    public final void startNode(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.startGroup(key, 1);
    }

    public final int skipGroup() {
        boolean bl = this.emptyCount == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot skip while in an empty region";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Group group2 = this.assumeGroup();
        SlotReader slotReader = this;
        slotReader.current = slotReader.getCurrent() + (group2.getSlots() + 1);
        this.currentGroup = null;
        int count = group2.isNode() ? 1 : group2.getNodes();
        SlotReader slotReader2 = this;
        slotReader2.nodeIndex = slotReader2.getNodeIndex() + count;
        return count;
    }

    public final int skipNode() {
        return this.skipGroup();
    }

    public final void skipToGroupEnd() {
        boolean bl = this.emptyCount == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot skip the enclosing group while in an empty region";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getStartStack$compose_runtime_release().isNotEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "No enclosing group to skip";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.nodeIndex = SlotTableKt.access$getAsGroup(this.slots[this.getStartStack$compose_runtime_release().peek()]).getNodes() + this.nodeIndexStack.peek();
        this.currentGroup = null;
        this.current = this.getCurrentEnd();
    }

    public final void reposition(int value) {
        this.current = value;
        this.currentGroup = null;
    }

    public final void endGroup() {
        if (this.emptyCount == 0) {
            boolean bl = this.getCurrent() == this.getCurrentEnd();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int startLocation = this.getStartStack$compose_runtime_release().pop();
            if (this.getStartStack$compose_runtime_release().isEmpty()) {
                return;
            }
            int parentLocation = this.getStartStack$compose_runtime_release().peekOr(0);
            Group group2 = SlotTableKt.access$getAsGroup(this.slots[startLocation]);
            Group parentGroup = SlotTableKt.access$getAsGroup(this.slots[parentLocation]);
            this.nodeIndex = this.nodeIndexStack.pop() + (group2.isNode() ? 1 : this.getNodeIndex());
            this.currentEnd = parentGroup.getSlots() + parentLocation + 1;
            this.currentGroup = null;
        }
    }

    public final void endNode() {
        this.endGroup();
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        boolean bl = false;
        List result = new ArrayList();
        if (this.emptyCount > 0) {
            return result;
        }
        int oldCurrent = this.getCurrent();
        int oldNodeIndex = this.getNodeIndex();
        int index = 0;
        while (this.getCurrent() < this.getCurrentEnd()) {
            int location = this.getCurrent();
            Group group2 = SlotTableKt.access$getAsGroup(this.slots[location]);
            int n = index;
            index = n + 1;
            result.add(new KeyInfo(group2.getKey(), location, this.skipGroup(), n, group2));
        }
        this.current = oldCurrent;
        this.nodeIndex = oldNodeIndex;
        return result;
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.getCurrent() + ", emptyCount=" + this.emptyCount + ")";
    }

    private final void startGroup(Object key, int kind) {
        if (this.emptyCount <= 0) {
            this.getStartStack$compose_runtime_release().push(this.getCurrent());
            this.nodeIndexStack.push(this.getNodeIndex());
            this.nodeIndex = 0;
            Group group2 = this.assumeGroup();
            this.currentEnd = this.getCurrent() + group2.getSlots() + 1;
            boolean bl = group2.getKind() == kind || Intrinsics.areEqual((Object)key, (Object)SlotTableKt.getEMPTY());
            int n = 0;
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                String string = "Group kind changed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = Intrinsics.areEqual((Object)key, (Object)SlotTableKt.getEMPTY()) || Intrinsics.areEqual((Object)key, (Object)group2.getKey());
            n = 0;
            bl2 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Group key changed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            SlotReader slotReader = this;
            n = slotReader.getCurrent();
            slotReader.current = n + 1;
            this.currentGroup = null;
        }
    }

    private final Group calculateCurrentGroup() {
        Group group2;
        Group group3;
        Object object;
        Group group4 = this.currentGroup;
        Group group5 = group4 == null ? ((object = this.slots[this.getCurrent()]) instanceof Group ? (Group)object : null) : (group3 = group4);
        if (group3 == null) {
            group2 = null;
        } else {
            group4 = group3;
            boolean bl = false;
            boolean bl2 = false;
            Group it = group4;
            boolean bl3 = false;
            this.currentGroup = it;
            group2 = group4;
        }
        return group2;
    }

    private final Group assumeGroup() {
        Group group2 = this.calculateCurrentGroup();
        if (group2 == null) {
            String string = "Expected a group start";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return group2;
    }
}

