/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.LazyListPlaceableWrapper;
import androidx.compose.foundation.lazy.LazyListPositionedItem;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B~\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0001\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001aR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010$\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006+"}, d2={"Landroidx/compose/foundation/lazy/LazyListMeasuredItem;", "", "index", "", "placeables", "", "Landroidx/compose/ui/layout/Placeable;", "isVertical", "", "horizontalAlignment", "Landroidx/compose/ui/Alignment$Horizontal;", "verticalAlignment", "Landroidx/compose/ui/Alignment$Vertical;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "reverseLayout", "beforeContentPadding", "afterContentPadding", "spacing", "visualOffset", "Landroidx/compose/ui/unit/IntOffset;", "key", "contentType", "(ILjava/util/List;ZLandroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/unit/LayoutDirection;ZIIIJLjava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "crossAxisSize", "getCrossAxisSize", "()I", "getIndex", "getKey", "()Ljava/lang/Object;", "placeablesCount", "getPlaceablesCount", "size", "getSize", "sizeWithSpacings", "getSizeWithSpacings", "J", "getParentData", "position", "Landroidx/compose/foundation/lazy/LazyListPositionedItem;", "offset", "layoutWidth", "layoutHeight", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nLazyListMeasuredItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyListMeasuredItem.kt\nandroidx/compose/foundation/lazy/LazyListMeasuredItem\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,189:1\n33#2,6:190\n33#2,6:196\n*S KotlinDebug\n*F\n+ 1 LazyListMeasuredItem.kt\nandroidx/compose/foundation/lazy/LazyListMeasuredItem\n*L\n72#1:190,6\n97#1:196,6\n*E\n"})
public final class LazyListMeasuredItem {
    private final int index;
    @NotNull
    private final List<Placeable> placeables;
    private final boolean isVertical;
    @Nullable
    private final Alignment.Horizontal horizontalAlignment;
    @Nullable
    private final Alignment.Vertical verticalAlignment;
    @NotNull
    private final LayoutDirection layoutDirection;
    private final boolean reverseLayout;
    private final int beforeContentPadding;
    private final int afterContentPadding;
    private final int spacing;
    private final long visualOffset;
    @NotNull
    private final Object key;
    @Nullable
    private final Object contentType;
    private final int size;
    private final int sizeWithSpacings;
    private final int crossAxisSize;

    private LazyListMeasuredItem(int index2, List<? extends Placeable> placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, int spacing, long visualOffset, Object key, Object contentType) {
        Intrinsics.checkNotNullParameter(placeables, (String)"placeables");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.index = index2;
        this.placeables = placeables;
        this.isVertical = isVertical;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.layoutDirection = layoutDirection;
        this.reverseLayout = reverseLayout;
        this.beforeContentPadding = beforeContentPadding;
        this.afterContentPadding = afterContentPadding;
        this.spacing = spacing;
        this.visualOffset = visualOffset;
        this.key = key;
        this.contentType = contentType;
        int mainAxisSize = 0;
        int maxCrossAxis = 0;
        List<Placeable> $this$fastForEach$iv = this.placeables;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Placeable item$iv;
            Placeable it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            mainAxisSize += this.isVertical ? it.getHeight() : it.getWidth();
            maxCrossAxis = Math.max(maxCrossAxis, !this.isVertical ? it.getHeight() : it.getWidth());
        }
        this.size = mainAxisSize;
        this.sizeWithSpacings = RangesKt.coerceAtLeast((int)(this.size + this.spacing), (int)0);
        this.crossAxisSize = maxCrossAxis;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final Object getKey() {
        return this.key;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSizeWithSpacings() {
        return this.sizeWithSpacings;
    }

    public final int getCrossAxisSize() {
        return this.crossAxisSize;
    }

    public final int getPlaceablesCount() {
        return this.placeables.size();
    }

    @Nullable
    public final Object getParentData(int index2) {
        return this.placeables.get(index2).getParentData();
    }

    @NotNull
    public final LazyListPositionedItem position(int offset, int layoutWidth, int layoutHeight) {
        List wrappers = new ArrayList();
        int mainAxisLayoutSize = this.isVertical ? layoutHeight : layoutWidth;
        int mainAxisOffset = 0;
        mainAxisOffset = offset;
        List<Placeable> $this$fastForEach$iv = this.placeables;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            long l;
            Placeable item$iv;
            Placeable it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            if (this.isVertical) {
                Alignment.Horizontal horizontal = this.horizontalAlignment;
                if (horizontal == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int x = horizontal.align(it.getWidth(), layoutWidth, this.layoutDirection);
                l = IntOffsetKt.IntOffset((int)x, (int)mainAxisOffset);
            } else {
                Alignment.Vertical vertical = this.verticalAlignment;
                if (vertical == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int y = vertical.align(it.getHeight(), layoutHeight);
                l = IntOffsetKt.IntOffset((int)mainAxisOffset, (int)y);
            }
            long placeableOffset = l;
            mainAxisOffset += this.isVertical ? it.getHeight() : it.getWidth();
            wrappers.add(new LazyListPlaceableWrapper(placeableOffset, it, null));
        }
        return new LazyListPositionedItem(offset, this.index, this.key, this.size, -this.beforeContentPadding, mainAxisLayoutSize + this.afterContentPadding, this.isVertical, wrappers, this.visualOffset, this.reverseLayout, mainAxisLayoutSize, this.contentType, null);
    }

    @ExperimentalFoundationApi
    public /* synthetic */ LazyListMeasuredItem(int index2, List placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, int spacing, long visualOffset, Object key, Object contentType, DefaultConstructorMarker $constructor_marker) {
        this(index2, placeables, isVertical, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout, beforeContentPadding, afterContentPadding, spacing, visualOffset, key, contentType);
    }
}

