/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.lazy.grid.GridItemSpan;
import androidx.compose.foundation.lazy.grid.LazyGridMeasuredItem;
import androidx.compose.foundation.lazy.grid.LazyGridPositionedItem;
import androidx.compose.foundation.lazy.grid.LazyGridSlots;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BD\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0019\u001a\u00020\rJ$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\n2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredLine;", "", "index", "", "items", "", "Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredItem;", "slots", "Landroidx/compose/foundation/lazy/grid/LazyGridSlots;", "spans", "", "Landroidx/compose/foundation/lazy/grid/GridItemSpan;", "isVertical", "", "mainAxisSpacing", "(I[Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredItem;Landroidx/compose/foundation/lazy/grid/LazyGridSlots;Ljava/util/List;ZI)V", "getIndex", "()I", "getItems", "()[Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredItem;", "[Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredItem;", "mainAxisSize", "getMainAxisSize", "mainAxisSizeWithSpacings", "getMainAxisSizeWithSpacings", "isEmpty", "position", "Landroidx/compose/foundation/lazy/grid/LazyGridPositionedItem;", "offset", "layoutWidth", "layoutHeight", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nLazyGridMeasuredLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyGridMeasuredLine.kt\nandroidx/compose/foundation/lazy/grid/LazyGridMeasuredLine\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,88:1\n13579#2,2:89\n11425#2:91\n11536#2,4:92\n*S KotlinDebug\n*F\n+ 1 LazyGridMeasuredLine.kt\nandroidx/compose/foundation/lazy/grid/LazyGridMeasuredLine\n*L\n49#1:89,2\n71#1:91\n71#1:92,4\n*E\n"})
public final class LazyGridMeasuredLine {
    private final int index;
    @NotNull
    private final LazyGridMeasuredItem[] items;
    @NotNull
    private final LazyGridSlots slots;
    @NotNull
    private final List<GridItemSpan> spans;
    private final boolean isVertical;
    private final int mainAxisSpacing;
    private final int mainAxisSize;
    private final int mainAxisSizeWithSpacings;

    public LazyGridMeasuredLine(int index2, @NotNull LazyGridMeasuredItem[] items2, @NotNull LazyGridSlots slots, @NotNull List<GridItemSpan> spans, boolean isVertical, int mainAxisSpacing) {
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        this.index = index2;
        this.items = items2;
        this.slots = slots;
        this.spans = spans;
        this.isVertical = isVertical;
        this.mainAxisSpacing = mainAxisSpacing;
        int maxMainAxis = 0;
        LazyGridMeasuredItem[] $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            LazyGridMeasuredItem element$iv;
            LazyGridMeasuredItem item2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            maxMainAxis = Math.max(maxMainAxis, item2.getMainAxisSize());
        }
        this.mainAxisSize = maxMainAxis;
        this.mainAxisSizeWithSpacings = RangesKt.coerceAtLeast((int)(maxMainAxis + this.mainAxisSpacing), (int)0);
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final LazyGridMeasuredItem[] getItems() {
        return this.items;
    }

    public final int getMainAxisSize() {
        return this.mainAxisSize;
    }

    public final int getMainAxisSizeWithSpacings() {
        return this.mainAxisSizeWithSpacings;
    }

    public final boolean isEmpty() {
        return this.items.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LazyGridPositionedItem> position(int offset, int layoutWidth, int layoutHeight) {
        void $this$mapIndexedTo$iv$iv;
        int usedSpan = 0;
        LazyGridMeasuredItem[] $this$mapIndexed$iv = this.items;
        boolean $i$f$mapIndexed = false;
        LazyGridMeasuredItem[] lazyGridMeasuredItemArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void item2;
            LazyGridPositionedItem lazyGridPositionedItem;
            void itemIndex;
            int n = index$iv$iv++;
            void var14_14 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int span = GridItemSpan.getCurrentLineSpan-impl(this.spans.get((int)itemIndex).unbox-impl());
            int startSlot = usedSpan;
            LazyGridPositionedItem it = lazyGridPositionedItem = item2.position(offset, this.slots.getPositions()[startSlot], layoutWidth, layoutHeight, this.isVertical ? this.index : startSlot, this.isVertical ? startSlot : this.index);
            boolean bl2 = false;
            usedSpan += span;
            collection.add(lazyGridPositionedItem);
        }
        return (List)destination$iv$iv;
    }
}

