/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lint;

import androidx.compose.foundation.lint.FoundationNames;
import androidx.compose.lint.ComposableUtilsKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0014\u0010\u000f\u001a\u00020\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Landroidx/compose/foundation/lint/LazyLayoutStateReadInCompositionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "derivedStateLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "node", "snapshotFlowLintFix", "Companion", "foundation-lint"})
public final class LazyLayoutStateReadInCompositionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> LazyStateFqNames;
    @NotNull
    private static final List<String> ObservableGetterNames;
    @NotNull
    private static final List<String> ObservablePropertyNames;
    @NotNull
    private static final Issue FrequentlyChangedStateReadInComposition;

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UQualifiedReferenceExpression.class, USimpleNameReferenceExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ LazyLayoutStateReadInCompositionDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                String receiverFqName;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String name = node.getResolvedName();
                if (!CollectionsKt.contains((Iterable)LazyLayoutStateReadInCompositionDetector.Companion.getObservableGetterNames(), (Object)name)) {
                    return;
                }
                PsiType psiType = node.getReceiver().getExpressionType();
                String string = receiverFqName = psiType != null ? psiType.getCanonicalText() : null;
                if (!CollectionsKt.contains((Iterable)LazyLayoutStateReadInCompositionDetector.Companion.getLazyStateFqNames(), (Object)receiverFqName)) {
                    return;
                }
                if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
                    this.reportObservableNodeInComposition(this.$context, (UElement)node);
                }
            }

            public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                String receiverClsFqName;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getUastParent() instanceof UQualifiedReferenceExpression) {
                    return;
                }
                String name = node.getIdentifier();
                if (!LazyLayoutStateReadInCompositionDetector.Companion.getObservablePropertyNames().contains(name)) {
                    return;
                }
                UDeclaration uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration((UElement)node);
                UMethod uMethod = uDeclaration instanceof UMethod ? (UMethod)uDeclaration : null;
                String string = receiverClsFqName = uMethod != null && (uDeclaration = UastUtils.getContainingUClass((UElement)((UElement)uMethod))) != null ? uDeclaration.getQualifiedName() : null;
                if (!CollectionsKt.contains((Iterable)LazyLayoutStateReadInCompositionDetector.Companion.getLazyStateFqNames(), receiverClsFqName)) {
                    return;
                }
                if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
                    this.reportObservableNodeInComposition(this.$context, (UElement)node);
                }
            }

            private final void reportObservableNodeInComposition(JavaContext $this$reportObservableNodeInComposition, UElement node) {
                $this$reportObservableNodeInComposition.report(LazyLayoutStateReadInCompositionDetector.Companion.getFrequentlyChangedStateReadInComposition(), node, $this$reportObservableNodeInComposition.getNameLocation(node), "Frequently changing state should not be directly read in composable function", LintFix.Companion.create().alternatives().add(LazyLayoutStateReadInCompositionDetector.access$derivedStateLintFix(this.this$0, $this$reportObservableNodeInComposition, node)).add(LazyLayoutStateReadInCompositionDetector.access$snapshotFlowLintFix(this.this$0, $this$reportObservableNodeInComposition, node)).build());
            }
        };
    }

    private final LintFix derivedStateLintFix(JavaContext $this$derivedStateLintFix, UElement node) {
        PsiElement psiElement = node.getSourcePsi();
        String text = psiElement != null ? psiElement.getText() : null;
        return LintFix.Companion.create().replace().range($this$derivedStateLintFix.getLocation(node)).name("Wrap with derivedStateOf").text(text).with("androidx.compose.runtime.remember { androidx.compose.runtime.derivedStateOf { " + text + " } }").shortenNames().build();
    }

    private final LintFix snapshotFlowLintFix(JavaContext $this$snapshotFlowLintFix, UElement node) {
        String string;
        if (node instanceof UQualifiedReferenceExpression) {
            PsiElement psiElement = ((UQualifiedReferenceExpression)node).getReceiver().getSourcePsi();
            string = psiElement != null ? psiElement.getText() : null;
        } else {
            string = "this";
        }
        String receiverText = string;
        PsiElement psiElement = node.getSourcePsi();
        String expressionText = psiElement != null ? psiElement.getText() : null;
        return LintFix.Companion.create().replace().range($this$snapshotFlowLintFix.getLocation(node)).name("Collect with snapshotFlow").text(expressionText).with(StringsKt.trimIndent((String)("androidx.compose.runtime.LaunchedEffect(" + receiverText + ") {\n                    androidx.compose.runtime.snapshotFlow { " + expressionText + " }\n                        .collect { TODO(\"Collect the state\") }\n                }"))).shortenNames().reformat(true).build();
    }

    public static final /* synthetic */ LintFix access$derivedStateLintFix(LazyLayoutStateReadInCompositionDetector $this, JavaContext $receiver, UElement node) {
        return $this.derivedStateLintFix($receiver, node);
    }

    public static final /* synthetic */ LintFix access$snapshotFlowLintFix(LazyLayoutStateReadInCompositionDetector $this, JavaContext $receiver, UElement node) {
        return $this.snapshotFlowLintFix($receiver, node);
    }

    static {
        Object[] objectArray = new String[]{FoundationNames.Lazy.INSTANCE.getLazyListState().getJavaFqn(), FoundationNames.Lazy.Grid.INSTANCE.getLazyGridState().getJavaFqn()};
        LazyStateFqNames = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"getFirstVisibleItemIndex", "getFirstVisibleItemScrollOffset", "getLayoutInfo"};
        ObservableGetterNames = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"firstVisibleItemIndex", "firstVisibleItemScrollOffset", "layoutInfo"};
        ObservablePropertyNames = CollectionsKt.listOf((Object[])objectArray);
        FrequentlyChangedStateReadInComposition = Issue.Companion.create("FrequentlyChangedStateReadInComposition", "Frequently changing state should not  be directly read in composable function", "This property is observable and is updated after every scroll or remeasure. If you use it in the composable function directly, it will be recomposed on every change, causing potential performance issues including infinity recomposition loops. Prefer wrapping it with derivedStateOf to use calculation based on this property in composition or collect changes inside LaunchedEffect instead.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(LazyLayoutStateReadInCompositionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Landroidx/compose/foundation/lint/LazyLayoutStateReadInCompositionDetector$Companion;", "", "()V", "FrequentlyChangedStateReadInComposition", "Lcom/android/tools/lint/detector/api/Issue;", "getFrequentlyChangedStateReadInComposition", "()Lcom/android/tools/lint/detector/api/Issue;", "LazyStateFqNames", "", "", "getLazyStateFqNames", "()Ljava/util/List;", "ObservableGetterNames", "getObservableGetterNames", "ObservablePropertyNames", "getObservablePropertyNames", "foundation-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getLazyStateFqNames() {
            return LazyStateFqNames;
        }

        @NotNull
        public final List<String> getObservableGetterNames() {
            return ObservableGetterNames;
        }

        @NotNull
        public final List<String> getObservablePropertyNames() {
            return ObservablePropertyNames;
        }

        @NotNull
        public final Issue getFrequentlyChangedStateReadInComposition() {
            return FrequentlyChangedStateReadInComposition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

