/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.compose.foundation.text.KeyboardOptions;
import androidx.compose.foundation.text2.input.TextEditFilter;
import androidx.compose.foundation.text2.input.TextFieldBufferWithSelection;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/text2/input/FilterChain;", "Landroidx/compose/foundation/text2/input/TextEditFilter;", "first", "second", "keyboardOptions", "Landroidx/compose/foundation/text/KeyboardOptions;", "(Landroidx/compose/foundation/text2/input/TextEditFilter;Landroidx/compose/foundation/text2/input/TextEditFilter;Landroidx/compose/foundation/text/KeyboardOptions;)V", "getKeyboardOptions", "()Landroidx/compose/foundation/text/KeyboardOptions;", "equals", "", "other", "", "filter", "", "originalValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "valueWithChanges", "Landroidx/compose/foundation/text2/input/TextFieldBufferWithSelection;", "hashCode", "", "toString", "", "foundation_release"})
final class FilterChain
implements TextEditFilter {
    @NotNull
    private final TextEditFilter first;
    @NotNull
    private final TextEditFilter second;
    @Nullable
    private final KeyboardOptions keyboardOptions;

    public FilterChain(@NotNull TextEditFilter first, @NotNull TextEditFilter second, @Nullable KeyboardOptions keyboardOptions) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        this.first = first;
        this.second = second;
        this.keyboardOptions = keyboardOptions;
    }

    @Override
    @Nullable
    public KeyboardOptions getKeyboardOptions() {
        return this.keyboardOptions;
    }

    @Override
    public void filter(@NotNull TextFieldCharSequence originalValue, @NotNull TextFieldBufferWithSelection valueWithChanges) {
        Intrinsics.checkNotNullParameter((Object)originalValue, (String)"originalValue");
        Intrinsics.checkNotNullParameter((Object)valueWithChanges, (String)"valueWithChanges");
        this.first.filter(originalValue, valueWithChanges);
        this.second.filter(originalValue, valueWithChanges);
    }

    @NotNull
    public String toString() {
        return this.first + ".then(" + this.second + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.compose.foundation.text2.input.FilterChain");
        FilterChain cfr_ignored_0 = (FilterChain)other;
        if (!Intrinsics.areEqual((Object)this.first, (Object)((FilterChain)other).first)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.second, (Object)((FilterChain)other).second)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getKeyboardOptions(), (Object)((FilterChain)other).getKeyboardOptions());
    }

    public int hashCode() {
        int result2 = this.first.hashCode();
        result2 = 31 * result2 + this.second.hashCode();
        KeyboardOptions keyboardOptions = this.getKeyboardOptions();
        result2 = 32 * result2 + (keyboardOptions != null ? ((Object)keyboardOptions).hashCode() : 0);
        return result2;
    }
}

