/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.compose.foundation.text2.input.TextEditFilter;
import androidx.compose.foundation.text2.input.TextFieldBufferWithSelection;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/foundation/text2/input/MaxLengthFilter;", "Landroidx/compose/foundation/text2/input/TextEditFilter;", "maxLength", "", "inCodepoints", "", "(IZ)V", "component1", "component2", "copy", "equals", "other", "", "filter", "", "originalValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "valueWithChanges", "Landroidx/compose/foundation/text2/input/TextFieldBufferWithSelection;", "hashCode", "toString", "", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nMaxLengthFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxLengthFilter.kt\nandroidx/compose/foundation/text2/input/MaxLengthFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
final class MaxLengthFilter
implements TextEditFilter {
    private final int maxLength;
    private final boolean inCodepoints;

    public MaxLengthFilter(int maxLength, boolean inCodepoints) {
        this.maxLength = maxLength;
        this.inCodepoints = inCodepoints;
        if (!(this.maxLength >= 0)) {
            boolean bl = false;
            String string = "maxLength must be at least zero, was " + this.maxLength;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void filter(@NotNull TextFieldCharSequence originalValue, @NotNull TextFieldBufferWithSelection valueWithChanges) {
        int newLength;
        Intrinsics.checkNotNullParameter((Object)originalValue, (String)"originalValue");
        Intrinsics.checkNotNullParameter((Object)valueWithChanges, (String)"valueWithChanges");
        int n = newLength = this.inCodepoints ? valueWithChanges.getCodepointLength() : valueWithChanges.length();
        if (newLength > this.maxLength) {
            valueWithChanges.revertAllChanges();
        }
    }

    @NotNull
    public String toString() {
        String name = this.inCodepoints ? "maxLengthInCodepoints" : "maxLengthInChars";
        return "TextEditFilter." + name + "(maxLength=" + this.maxLength + ')';
    }

    private final int component1() {
        return this.maxLength;
    }

    private final boolean component2() {
        return this.inCodepoints;
    }

    @NotNull
    public final MaxLengthFilter copy(int maxLength, boolean inCodepoints) {
        return new MaxLengthFilter(maxLength, inCodepoints);
    }

    public static /* synthetic */ MaxLengthFilter copy$default(MaxLengthFilter maxLengthFilter, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = maxLengthFilter.maxLength;
        }
        if ((n2 & 2) != 0) {
            bl = maxLengthFilter.inCodepoints;
        }
        return maxLengthFilter.copy(n, bl);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.maxLength);
        int n = this.inCodepoints ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MaxLengthFilter)) {
            return false;
        }
        MaxLengthFilter maxLengthFilter = (MaxLengthFilter)other;
        if (this.maxLength != maxLengthFilter.maxLength) {
            return false;
        }
        return this.inCodepoints == maxLengthFilter.inCodepoints;
    }
}

