/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.text2.input.TextEditFilter;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.TextFieldState;
import androidx.compose.foundation.text2.input.internal.AndroidTextInputAdapter;
import androidx.compose.foundation.text2.input.internal.AndroidTextInputAdapterKt;
import androidx.compose.foundation.text2.input.internal.ComposeInputMethodManager;
import androidx.compose.foundation.text2.input.internal.ComposeInputMethodManagerKt;
import androidx.compose.foundation.text2.input.internal.EditCommand;
import androidx.compose.foundation.text2.input.internal.EditProcessor;
import androidx.compose.foundation.text2.input.internal.EditableTextInputSession;
import androidx.compose.foundation.text2.input.internal.StatelessInputConnection;
import androidx.compose.foundation.text2.input.internal.TextInputCommand;
import androidx.compose.foundation.text2.input.internal.TextInputCommandExecutor;
import androidx.compose.foundation.text2.input.internal.TextInputSession;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.PlatformTextInput;
import androidx.compose.ui.text.input.PlatformTextInputAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0010\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J7\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00f8\u0001\u0000J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\"H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Landroidx/compose/foundation/text2/input/internal/AndroidTextInputAdapter;", "Landroidx/compose/ui/text/input/PlatformTextInputAdapter;", "view", "Landroid/view/View;", "platformTextInput", "Landroidx/compose/ui/text/input/PlatformTextInput;", "(Landroid/view/View;Landroidx/compose/ui/text/input/PlatformTextInput;)V", "currentTextInputSession", "Landroidx/compose/foundation/text2/input/internal/EditableTextInputSession;", "inputMethodManager", "Landroidx/compose/foundation/text2/input/internal/ComposeInputMethodManager;", "resetListener", "Landroidx/compose/foundation/text2/input/internal/EditProcessor$ResetListener;", "textInputCommandExecutor", "Landroidx/compose/foundation/text2/input/internal/TextInputCommandExecutor;", "createEditableTextInputSession", "androidx/compose/foundation/text2/input/internal/AndroidTextInputAdapter$createEditableTextInputSession$1", "state", "Landroidx/compose/foundation/text2/input/TextFieldState;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "initialFilter", "Landroidx/compose/foundation/text2/input/TextEditFilter;", "onImeActionPerformed", "Lkotlin/Function1;", "Landroidx/compose/ui/text/input/ImeAction;", "", "(Landroidx/compose/foundation/text2/input/TextFieldState;Landroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/foundation/text2/input/TextEditFilter;Lkotlin/jvm/functions/Function1;)Landroidx/compose/foundation/text2/input/internal/AndroidTextInputAdapter$createEditableTextInputSession$1;", "createInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onDisposed", "startInputSession", "Landroidx/compose/foundation/text2/input/internal/TextInputSession;", "stopInputSession", "session", "Companion", "foundation_release"})
public final class AndroidTextInputAdapter
implements PlatformTextInputAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformTextInput platformTextInput;
    @Nullable
    private EditableTextInputSession currentTextInputSession;
    @NotNull
    private final ComposeInputMethodManager inputMethodManager;
    @NotNull
    private final TextInputCommandExecutor textInputCommandExecutor;
    @NotNull
    private final EditProcessor.ResetListener resetListener;
    @Nullable
    private static Function2<? super EditorInfo, ? super InputConnection, Unit> testInputConnectionCreatedListener;

    public AndroidTextInputAdapter(@NotNull View view, @NotNull PlatformTextInput platformTextInput) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)platformTextInput, (String)"platformTextInput");
        this.platformTextInput = platformTextInput;
        this.inputMethodManager = ComposeInputMethodManagerKt.ComposeInputMethodManager(view);
        this.textInputCommandExecutor = new TextInputCommandExecutor(view, this.inputMethodManager, null, 4, null);
        this.resetListener = new EditProcessor.ResetListener(this){
            final /* synthetic */ AndroidTextInputAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onReset(@NotNull TextFieldCharSequence old, @NotNull TextFieldCharSequence textFieldCharSequence) {
                boolean needUpdateSelection;
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)textFieldCharSequence, (String)"new");
                boolean bl = needUpdateSelection = !TextRange.equals-impl0((long)old.getSelectionInChars-d9O1mEE(), (long)textFieldCharSequence.getSelectionInChars-d9O1mEE()) || !Intrinsics.areEqual((Object)old.getCompositionInChars-MzsxiRA(), (Object)textFieldCharSequence.getCompositionInChars-MzsxiRA());
                if (needUpdateSelection) {
                    TextRange textRange = textFieldCharSequence.getCompositionInChars-MzsxiRA();
                    TextRange textRange2 = textFieldCharSequence.getCompositionInChars-MzsxiRA();
                    AndroidTextInputAdapter.access$getInputMethodManager$p(this.this$0).updateSelection(TextRange.getMin-impl((long)textFieldCharSequence.getSelectionInChars-d9O1mEE()), TextRange.getMax-impl((long)textFieldCharSequence.getSelectionInChars-d9O1mEE()), textRange != null ? TextRange.getMin-impl((long)textRange.unbox-impl()) : -1, textRange2 != null ? TextRange.getMax-impl((long)textRange2.unbox-impl()) : -1);
                }
                if (!old.contentEquals(textFieldCharSequence)) {
                    AndroidTextInputAdapter.access$getInputMethodManager$p(this.this$0).restartInput();
                }
            }
        };
    }

    @NotNull
    public InputConnection createInputConnection(@NotNull EditorInfo outAttrs) {
        StatelessInputConnection inputConnection2;
        block2: {
            EditableTextInputSession editableTextInputSession;
            Object value;
            Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
            AndroidTextInputAdapterKt.logDebug$default(null, createInputConnection.1.INSTANCE, 1, null);
            Object object = this.currentTextInputSession;
            if (object == null || (object = object.getValue()) == null) {
                object = value = TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo$default(null, 0L, 3, null);
            }
            if ((editableTextInputSession = this.currentTextInputSession) == null || (editableTextInputSession = editableTextInputSession.getImeOptions()) == null) {
                editableTextInputSession = ImeOptions.Companion.getDefault();
            }
            EditableTextInputSession imeOptions = editableTextInputSession;
            AndroidTextInputAdapterKt.logDebug$default(null, (Function0)new Function0<String>((TextFieldCharSequence)value){
                final /* synthetic */ TextFieldCharSequence $value;
                {
                    this.$value = $value;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "createInputConnection.value = " + this.$value;
                }
            }, 1, null);
            AndroidTextInputAdapterKt.update(outAttrs, (TextFieldCharSequence)value, (ImeOptions)imeOptions);
            inputConnection2 = new StatelessInputConnection((Function0<? extends EditableTextInputSession>)((Function0)new Function0<EditableTextInputSession>(this){
                final /* synthetic */ AndroidTextInputAdapter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final EditableTextInputSession invoke() {
                    return AndroidTextInputAdapter.access$getCurrentTextInputSession$p(this.this$0);
                }
            }));
            Function2<? super EditorInfo, ? super InputConnection, Unit> function2 = testInputConnectionCreatedListener;
            if (function2 == null) break block2;
            function2.invoke((Object)outAttrs, (Object)inputConnection2);
        }
        return inputConnection2;
    }

    public void onDisposed() {
        block0: {
            EditableTextInputSession editableTextInputSession = this.currentTextInputSession;
            if (editableTextInputSession == null) break block0;
            editableTextInputSession.dispose();
        }
    }

    @NotNull
    public final TextInputSession startInputSession(@NotNull TextFieldState state, @NotNull ImeOptions imeOptions, @Nullable TextEditFilter initialFilter, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"imeOptions");
        Intrinsics.checkNotNullParameter(onImeActionPerformed2, (String)"onImeActionPerformed");
        if (!AndroidTextInputAdapterKt.access$isMainThread()) {
            throw new IllegalStateException("Input sessions can only be started from the main thread.");
        }
        AndroidTextInputAdapterKt.logDebug$default(null, (Function0)new Function0<String>(state){
            final /* synthetic */ TextFieldState $state;
            {
                this.$state = $state;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "startInputSession.state = " + this.$state;
            }
        }, 1, null);
        this.platformTextInput.requestInputFocus();
        this.textInputCommandExecutor.send(TextInputCommand.StartInput);
        createEditableTextInputSession.1 nextSession = this.createEditableTextInputSession(state, imeOptions, initialFilter, onImeActionPerformed2);
        this.currentTextInputSession = nextSession;
        return nextSession;
    }

    private final createEditableTextInputSession.1 createEditableTextInputSession(TextFieldState state, ImeOptions imeOptions, TextEditFilter initialFilter, Function1<? super ImeAction, Unit> onImeActionPerformed2) {
        return new EditableTextInputSession(state, this, initialFilter, imeOptions, onImeActionPerformed2){
            @Nullable
            private TextEditFilter filter;
            @NotNull
            private final ImeOptions imeOptions;
            final /* synthetic */ TextFieldState $state;
            final /* synthetic */ AndroidTextInputAdapter this$0;
            final /* synthetic */ Function1<ImeAction, Unit> $onImeActionPerformed;
            {
                this.$state = $state;
                this.this$0 = $receiver;
                this.$onImeActionPerformed = $onImeActionPerformed;
                $state.getEditProcessor$foundation_release().addResetListener$foundation_release(AndroidTextInputAdapter.access$getResetListener$p($receiver));
                this.filter = $initialFilter;
                this.imeOptions = $imeOptions;
            }

            public boolean isOpen() {
                return Intrinsics.areEqual((Object)AndroidTextInputAdapter.access$getCurrentTextInputSession$p(this.this$0), (Object)this);
            }

            public void showSoftwareKeyboard() {
                if (this.isOpen()) {
                    AndroidTextInputAdapter.access$getTextInputCommandExecutor$p(this.this$0).send(TextInputCommand.ShowKeyboard);
                }
            }

            public void hideSoftwareKeyboard() {
                if (this.isOpen()) {
                    AndroidTextInputAdapter.access$getTextInputCommandExecutor$p(this.this$0).send(TextInputCommand.HideKeyboard);
                }
            }

            public void dispose() {
                this.$state.getEditProcessor$foundation_release().removeResetListener$foundation_release(AndroidTextInputAdapter.access$getResetListener$p(this.this$0));
                AndroidTextInputAdapter.access$stopInputSession(this.this$0, this);
            }

            @NotNull
            public TextFieldCharSequence getValue() {
                return this.$state.getText();
            }

            public void setFilter(@Nullable TextEditFilter filter) {
                this.filter = filter;
            }

            public void requestEdits(@NotNull List<? extends EditCommand> editCommands) {
                Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
                this.$state.getEditProcessor$foundation_release().update(editCommands, this.filter);
            }

            public void sendKeyEvent(@NotNull KeyEvent keyEvent) {
                Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
                AndroidTextInputAdapter.access$getInputMethodManager$p(this.this$0).sendKeyEvent(keyEvent);
            }

            @NotNull
            public ImeOptions getImeOptions() {
                return this.imeOptions;
            }

            public void onImeAction-KlQnJC8(int imeAction) {
                this.$onImeActionPerformed.invoke((Object)ImeAction.box-impl((int)imeAction));
            }
        };
    }

    private final void stopInputSession(TextInputSession session) {
        if (!AndroidTextInputAdapterKt.access$isMainThread()) {
            throw new IllegalStateException("Input sessions can only be stopped from the main thread.");
        }
        if (Intrinsics.areEqual((Object)this.currentTextInputSession, (Object)session)) {
            this.currentTextInputSession = null;
            this.platformTextInput.releaseInputFocus();
            this.textInputCommandExecutor.send(TextInputCommand.StopInput);
        }
    }

    public static final /* synthetic */ EditableTextInputSession access$getCurrentTextInputSession$p(AndroidTextInputAdapter $this) {
        return $this.currentTextInputSession;
    }

    public static final /* synthetic */ EditProcessor.ResetListener access$getResetListener$p(AndroidTextInputAdapter $this) {
        return $this.resetListener;
    }

    public static final /* synthetic */ TextInputCommandExecutor access$getTextInputCommandExecutor$p(AndroidTextInputAdapter $this) {
        return $this.textInputCommandExecutor;
    }

    public static final /* synthetic */ void access$stopInputSession(AndroidTextInputAdapter $this, TextInputSession session) {
        $this.stopInputSession(session);
    }

    public static final /* synthetic */ ComposeInputMethodManager access$getInputMethodManager$p(AndroidTextInputAdapter $this) {
        return $this.inputMethodManager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\u00072\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0004H\u0007R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/compose/foundation/text2/input/internal/AndroidTextInputAdapter$Companion;", "", "()V", "testInputConnectionCreatedListener", "Lkotlin/Function2;", "Landroid/view/inputmethod/EditorInfo;", "Landroid/view/inputmethod/InputConnection;", "", "setInputConnectionCreatedListenerForTests", "listener", "foundation_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void setInputConnectionCreatedListenerForTests(@Nullable Function2<? super EditorInfo, ? super InputConnection, Unit> listener) {
            testInputConnectionCreatedListener = listener;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

