/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import androidx.compose.foundation.text2.input.TextEditFilter;
import androidx.compose.foundation.text2.input.TextFieldBufferWithSelection;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.ApplyEditCommandKt;
import androidx.compose.foundation.text2.input.internal.EditCommand;
import androidx.compose.foundation.text2.input.internal.EditProcessorKt;
import androidx.compose.foundation.text2.input.internal.EditingBuffer;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.text.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ \u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0015\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u0003J\u001e\u0010'\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010(\u001a\u0004\u0018\u00010)R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0004*\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Landroidx/compose/foundation/text2/input/internal/EditProcessor;", "", "initialValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "(Landroidx/compose/foundation/text2/input/TextFieldCharSequence;)V", "<set-?>", "Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "mBuffer", "getMBuffer$foundation_release", "()Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "resetListeners", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/text2/input/internal/EditProcessor$ResetListener;", "value", "getValue$delegate", "(Landroidx/compose/foundation/text2/input/internal/EditProcessor;)Ljava/lang/Object;", "getValue", "()Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "setValue", "valueMutableState", "Landroidx/compose/runtime/MutableState;", "valueState", "Landroidx/compose/runtime/State;", "getValueState", "()Landroidx/compose/runtime/State;", "addResetListener", "", "resetListener", "addResetListener$foundation_release", "generateBatchErrorMessage", "", "editCommands", "", "Landroidx/compose/foundation/text2/input/internal/EditCommand;", "failedCommand", "removeResetListener", "removeResetListener$foundation_release", "reset", "newValue", "update", "filter", "Landroidx/compose/foundation/text2/input/TextEditFilter;", "ResetListener", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nEditProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/foundation/text2/input/internal/EditProcessor\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,248:1\n1182#2:249\n1161#2,2:250\n81#3:252\n107#3,2:253\n460#4,11:255\n33#5,6:266\n*S KotlinDebug\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/foundation/text2/input/internal/EditProcessor\n*L\n65#1:249\n65#1:250,2\n53#1:252\n53#1:253,2\n132#1:255,11\n151#1:266,6\n*E\n"})
public final class EditProcessor {
    @NotNull
    private final MutableState<TextFieldCharSequence> valueMutableState;
    @NotNull
    private EditingBuffer mBuffer;
    @NotNull
    private final MutableVector<ResetListener> resetListeners;

    public EditProcessor(@NotNull TextFieldCharSequence initialValue) {
        Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
        this.valueMutableState = SnapshotStateKt.mutableStateOf$default((Object)initialValue, null, (int)2, null);
        this.mBuffer = new EditingBuffer(((Object)initialValue).toString(), initialValue.getSelectionInChars-d9O1mEE(), null);
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.resetListeners = new MutableVector((Object[])new ResetListener[capacity$iv$iv], 0);
    }

    public /* synthetic */ EditProcessor(TextFieldCharSequence textFieldCharSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            textFieldCharSequence = TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo("", TextRange.Companion.getZero-d9O1mEE());
        }
        this(textFieldCharSequence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldCharSequence getValue() {
        void $this$getValue$iv;
        State state = (State)this.valueMutableState;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (TextFieldCharSequence)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setValue(TextFieldCharSequence textFieldCharSequence) {
        void $this$setValue$iv;
        MutableState<TextFieldCharSequence> mutableState = this.valueMutableState;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)textFieldCharSequence);
    }

    private static Object getValue$delegate(EditProcessor editProcessor) {
        return editProcessor.valueMutableState;
    }

    @NotNull
    public final State<TextFieldCharSequence> getValueState() {
        return (State)this.valueMutableState;
    }

    @NotNull
    public final EditingBuffer getMBuffer$foundation_release() {
        return this.mBuffer;
    }

    public final void reset(@NotNull TextFieldCharSequence newValue) {
        boolean compositionChanged;
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        TextFieldCharSequence bufferState = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mBuffer.toString(), this.mBuffer.getSelection-d9O1mEE(), this.mBuffer.getComposition-MzsxiRA());
        boolean textChanged = false;
        boolean selectionChanged = false;
        boolean bl = compositionChanged = !Intrinsics.areEqual((Object)newValue.getCompositionInChars-MzsxiRA(), (Object)this.mBuffer.getComposition-MzsxiRA());
        if (!bufferState.contentEquals(newValue)) {
            this.mBuffer = new EditingBuffer(((Object)newValue).toString(), newValue.getSelectionInChars-d9O1mEE(), null);
            textChanged = true;
        } else if (!TextRange.equals-impl0((long)bufferState.getSelectionInChars-d9O1mEE(), (long)newValue.getSelectionInChars-d9O1mEE())) {
            this.mBuffer.setSelection(TextRange.getMin-impl((long)newValue.getSelectionInChars-d9O1mEE()), TextRange.getMax-impl((long)newValue.getSelectionInChars-d9O1mEE()));
            selectionChanged = true;
        }
        TextRange composition = newValue.getCompositionInChars-MzsxiRA();
        if (composition == null || TextRange.getCollapsed-impl((long)composition.unbox-impl())) {
            this.mBuffer.commitComposition();
        } else {
            this.mBuffer.setComposition(TextRange.getMin-impl((long)composition.unbox-impl()), TextRange.getMax-impl((long)composition.unbox-impl()));
        }
        if (textChanged || !selectionChanged && compositionChanged) {
            this.mBuffer.commitComposition();
        }
        TextFieldCharSequence finalValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(textChanged ? newValue : bufferState, this.mBuffer.getSelection-d9O1mEE(), this.mBuffer.getComposition-MzsxiRA());
        MutableVector<ResetListener> this_$iv = this.resetListeners;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                ResetListener it = (ResetListener)content$iv[i$iv];
                boolean bl2 = false;
                it.onReset(bufferState, finalValue);
            } while (++i$iv < size$iv);
        }
        this.setValue(finalValue);
    }

    public final void update(@NotNull List<? extends EditCommand> editCommands, @Nullable TextEditFilter filter) {
        Intrinsics.checkNotNullParameter(editCommands, (String)"editCommands");
        EditCommand lastCommand = null;
        this.mBuffer.getChangeTracker().clearChanges();
        try {
            List<? extends EditCommand> $this$fastForEach$iv = editCommands;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                EditCommand item$iv;
                EditCommand it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                lastCommand = it;
                ApplyEditCommandKt.update(this.mBuffer, it);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.generateBatchErrorMessage(editCommands, lastCommand), e);
        }
        TextFieldCharSequence proposedValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mBuffer.toString(), this.mBuffer.getSelection-d9O1mEE(), this.mBuffer.getComposition-MzsxiRA());
        TextEditFilter filter2 = filter;
        if (filter2 == null) {
            this.setValue(proposedValue);
        } else {
            TextFieldCharSequence oldValue = this.getValue();
            TextFieldBufferWithSelection mutableValue = new TextFieldBufferWithSelection(proposedValue, oldValue, this.mBuffer.getChangeTracker());
            filter2.filter(oldValue, mutableValue);
            TextFieldCharSequence newValue = mutableValue.toTextFieldCharSequence-OEnZFl4$foundation_release(proposedValue.getCompositionInChars-MzsxiRA());
            if (Intrinsics.areEqual((Object)newValue, (Object)proposedValue)) {
                this.setValue(newValue);
            } else {
                this.reset(newValue);
            }
        }
    }

    private final String generateBatchErrorMessage(List<? extends EditCommand> editCommands, EditCommand failedCommand) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateBatchErrorMessage_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$generateBatchErrorMessage_u24lambda_u242.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength() + ", composition=" + this.mBuffer.getComposition-MzsxiRA() + ", selection=" + TextRange.toString-impl((long)this.mBuffer.getSelection-d9O1mEE()) + "):");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        CollectionsKt.joinTo$default((Iterable)editCommands, (Appendable)$this$generateBatchErrorMessage_u24lambda_u242, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<EditCommand, CharSequence>(failedCommand){
            final /* synthetic */ EditCommand $failedCommand;
            {
                this.$failedCommand = $failedCommand;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull EditCommand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String prefix = this.$failedCommand == it ? " > " : "   ";
                return prefix + EditProcessorKt.toStringForLog(it);
            }
        }), (int)60, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final void addResetListener$foundation_release(@NotNull ResetListener resetListener2) {
        Intrinsics.checkNotNullParameter((Object)resetListener2, (String)"resetListener");
        this.resetListeners.add((Object)resetListener2);
    }

    public final void removeResetListener$foundation_release(@NotNull ResetListener resetListener2) {
        Intrinsics.checkNotNullParameter((Object)resetListener2, (String)"resetListener");
        this.resetListeners.remove((Object)resetListener2);
    }

    public EditProcessor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text2/input/internal/EditProcessor$ResetListener;", "", "onReset", "", "oldValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "newValue", "foundation_release"})
    public static interface ResetListener {
        public void onReset(@NotNull TextFieldCharSequence var1, @NotNull TextFieldCharSequence var2);
    }
}

