/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import android.view.Choreographer;
import android.view.View;
import androidx.compose.foundation.text2.input.internal.AndroidTextInputAdapterKt;
import androidx.compose.foundation.text2.input.internal.ComposeInputMethodManager;
import androidx.compose.foundation.text2.input.internal.TextInputCommand;
import androidx.compose.foundation.text2.input.internal.TextInputCommandExecutor;
import androidx.compose.runtime.collection.MutableVector;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/foundation/text2/input/internal/TextInputCommandExecutor;", "", "view", "Landroid/view/View;", "inputMethodManager", "Landroidx/compose/foundation/text2/input/internal/ComposeInputMethodManager;", "inputCommandProcessorExecutor", "Ljava/util/concurrent/Executor;", "(Landroid/view/View;Landroidx/compose/foundation/text2/input/internal/ComposeInputMethodManager;Ljava/util/concurrent/Executor;)V", "frameCallback", "Ljava/lang/Runnable;", "textInputCommandQueue", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/text2/input/internal/TextInputCommand;", "processQueue", "", "restartInputImmediately", "send", "textInputCommand", "setKeyboardVisibleImmediately", "visible", "", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nAndroidTextInputAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTextInputAdapter.kt\nandroidx/compose/foundation/text2/input/internal/TextInputCommandExecutor\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1182#2:491\n1161#2,2:492\n728#3,2:494\n460#3,11:497\n1#4:496\n*S KotlinDebug\n*F\n+ 1 AndroidTextInputAdapter.kt\nandroidx/compose/foundation/text2/input/internal/TextInputCommandExecutor\n*L\n265#1:491\n265#1:492,2\n269#1:494,2\n348#1:497,11\n*E\n"})
public final class TextInputCommandExecutor {
    @NotNull
    private final View view;
    @NotNull
    private final ComposeInputMethodManager inputMethodManager;
    @NotNull
    private final Executor inputCommandProcessorExecutor;
    @NotNull
    private final MutableVector<TextInputCommand> textInputCommandQueue;
    @Nullable
    private Runnable frameCallback;

    public TextInputCommandExecutor(@NotNull View view, @NotNull ComposeInputMethodManager inputMethodManager, @NotNull Executor inputCommandProcessorExecutor) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)inputMethodManager, (String)"inputMethodManager");
        Intrinsics.checkNotNullParameter((Object)inputCommandProcessorExecutor, (String)"inputCommandProcessorExecutor");
        this.view = view;
        this.inputMethodManager = inputMethodManager;
        this.inputCommandProcessorExecutor = inputCommandProcessorExecutor;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.textInputCommandQueue = new MutableVector((Object[])new TextInputCommand[capacity$iv$iv], 0);
    }

    public /* synthetic */ TextInputCommandExecutor(View view, ComposeInputMethodManager composeInputMethodManager, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Choreographer choreographer = Choreographer.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)choreographer, (String)"getInstance()");
            executor = AndroidTextInputAdapterKt.access$asExecutor(choreographer);
        }
        this(view, composeInputMethodManager, executor);
    }

    /*
     * WARNING - void declaration
     */
    public final void send(@NotNull TextInputCommand textInputCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)textInputCommand), (String)"textInputCommand");
        MutableVector<TextInputCommand> this_$iv = this.textInputCommandQueue;
        boolean $i$f$plusAssign = false;
        this_$iv.add((Object)textInputCommand);
        if (this.frameCallback == null) {
            void p0;
            Runnable runnable = () -> TextInputCommandExecutor.send$lambda$0(this);
            Executor executor = this.inputCommandProcessorExecutor;
            Runnable runnable2 = runnable;
            TextInputCommandExecutor textInputCommandExecutor = this;
            boolean bl = false;
            executor.execute((Runnable)p0);
            textInputCommandExecutor.frameCallback = runnable;
        }
    }

    private final void processQueue() {
        AndroidTextInputAdapterKt.logDebug$default(null, processQueue.1.INSTANCE, 1, null);
        if (!this.view.isFocused()) {
            AndroidTextInputAdapterKt.logDebug$default(null, processQueue.2.INSTANCE, 1, null);
            this.textInputCommandQueue.clear();
            return;
        }
        Ref.ObjectRef startInput = new Ref.ObjectRef();
        Ref.ObjectRef showKeyboard = new Ref.ObjectRef();
        MutableVector<TextInputCommand> this_$iv = this.textInputCommandQueue;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                TextInputCommand command = (TextInputCommand)((Object)content$iv[i$iv]);
                boolean bl = false;
                TextInputCommandExecutor.processQueue$applyToState(command, (Ref.ObjectRef<Boolean>)startInput, (Ref.ObjectRef<Boolean>)showKeyboard);
                AndroidTextInputAdapterKt.logDebug$default(null, (Function0)new Function0<String>(command){
                    final /* synthetic */ TextInputCommand $command;
                    {
                        this.$command = $command;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "command: " + (Object)((Object)this.$command) + " applied to state";
                    }
                }, 1, null);
            } while (++i$iv < size$iv);
        }
        AndroidTextInputAdapterKt.logDebug$default(null, (Function0)new Function0<String>((Ref.ObjectRef<Boolean>)startInput, (Ref.ObjectRef<Boolean>)showKeyboard){
            final /* synthetic */ Ref.ObjectRef<Boolean> $startInput;
            final /* synthetic */ Ref.ObjectRef<Boolean> $showKeyboard;
            {
                this.$startInput = $startInput;
                this.$showKeyboard = $showKeyboard;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "commands are applied. startInput = " + this.$startInput.element + ", showKeyboard = " + this.$showKeyboard.element;
            }
        }, 1, null);
        if (Intrinsics.areEqual((Object)startInput.element, (Object)true)) {
            this.restartInputImmediately();
        }
        Boolean bl = (Boolean)showKeyboard.element;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean p0 = bl2;
            boolean bl3 = false;
            this.setKeyboardVisibleImmediately(p0);
        }
        if (Intrinsics.areEqual((Object)startInput.element, (Object)false)) {
            this.restartInputImmediately();
        }
    }

    private final void restartInputImmediately() {
        AndroidTextInputAdapterKt.logDebug$default(null, restartInputImmediately.1.INSTANCE, 1, null);
        this.inputMethodManager.restartInput();
    }

    private final void setKeyboardVisibleImmediately(boolean visible) {
        AndroidTextInputAdapterKt.logDebug$default(null, (Function0)new Function0<String>(visible){
            final /* synthetic */ boolean $visible;
            {
                this.$visible = $visible;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "setKeyboardVisibleImmediately(visible: " + this.$visible + ')';
            }
        }, 1, null);
        if (visible) {
            this.inputMethodManager.showSoftInput();
        } else {
            this.inputMethodManager.hideSoftInput();
        }
    }

    private static final void send$lambda$0(TextInputCommandExecutor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.frameCallback = null;
        this$0.processQueue();
    }

    private static final void processQueue$applyToState(TextInputCommand $this$processQueue_u24applyToState, Ref.ObjectRef<Boolean> startInput, Ref.ObjectRef<Boolean> showKeyboard) {
        switch (WhenMappings.$EnumSwitchMapping$0[$this$processQueue_u24applyToState.ordinal()]) {
            case 1: {
                startInput.element = true;
                showKeyboard.element = true;
                break;
            }
            case 2: {
                startInput.element = false;
                showKeyboard.element = false;
                break;
            }
            case 3: 
            case 4: {
                if (Intrinsics.areEqual((Object)startInput.element, (Object)false)) break;
                showKeyboard.element = $this$processQueue_u24applyToState == TextInputCommand.ShowKeyboard;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextInputCommand.values().length];
            try {
                nArray[TextInputCommand.StartInput.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.StopInput.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.ShowKeyboard.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextInputCommand.HideKeyboard.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

