/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import androidx.compose.foundation.text2.input.internal.GapBuffer;
import androidx.compose.foundation.text2.input.internal.ToCharArrayKt;
import androidx.compose.foundation.text2.input.internal.ToCharArray_androidKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0086\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/compose/foundation/text2/input/internal/PartialGapBuffer;", "", "text", "", "(Ljava/lang/CharSequence;)V", "bufEnd", "", "bufStart", "buffer", "Landroidx/compose/foundation/text2/input/internal/GapBuffer;", "length", "getLength", "()I", "get", "", "index", "replace", "", "start", "end", "toString", "", "Companion", "foundation_release"})
public final class PartialGapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CharSequence text;
    @Nullable
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;

    public PartialGapBuffer(@NotNull CharSequence text) {
        this.text = text;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    public final int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + buffer.length();
    }

    public final void replace(int start, int end, @NotNull CharSequence text) {
        if (!(start <= end)) {
            boolean $i$a$-require-PartialGapBuffer$replace$32 = false;
            String $i$a$-require-PartialGapBuffer$replace$32 = "start index must be less than or equal to end index: " + start + " > " + end;
            throw new IllegalArgumentException($i$a$-require-PartialGapBuffer$replace$32.toString());
        }
        if (!(start >= 0)) {
            boolean $i$a$-require-PartialGapBuffer$replace$42 = false;
            String $i$a$-require-PartialGapBuffer$replace$42 = "start must be non-negative, but was " + start;
            throw new IllegalArgumentException($i$a$-require-PartialGapBuffer$replace$42.toString());
        }
        GapBuffer buffer = this.buffer;
        if (buffer == null) {
            char[] charArray = new char[Math.max(255, text.length() + 128)];
            int leftCopyCount = Math.min(start, 64);
            int rightCopyCount = Math.min(this.text.length() - end, 64);
            ToCharArray_androidKt.toCharArray(this.text, charArray, 0, start - leftCopyCount, start);
            ToCharArray_androidKt.toCharArray(this.text, charArray, charArray.length - rightCopyCount, end, end + rightCopyCount);
            ToCharArrayKt.toCharArray(text, charArray, leftCopyCount);
            this.buffer = new GapBuffer(charArray, leftCopyCount + text.length(), charArray.length - rightCopyCount);
            this.bufStart = start - leftCopyCount;
            this.bufEnd = end + rightCopyCount;
            return;
        }
        int bufferStart = start - this.bufStart;
        int bufferEnd = end - this.bufStart;
        if (bufferStart < 0 || bufferEnd > buffer.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(start, end, text);
            return;
        }
        buffer.replace(bufferStart, bufferEnd, text);
    }

    public final char get(int index2) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index2);
        }
        GapBuffer buffer = gapBuffer;
        if (index2 < this.bufStart) {
            return this.text.charAt(index2);
        }
        int gapBufLength = buffer.length();
        if (index2 < gapBufLength + this.bufStart) {
            return buffer.get(index2 - this.bufStart);
        }
        return this.text.charAt(index2 - (gapBufLength - this.bufEnd + this.bufStart));
    }

    @NotNull
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return ((Object)this.text).toString();
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        b.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        return sb.toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/foundation/text2/input/internal/PartialGapBuffer$Companion;", "", "()V", "BUF_SIZE", "", "NOWHERE", "SURROUNDING_SIZE", "foundation_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

