/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.SnapPositionInLayoutKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0018\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u0004\u0018\u00010)*\u00020'2\u0006\u0010*\u001a\u00020+H\u0002R+\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR+\u0010\u001b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00038F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Landroidx/compose/foundation/pager/PagerScrollPosition;", "", "initialPage", "", "initialScrollOffset", "state", "Landroidx/compose/foundation/pager/PagerState;", "(IILandroidx/compose/foundation/pager/PagerState;)V", "<set-?>", "currentPage", "getCurrentPage", "()I", "setCurrentPage", "(I)V", "currentPage$delegate", "Landroidx/compose/runtime/MutableIntState;", "firstVisiblePage", "getFirstVisiblePage", "setFirstVisiblePage", "firstVisiblePage$delegate", "hadFirstNotEmptyLayout", "", "lastKnownFirstPageKey", "nearestRangeState", "Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "getNearestRangeState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutNearestRangeState;", "scrollOffset", "getScrollOffset", "setScrollOffset", "scrollOffset$delegate", "getState", "()Landroidx/compose/foundation/pager/PagerState;", "requestPosition", "", "index", "update", "updateFromMeasureResult", "measureResult", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "closestPageToSnapPosition", "Landroidx/compose/foundation/pager/PageInfo;", "density", "Landroidx/compose/ui/unit/Density;", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nPagerScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,136:1\n75#2:137\n108#2,2:138\n75#2:140\n108#2,2:141\n75#2:143\n108#2,2:144\n1#3:146\n171#4,13:147\n*S KotlinDebug\n*F\n+ 1 PagerScrollPosition.kt\nandroidx/compose/foundation/pager/PagerScrollPosition\n*L\n40#1:137\n40#1:138,2\n41#1:140\n41#1:141,2\n43#1:143\n43#1:144,2\n84#1:147,13\n*E\n"})
public final class PagerScrollPosition {
    @NotNull
    private final PagerState state;
    @NotNull
    private final MutableIntState firstVisiblePage$delegate;
    @NotNull
    private final MutableIntState currentPage$delegate;
    @NotNull
    private final MutableIntState scrollOffset$delegate;
    private boolean hadFirstNotEmptyLayout;
    @Nullable
    private Object lastKnownFirstPageKey;
    @NotNull
    private final LazyLayoutNearestRangeState nearestRangeState;

    public PagerScrollPosition(int initialPage, int initialScrollOffset, @NotNull PagerState state) {
        this.state = state;
        this.firstVisiblePage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialPage);
        this.currentPage$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialPage);
        this.scrollOffset$delegate = SnapshotIntStateKt.mutableIntStateOf((int)initialScrollOffset);
        this.nearestRangeState = new LazyLayoutNearestRangeState(initialPage, 30, 100);
    }

    public /* synthetic */ PagerScrollPosition(int n, int n2, PagerState pagerState, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2, pagerState);
    }

    @NotNull
    public final PagerState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFirstVisiblePage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.firstVisiblePage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFirstVisiblePage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.firstVisiblePage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getCurrentPage() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCurrentPage(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getScrollOffset() {
        void $this$getValue$iv;
        IntState intState = (IntState)this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setScrollOffset(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    @NotNull
    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    public final void updateFromMeasureResult(@NotNull PagerMeasureResult measureResult) {
        block2: {
            MeasuredPage measuredPage = measureResult.getFirstVisiblePage();
            Object object = this.lastKnownFirstPageKey = measuredPage != null ? measuredPage.getKey() : null;
            if (!this.hadFirstNotEmptyLayout && !(!((Collection)measureResult.getVisiblePagesInfo()).isEmpty())) break block2;
            this.hadFirstNotEmptyLayout = true;
            int scrollOffset = measureResult.getFirstVisiblePageOffset();
            if (!((float)scrollOffset >= 0.0f)) {
                boolean bl = false;
                String string = "scrollOffset should be non-negative (" + scrollOffset + ')';
                throw new IllegalStateException(string.toString());
            }
            MeasuredPage measuredPage2 = measureResult.getFirstVisiblePage();
            this.update(measuredPage2 != null ? measuredPage2.getIndex() : 0, scrollOffset);
            PageInfo pageInfo = this.closestPageToSnapPosition(measureResult, this.state.getDensity$foundation_release());
            if (pageInfo != null) {
                int it = pageInfo.getIndex();
                boolean bl = false;
                this.setCurrentPage(it);
            }
        }
    }

    private final PageInfo closestPageToSnapPosition(PagerMeasureResult $this$closestPageToSnapPosition, Density density) {
        PageInfo pageInfo;
        int viewPortSize = $this$closestPageToSnapPosition.getOrientation() == Orientation.Vertical ? IntSize.getHeight-impl((long)$this$closestPageToSnapPosition.getViewportSize-YbymL2g()) : IntSize.getWidth-impl((long)$this$closestPageToSnapPosition.getViewportSize-YbymL2g());
        Density $this$closestPageToSnapPosition_u24lambda_u243 = density;
        boolean bl = false;
        List<PageInfo> $this$fastMaxBy$iv = $this$closestPageToSnapPosition.getVisiblePagesInfo();
        boolean $i$f$fastMaxBy = false;
        if ($this$fastMaxBy$iv.isEmpty()) {
            pageInfo = null;
        } else {
            PageInfo maxElem$iv;
            PageInfo it = maxElem$iv = $this$fastMaxBy$iv.get(0);
            boolean bl2 = false;
            float maxValue$iv = -Math.abs(SnapPositionInLayoutKt.calculateDistanceToDesiredSnapPosition($this$closestPageToSnapPosition_u24lambda_u243, viewPortSize, $this$closestPageToSnapPosition.getBeforeContentPadding(), $this$closestPageToSnapPosition.getAfterContentPadding(), $this$closestPageToSnapPosition.getPageSize() + $this$closestPageToSnapPosition.getPageSpacing(), it.getOffset(), it.getIndex(), PagerStateKt.getSnapAlignmentStartToStart()));
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
            if (i$iv <= n) {
                while (true) {
                    PageInfo e$iv;
                    PageInfo it2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                    $i$a$-fastMaxBy-PagerScrollPosition$closestPageToSnapPosition$1$1 = false;
                    float v$iv = -Math.abs(SnapPositionInLayoutKt.calculateDistanceToDesiredSnapPosition($this$closestPageToSnapPosition_u24lambda_u243, viewPortSize, $this$closestPageToSnapPosition.getBeforeContentPadding(), $this$closestPageToSnapPosition.getAfterContentPadding(), $this$closestPageToSnapPosition.getPageSize() + $this$closestPageToSnapPosition.getPageSpacing(), it2.getOffset(), it2.getIndex(), PagerStateKt.getSnapAlignmentStartToStart()));
                    if (Float.compare(maxValue$iv, v$iv) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            pageInfo = maxElem$iv;
        }
        return pageInfo;
    }

    public final void requestPosition(int index2, int scrollOffset) {
        this.update(index2, scrollOffset);
        this.lastKnownFirstPageKey = null;
    }

    private final void update(int index2, int scrollOffset) {
        if (!((float)index2 >= 0.0f)) {
            boolean bl = false;
            String string = "Index should be non-negative (" + index2 + ')';
            throw new IllegalArgumentException(string.toString());
        }
        this.setFirstVisiblePage(index2);
        this.nearestRangeState.update(index2);
        this.setScrollOffset(scrollOffset);
    }
}

