/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input.internal;

import androidx.compose.foundation.text.StringHelpers_androidKt;
import androidx.compose.foundation.text2.input.internal.BackspaceCommand;
import androidx.compose.foundation.text2.input.internal.CommitTextCommand;
import androidx.compose.foundation.text2.input.internal.DeleteAllCommand;
import androidx.compose.foundation.text2.input.internal.DeleteSurroundingTextCommand;
import androidx.compose.foundation.text2.input.internal.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.foundation.text2.input.internal.EditCommand;
import androidx.compose.foundation.text2.input.internal.EditingBuffer;
import androidx.compose.foundation.text2.input.internal.FinishComposingTextCommand;
import androidx.compose.foundation.text2.input.internal.MoveCursorCommand;
import androidx.compose.foundation.text2.input.internal.SetComposingRegionCommand;
import androidx.compose.foundation.text2.input.internal.SetComposingTextCommand;
import androidx.compose.foundation.text2.input.internal.SetSelectionCommand;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a8\u0006 "}, d2={"isSurrogatePair", "", "high", "", "low", "applyBackspaceCommand", "", "Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "applyCommitTextCommand", "commitTextCommand", "Landroidx/compose/foundation/text2/input/internal/CommitTextCommand;", "applyDeleteSurroundingTextCommand", "deleteSurroundingTextCommand", "Landroidx/compose/foundation/text2/input/internal/DeleteSurroundingTextCommand;", "applyDeleteSurroundingTextInCodePointsCommand", "deleteSurroundingTextInCodePointsCommand", "Landroidx/compose/foundation/text2/input/internal/DeleteSurroundingTextInCodePointsCommand;", "applyMoveCursorCommand", "moveCursorCommand", "Landroidx/compose/foundation/text2/input/internal/MoveCursorCommand;", "applySetComposingRegionCommand", "setComposingRegionCommand", "Landroidx/compose/foundation/text2/input/internal/SetComposingRegionCommand;", "applySetComposingTextCommand", "setComposingTextCommand", "Landroidx/compose/foundation/text2/input/internal/SetComposingTextCommand;", "applySetSelectionCommand", "setSelectionCommand", "Landroidx/compose/foundation/text2/input/internal/SetSelectionCommand;", "update", "editCommand", "Landroidx/compose/foundation/text2/input/internal/EditCommand;", "foundation_release"})
@SourceDebugExtension(value={"SMAP\nApplyEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyEditCommand.kt\nandroidx/compose/foundation/text2/input/internal/ApplyEditCommandKt\n+ 2 MathUtils.kt\nandroidx/compose/foundation/text2/input/internal/MathUtilsKt\n*L\n1#1,243:1\n23#2,3:244\n32#2,4:247\n*S KotlinDebug\n*F\n+ 1 ApplyEditCommand.kt\nandroidx/compose/foundation/text2/input/internal/ApplyEditCommandKt\n*L\n180#1:244,3\n185#1:247,4\n*E\n"})
public final class ApplyEditCommandKt {
    public static final void update(@NotNull EditingBuffer $this$update, @NotNull EditCommand editCommand) {
        EditCommand editCommand2 = editCommand;
        if (editCommand2 instanceof BackspaceCommand) {
            ApplyEditCommandKt.applyBackspaceCommand($this$update);
        } else if (editCommand2 instanceof CommitTextCommand) {
            ApplyEditCommandKt.applyCommitTextCommand($this$update, (CommitTextCommand)editCommand);
        } else if (editCommand2 instanceof DeleteAllCommand) {
            $this$update.replace(0, $this$update.getLength(), "");
        } else if (editCommand2 instanceof DeleteSurroundingTextCommand) {
            ApplyEditCommandKt.applyDeleteSurroundingTextCommand($this$update, (DeleteSurroundingTextCommand)editCommand);
        } else if (editCommand2 instanceof DeleteSurroundingTextInCodePointsCommand) {
            ApplyEditCommandKt.applyDeleteSurroundingTextInCodePointsCommand($this$update, (DeleteSurroundingTextInCodePointsCommand)editCommand);
        } else if (editCommand2 instanceof FinishComposingTextCommand) {
            $this$update.commitComposition();
        } else if (editCommand2 instanceof MoveCursorCommand) {
            ApplyEditCommandKt.applyMoveCursorCommand($this$update, (MoveCursorCommand)editCommand);
        } else if (editCommand2 instanceof SetComposingRegionCommand) {
            ApplyEditCommandKt.applySetComposingRegionCommand($this$update, (SetComposingRegionCommand)editCommand);
        } else if (editCommand2 instanceof SetComposingTextCommand) {
            ApplyEditCommandKt.applySetComposingTextCommand($this$update, (SetComposingTextCommand)editCommand);
        } else if (editCommand2 instanceof SetSelectionCommand) {
            ApplyEditCommandKt.applySetSelectionCommand($this$update, (SetSelectionCommand)editCommand);
        }
    }

    private static final void applySetSelectionCommand(EditingBuffer $this$applySetSelectionCommand, SetSelectionCommand setSelectionCommand) {
        int clampedEnd;
        int clampedStart = RangesKt.coerceIn((int)setSelectionCommand.getStart(), (int)0, (int)$this$applySetSelectionCommand.getLength());
        if (clampedStart < (clampedEnd = RangesKt.coerceIn((int)setSelectionCommand.getEnd(), (int)0, (int)$this$applySetSelectionCommand.getLength()))) {
            $this$applySetSelectionCommand.setSelection(clampedStart, clampedEnd);
        } else {
            $this$applySetSelectionCommand.setSelection(clampedEnd, clampedStart);
        }
    }

    private static final void applySetComposingTextCommand(EditingBuffer $this$applySetComposingTextCommand, SetComposingTextCommand setComposingTextCommand) {
        String text = setComposingTextCommand.getText();
        int newCursorPosition = setComposingTextCommand.getNewCursorPosition();
        if ($this$applySetComposingTextCommand.hasComposition()) {
            int compositionStart = $this$applySetComposingTextCommand.getCompositionStart();
            $this$applySetComposingTextCommand.replace(compositionStart, $this$applySetComposingTextCommand.getCompositionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                $this$applySetComposingTextCommand.setComposition(compositionStart, compositionStart + text.length());
            }
        } else {
            int selectionStart = $this$applySetComposingTextCommand.getSelectionStart();
            $this$applySetComposingTextCommand.replace(selectionStart, $this$applySetComposingTextCommand.getSelectionEnd(), text);
            if (((CharSequence)text).length() > 0) {
                $this$applySetComposingTextCommand.setComposition(selectionStart, selectionStart + text.length());
            }
        }
        int newCursor = $this$applySetComposingTextCommand.getCursor();
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : newCursor + newCursorPosition - text.length();
        $this$applySetComposingTextCommand.setCursor(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$applySetComposingTextCommand.getLength()));
    }

    private static final void applySetComposingRegionCommand(EditingBuffer $this$applySetComposingRegionCommand, SetComposingRegionCommand setComposingRegionCommand) {
        int clampedEnd;
        int clampedStart;
        if ($this$applySetComposingRegionCommand.hasComposition()) {
            $this$applySetComposingRegionCommand.commitComposition();
        }
        if ((clampedStart = RangesKt.coerceIn((int)setComposingRegionCommand.getStart(), (int)0, (int)$this$applySetComposingRegionCommand.getLength())) != (clampedEnd = RangesKt.coerceIn((int)setComposingRegionCommand.getEnd(), (int)0, (int)$this$applySetComposingRegionCommand.getLength()))) {
            if (clampedStart < clampedEnd) {
                $this$applySetComposingRegionCommand.setComposition(clampedStart, clampedEnd);
            } else {
                $this$applySetComposingRegionCommand.setComposition(clampedEnd, clampedStart);
            }
        }
    }

    private static final void applyMoveCursorCommand(EditingBuffer $this$applyMoveCursorCommand, MoveCursorCommand moveCursorCommand) {
        if ($this$applyMoveCursorCommand.getCursor() == -1) {
            $this$applyMoveCursorCommand.setCursor($this$applyMoveCursorCommand.getSelectionStart());
        }
        int newCursor = $this$applyMoveCursorCommand.getSelectionStart();
        String bufferText = $this$applyMoveCursorCommand.toString();
        if (moveCursorCommand.getAmount() > 0) {
            int next;
            int n = moveCursorCommand.getAmount();
            for (int i = 0; i < n && (next = StringHelpers_androidKt.findFollowingBreak(bufferText, newCursor)) != -1; ++i) {
                newCursor = next;
            }
        } else {
            int prev;
            int n = -moveCursorCommand.getAmount();
            for (int i = 0; i < n && (prev = StringHelpers_androidKt.findPrecedingBreak(bufferText, newCursor)) != -1; ++i) {
                newCursor = prev;
            }
        }
        $this$applyMoveCursorCommand.setCursor(newCursor);
    }

    private static final void applyDeleteSurroundingTextInCodePointsCommand(EditingBuffer $this$applyDeleteSurroundingTextInCodePointsCommand, DeleteSurroundingTextInCodePointsCommand deleteSurroundingTextInCodePointsCommand) {
        int beforeLenInChars = 0;
        int n = deleteSurroundingTextInCodePointsCommand.getLengthBeforeCursor();
        for (int i = 0; i < n; ++i) {
            char trail;
            char lead;
            if ($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart() > ++beforeLenInChars && ApplyEditCommandKt.isSurrogatePair(lead = $this$applyDeleteSurroundingTextInCodePointsCommand.get($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart() - beforeLenInChars - 1), trail = $this$applyDeleteSurroundingTextInCodePointsCommand.get($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart() - beforeLenInChars))) {
                ++beforeLenInChars;
            }
            if (beforeLenInChars == $this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart()) break;
        }
        int afterLenInChars = 0;
        int n2 = deleteSurroundingTextInCodePointsCommand.getLengthAfterCursor();
        for (int i = 0; i < n2; ++i) {
            char trail;
            char lead;
            if ($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd() + ++afterLenInChars < $this$applyDeleteSurroundingTextInCodePointsCommand.getLength() && ApplyEditCommandKt.isSurrogatePair(lead = $this$applyDeleteSurroundingTextInCodePointsCommand.get($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd() + afterLenInChars - 1), trail = $this$applyDeleteSurroundingTextInCodePointsCommand.get($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd() + afterLenInChars))) {
                ++afterLenInChars;
            }
            if ($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd() + afterLenInChars == $this$applyDeleteSurroundingTextInCodePointsCommand.getLength()) break;
        }
        $this$applyDeleteSurroundingTextInCodePointsCommand.delete($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd(), $this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionEnd() + afterLenInChars);
        $this$applyDeleteSurroundingTextInCodePointsCommand.delete($this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart() - beforeLenInChars, $this$applyDeleteSurroundingTextInCodePointsCommand.getSelectionStart());
    }

    /*
     * WARNING - void declaration
     */
    private static final void applyDeleteSurroundingTextCommand(EditingBuffer $this$applyDeleteSurroundingTextCommand, DeleteSurroundingTextCommand deleteSurroundingTextCommand) {
        boolean bl;
        void right$iv;
        void $this$subtractExactOrElse$iv;
        int n;
        void $this$addExactOrElse$iv;
        int n2 = $this$applyDeleteSurroundingTextCommand.getSelectionEnd();
        int right$iv2 = deleteSurroundingTextCommand.getLengthAfterCursor();
        int $i$f$addExactOrElse = 0;
        void result$iv = $this$addExactOrElse$iv + right$iv2;
        if ((($this$addExactOrElse$iv ^ result$iv) & (right$iv2 ^ result$iv)) < 0) {
            boolean bl2 = false;
            n = $this$applyDeleteSurroundingTextCommand.getLength();
        } else {
            n = result$iv;
        }
        void end = n;
        $this$applyDeleteSurroundingTextCommand.delete($this$applyDeleteSurroundingTextCommand.getSelectionEnd(), Math.min((int)end, $this$applyDeleteSurroundingTextCommand.getLength()));
        right$iv2 = $this$applyDeleteSurroundingTextCommand.getSelectionStart();
        $i$f$addExactOrElse = deleteSurroundingTextCommand.getLengthBeforeCursor();
        boolean $i$f$subtractExactOrElse = false;
        void result$iv2 = $this$subtractExactOrElse$iv - right$iv;
        if ((($this$subtractExactOrElse$iv ^ right$iv) & ($this$subtractExactOrElse$iv ^ result$iv2)) < 0) {
            boolean bl3 = false;
            bl = false;
        } else {
            bl = result$iv2;
        }
        void start = bl;
        $this$applyDeleteSurroundingTextCommand.delete(Math.max(0, (int)start), $this$applyDeleteSurroundingTextCommand.getSelectionStart());
    }

    private static final void applyBackspaceCommand(EditingBuffer $this$applyBackspaceCommand) {
        if ($this$applyBackspaceCommand.hasComposition()) {
            $this$applyBackspaceCommand.delete($this$applyBackspaceCommand.getCompositionStart(), $this$applyBackspaceCommand.getCompositionEnd());
            return;
        }
        if ($this$applyBackspaceCommand.getCursor() == -1) {
            int delStart = $this$applyBackspaceCommand.getSelectionStart();
            int delEnd = $this$applyBackspaceCommand.getSelectionEnd();
            $this$applyBackspaceCommand.setCursor($this$applyBackspaceCommand.getSelectionStart());
            $this$applyBackspaceCommand.delete(delStart, delEnd);
            return;
        }
        if ($this$applyBackspaceCommand.getCursor() == 0) {
            return;
        }
        int prevCursorPos = StringHelpers_androidKt.findPrecedingBreak($this$applyBackspaceCommand.toString(), $this$applyBackspaceCommand.getCursor());
        $this$applyBackspaceCommand.delete(prevCursorPos, $this$applyBackspaceCommand.getCursor());
    }

    private static final void applyCommitTextCommand(EditingBuffer $this$applyCommitTextCommand, CommitTextCommand commitTextCommand) {
        if ($this$applyCommitTextCommand.hasComposition()) {
            $this$applyCommitTextCommand.replace($this$applyCommitTextCommand.getCompositionStart(), $this$applyCommitTextCommand.getCompositionEnd(), commitTextCommand.getText());
        } else {
            $this$applyCommitTextCommand.replace($this$applyCommitTextCommand.getSelectionStart(), $this$applyCommitTextCommand.getSelectionEnd(), commitTextCommand.getText());
        }
        int newCursor = $this$applyCommitTextCommand.getCursor();
        int newCursorInBuffer = commitTextCommand.getNewCursorPosition() > 0 ? newCursor + commitTextCommand.getNewCursorPosition() - 1 : newCursor + commitTextCommand.getNewCursorPosition() - commitTextCommand.getText().length();
        $this$applyCommitTextCommand.setCursor(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$applyCommitTextCommand.getLength()));
    }

    private static final boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }
}

