/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text2.input;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text2.input.InputTransformation;
import androidx.compose.foundation.text2.input.TextFieldBuffer;
import androidx.compose.foundation.text2.input.TextFieldCharSequence;
import androidx.compose.foundation.text2.input.TextFieldCharSequenceKt;
import androidx.compose.foundation.text2.input.internal.ChangeTracker;
import androidx.compose.foundation.text2.input.internal.EditingBuffer;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001:\u000267B\u001c\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0001J\u001a\u0010\"\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\"\u0010'\u001a\u00020\u001c2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001c0)\u00a2\u0006\u0002\b*H\u0086\bJ;\u0010+\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020&2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0)\u00a2\u0006\u0002\b*H\u0080\b\u00a2\u0006\u0002\b,J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0015\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u0013H\u0001J\b\u00105\u001a\u00020\u0003H\u0016R$\u0010\u0007\u001a\u00020\b8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState;", "", "initialText", "", "initialSelectionInChars", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/String;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "mainBuffer", "Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "getMainBuffer$foundation_release$annotations", "()V", "getMainBuffer$foundation_release", "()Landroidx/compose/foundation/text2/input/internal/EditingBuffer;", "setMainBuffer$foundation_release", "(Landroidx/compose/foundation/text2/input/internal/EditingBuffer;)V", "notifyImeListeners", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/foundation/text2/input/TextFieldState$NotifyImeListener;", "<set-?>", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "text", "getText", "()Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "setText", "(Landroidx/compose/foundation/text2/input/TextFieldCharSequence;)V", "text$delegate", "Landroidx/compose/runtime/MutableState;", "addNotifyImeListener", "", "notifyImeListener", "addNotifyImeListener$foundation_release", "commitEdit", "newValue", "Landroidx/compose/foundation/text2/input/TextFieldBuffer;", "commitEditAsUser", "inputTransformation", "Landroidx/compose/foundation/text2/input/InputTransformation;", "notifyImeOfChanges", "", "edit", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "editAsUser", "editAsUser$foundation_release", "notifyIme", "oldValue", "removeNotifyImeListener", "removeNotifyImeListener$foundation_release", "resetStateAndNotifyIme", "resetStateAndNotifyIme$foundation_release", "startEdit", "value", "toString", "NotifyImeListener", "Saver", "foundation_release"})
@ExperimentalFoundationApi
@Stable
@SourceDebugExtension(value={"SMAP\nTextFieldState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldState.kt\nandroidx/compose/foundation/text2/input/TextFieldState\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,472:1\n1208#2:473\n1187#2,2:474\n81#3:476\n107#3,2:477\n460#4,11:479\n*S KotlinDebug\n*F\n+ 1 TextFieldState.kt\nandroidx/compose/foundation/text2/input/TextFieldState\n*L\n311#1:473\n311#1:474,2\n95#1:476\n95#1:477,2\n317#1:479,11\n*E\n"})
public final class TextFieldState {
    @NotNull
    private EditingBuffer mainBuffer;
    @NotNull
    private final MutableState text$delegate;
    @NotNull
    private final MutableVector<NotifyImeListener> notifyImeListeners;
    public static final int $stable;

    private TextFieldState(String initialText, long initialSelectionInChars) {
        this.mainBuffer = new EditingBuffer(initialText, TextRangeKt.coerceIn-8ffj60Q((long)initialSelectionInChars, (int)0, (int)initialText.length()), null);
        this.text$delegate = SnapshotStateKt.mutableStateOf$default((Object)TextFieldCharSequenceKt.TextFieldCharSequence-FDrldGo(initialText, initialSelectionInChars), null, (int)2, null);
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.notifyImeListeners = new MutableVector((Object[])new NotifyImeListener[capacity$iv$iv], 0);
    }

    public /* synthetic */ TextFieldState(String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            l = TextRange.Companion.getZero-d9O1mEE();
        }
        this(string2, l, null);
    }

    @NotNull
    public final EditingBuffer getMainBuffer$foundation_release() {
        return this.mainBuffer;
    }

    public final void setMainBuffer$foundation_release(@NotNull EditingBuffer editingBuffer) {
        this.mainBuffer = editingBuffer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMainBuffer$foundation_release$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldCharSequence getText() {
        void $this$getValue$iv;
        State state = (State)this.text$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (TextFieldCharSequence)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setText(TextFieldCharSequence textFieldCharSequence) {
        void $this$setValue$iv;
        MutableState mutableState = this.text$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)textFieldCharSequence);
    }

    public final void edit(@NotNull Function1<? super TextFieldBuffer, Unit> block) {
        boolean $i$f$edit = false;
        TextFieldBuffer mutableValue = this.startEdit(this.getText());
        block.invoke((Object)mutableValue);
        this.commitEdit(mutableValue);
    }

    @NotNull
    public String toString() {
        return "TextFieldState(selectionInChars=" + TextRange.toString-impl((long)this.getText().getSelectionInChars-d9O1mEE()) + ", text=\"" + this.getText() + "\")";
    }

    @PublishedApi
    @NotNull
    public final TextFieldBuffer startEdit(@NotNull TextFieldCharSequence value) {
        return new TextFieldBuffer(value, null, null, 6, null);
    }

    @PublishedApi
    public final void commitEdit(@NotNull TextFieldBuffer newValue) {
        boolean selectionChanged;
        boolean textChanged = newValue.getChanges().getChangeCount() > 0;
        boolean bl = selectionChanged = !TextRange.equals-impl0((long)newValue.getSelectionInChars-d9O1mEE(), (long)this.mainBuffer.getSelection-d9O1mEE());
        if (textChanged || selectionChanged) {
            TextFieldCharSequence finalValue = TextFieldBuffer.toTextFieldCharSequence-OEnZFl4$foundation_release$default(newValue, null, 1, null);
            this.resetStateAndNotifyIme$foundation_release(finalValue);
        }
    }

    public final void editAsUser$foundation_release(@Nullable InputTransformation inputTransformation, boolean notifyImeOfChanges, @NotNull Function1<? super EditingBuffer, Unit> block) {
        boolean $i$f$editAsUser$foundation_release = false;
        TextFieldCharSequence previousValue = this.getText();
        this.getMainBuffer$foundation_release().getChangeTracker().clearChanges();
        block.invoke((Object)this.getMainBuffer$foundation_release());
        if (this.getMainBuffer$foundation_release().getChangeTracker().getChangeCount() == 0 && TextRange.equals-impl0((long)previousValue.getSelectionInChars-d9O1mEE(), (long)this.getMainBuffer$foundation_release().getSelection-d9O1mEE()) && Intrinsics.areEqual((Object)previousValue.getCompositionInChars-MzsxiRA(), (Object)this.getMainBuffer$foundation_release().getComposition-MzsxiRA())) {
            return;
        }
        this.commitEditAsUser(inputTransformation, notifyImeOfChanges);
    }

    public static /* synthetic */ void editAsUser$foundation_release$default(TextFieldState $this, InputTransformation inputTransformation, boolean notifyImeOfChanges, Function1 block, int n, Object object) {
        if ((n & 2) != 0) {
            notifyImeOfChanges = true;
        }
        boolean $i$f$editAsUser$foundation_release = false;
        TextFieldCharSequence previousValue = $this.getText();
        $this.getMainBuffer$foundation_release().getChangeTracker().clearChanges();
        block.invoke((Object)$this.getMainBuffer$foundation_release());
        if ($this.getMainBuffer$foundation_release().getChangeTracker().getChangeCount() == 0 && TextRange.equals-impl0((long)previousValue.getSelectionInChars-d9O1mEE(), (long)$this.getMainBuffer$foundation_release().getSelection-d9O1mEE()) && Intrinsics.areEqual((Object)previousValue.getCompositionInChars-MzsxiRA(), (Object)$this.getMainBuffer$foundation_release().getComposition-MzsxiRA())) {
            return;
        }
        $this.commitEditAsUser(inputTransformation, notifyImeOfChanges);
    }

    private final void commitEditAsUser(InputTransformation inputTransformation, boolean notifyImeOfChanges) {
        TextFieldCharSequence afterEditValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mainBuffer.toString(), this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        if (inputTransformation == null) {
            TextFieldCharSequence oldValue = this.getText();
            this.setText(afterEditValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
            return;
        }
        TextFieldCharSequence oldValue = this.getText();
        if (afterEditValue.contentEquals(oldValue) && TextRange.equals-impl0((long)afterEditValue.getSelectionInChars-d9O1mEE(), (long)oldValue.getSelectionInChars-d9O1mEE())) {
            this.setText(afterEditValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
            return;
        }
        ChangeTracker changeTracker = this.mainBuffer.getChangeTracker();
        TextFieldBuffer mutableValue = new TextFieldBuffer(afterEditValue, changeTracker, oldValue);
        inputTransformation.transformInput(oldValue, mutableValue);
        TextFieldCharSequence afterFilterValue = mutableValue.toTextFieldCharSequence-OEnZFl4$foundation_release(afterEditValue.getCompositionInChars-MzsxiRA());
        if (Intrinsics.areEqual((Object)afterFilterValue, (Object)afterEditValue)) {
            this.setText(afterFilterValue);
            if (notifyImeOfChanges) {
                this.notifyIme(oldValue, afterEditValue);
            }
        } else {
            this.resetStateAndNotifyIme$foundation_release(afterFilterValue);
        }
    }

    public final void addNotifyImeListener$foundation_release(@NotNull NotifyImeListener notifyImeListener) {
        this.notifyImeListeners.add((Object)notifyImeListener);
    }

    public final void removeNotifyImeListener$foundation_release(@NotNull NotifyImeListener notifyImeListener) {
        this.notifyImeListeners.remove((Object)notifyImeListener);
    }

    @VisibleForTesting
    public final void resetStateAndNotifyIme$foundation_release(@NotNull TextFieldCharSequence newValue) {
        boolean compositionChanged;
        TextFieldCharSequence bufferState = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(this.mainBuffer.toString(), this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        boolean textChanged = false;
        boolean selectionChanged = false;
        boolean bl = compositionChanged = !Intrinsics.areEqual((Object)newValue.getCompositionInChars-MzsxiRA(), (Object)this.mainBuffer.getComposition-MzsxiRA());
        if (!bufferState.contentEquals(newValue)) {
            this.mainBuffer = new EditingBuffer(((Object)newValue).toString(), newValue.getSelectionInChars-d9O1mEE(), null);
            textChanged = true;
        } else if (!TextRange.equals-impl0((long)bufferState.getSelectionInChars-d9O1mEE(), (long)newValue.getSelectionInChars-d9O1mEE())) {
            this.mainBuffer.setSelection(TextRange.getStart-impl((long)newValue.getSelectionInChars-d9O1mEE()), TextRange.getEnd-impl((long)newValue.getSelectionInChars-d9O1mEE()));
            selectionChanged = true;
        }
        TextRange composition = newValue.getCompositionInChars-MzsxiRA();
        if (composition == null || TextRange.getCollapsed-impl((long)composition.unbox-impl())) {
            this.mainBuffer.commitComposition();
        } else {
            this.mainBuffer.setComposition(TextRange.getMin-impl((long)composition.unbox-impl()), TextRange.getMax-impl((long)composition.unbox-impl()));
        }
        if (textChanged || !selectionChanged && compositionChanged) {
            this.mainBuffer.commitComposition();
        }
        TextFieldCharSequence finalValue = TextFieldCharSequenceKt.TextFieldCharSequence-3r_uNRQ(textChanged ? newValue : bufferState, this.mainBuffer.getSelection-d9O1mEE(), this.mainBuffer.getComposition-MzsxiRA());
        this.setText(finalValue);
        this.notifyIme(bufferState, finalValue);
    }

    private final void notifyIme(TextFieldCharSequence oldValue, TextFieldCharSequence newValue) {
        MutableVector<NotifyImeListener> this_$iv = this.notifyImeListeners;
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                NotifyImeListener it = (NotifyImeListener)content$iv[i$iv];
                boolean bl = false;
                it.onChange(oldValue, newValue);
            } while (++i$iv < size$iv);
        }
    }

    public /* synthetic */ TextFieldState(String initialText, long initialSelectionInChars, DefaultConstructorMarker $constructor_marker) {
        this(initialText, initialSelectionInChars);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState$NotifyImeListener;", "", "onChange", "", "oldValue", "Landroidx/compose/foundation/text2/input/TextFieldCharSequence;", "newValue", "foundation_release"})
    public static interface NotifyImeListener {
        public void onChange(@NotNull TextFieldCharSequence var1, @NotNull TextFieldCharSequence var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Landroidx/compose/foundation/text2/input/TextFieldState$Saver;", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text2/input/TextFieldState;", "", "()V", "restore", "value", "save", "Landroidx/compose/runtime/saveable/SaverScope;", "foundation_release"})
    @StabilityInferred(parameters=0)
    public static final class Saver
    implements androidx.compose.runtime.saveable.Saver<TextFieldState, Object> {
        @NotNull
        public static final Saver INSTANCE = new Saver();
        public static final int $stable;

        private Saver() {
        }

        @Nullable
        public Object save(@NotNull SaverScope $this$save, @NotNull TextFieldState value) {
            Object[] objectArray = new Object[]{((Object)value.getText()).toString(), TextRange.getStart-impl((long)value.getText().getSelectionInChars-d9O1mEE()), TextRange.getEnd-impl((long)value.getText().getSelectionInChars-d9O1mEE())};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Nullable
        public TextFieldState restore(@NotNull Object value) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List list = (List)value;
            Object text = list.get(0);
            Object selectionStart = list.get(1);
            Object selectionEnd = list.get(2);
            Intrinsics.checkNotNull(text, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = (String)text;
            Intrinsics.checkNotNull(selectionStart, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)selectionStart;
            Intrinsics.checkNotNull(selectionEnd, (String)"null cannot be cast to non-null type kotlin.Int");
            return new TextFieldState(string2, TextRangeKt.TextRange((int)n, (int)((Integer)selectionEnd)), null);
        }
    }
}

